/**
 * Data made by Günter Rote with a python program
 */
 
POLYHEDRA = {


Gill1 : {
"name":"Gill#1 ()",
"category":["Gillcubes"],
"cell":[[0,0,0], [1,1,1], [0,0,1], [0,1,1], [0,1,0], [1,0,0], [1,1,0], [1,1,2]],
"vertex":[[0,-1,-1.5],[0,-1,-0.5],[-1,1,0.5],[0,0,0.5],[1,-1,-1.5],[-1,-1,0.5],[0,1,-0.5],[1,-1,-0.5],[1,0,0.5],[1,1,-0.5],[1,1,-1.5],[0,1,1.5],[-1,1,-0.5],[-1,1,-1.5],[0,0,-1.5],[0,0,-0.5],[1,0,-0.5],[1,0,-1.5],[-1,-1,-1.5],[-1,-1,-0.5],[1,1,1.5],[-1,0,0.5],[0,1,0.5],[0,-1,0.5],[0,0,1.5],[1,1,0.5],[1,0,1.5],[-1,0,-1.5],[-1,0,-0.5],[0,1,-1.5]],
"edge":[[26,20],[23,22],[15,24],[5,23],[24,11],[4,7],[15,16],[10,20],[18,13],[22,11],[18,4],[18,5],[2,22],[1,23],[1,15],[1,7],[16,26],[13,2],[5,2],[11,20],[13,10],[7,16],[4,10],[24,26],[14,15],[28,15],[29,22],[22,25],[0,1],[15,6],[19,1],[17,16],[16,9],[0,29],[21,8],[12,9],[27,17],[19,12],[27,21],[8,25]],
"numthickedges":24,
"face":[[19,28,27,18],[5,21,28,19],[21,2,12,28],[28,12,13,27],[18,0,1,19],[19,1,23,5],[0,4,7,1],[27,14,0,18],[13,29,14,27],[14,17,4,0],[29,10,17,14],[16,9,25,8],[4,17,16,7],[17,10,9,16],[8,25,20,26],[15,16,8,3],[3,8,26,24],[22,25,9,6],[2,22,6,12],[12,6,29,13],[6,9,10,29],[11,20,25,22],[1,15,3,23],[5,23,3,21],[21,3,22,2],[1,7,16,15],[24,11,22,3],[24,26,20,11]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,1,1,1,1,-2,-2,2,2,2,2,2,1,3,3,3,-1,3]},

Gill2 : {
"name":"Gill#2 ()",
"category":["Gillcubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [0,1,0], [1,0,0], [1,1,0], [2,2,-1]],
"vertex":[[0.5,1.5,-2.5],[-0.5,-1.5,-1.5],[-0.5,-1.5,-0.5],[-1.5,0.5,0.5],[1.5,1.5,-2.5],[1.5,0.5,-1.5],[-0.5,-0.5,0.5],[0.5,-1.5,-1.5],[-1.5,-1.5,0.5],[0.5,-1.5,-0.5],[-0.5,0.5,-0.5],[0.5,0.5,-0.5],[0.5,0.5,-1.5],[-1.5,0.5,-0.5],[-1.5,0.5,-1.5],[1.5,0.5,-2.5],[-0.5,-0.5,-0.5],[-0.5,-0.5,-1.5],[0.5,-0.5,-0.5],[0.5,-0.5,-1.5],[0.5,0.5,-2.5],[-1.5,-1.5,-1.5],[-1.5,-1.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,0.5],[0.5,1.5,-1.5],[-0.5,-1.5,0.5],[1.5,1.5,-1.5],[-1.5,-0.5,-1.5],[-1.5,-0.5,-0.5],[-0.5,0.5,-1.5]],
"edge":[[8,26],[10,24],[26,24],[7,9],[9,11],[25,27],[5,27],[0,4],[10,11],[21,14],[20,11],[21,7],[7,25],[21,8],[3,24],[15,4],[2,26],[2,9],[15,5],[4,27],[0,25],[14,3],[20,0],[14,5],[8,3],[20,15],[2,10],[30,10],[13,10],[1,2],[22,2],[1,30],[17,6],[23,6],[29,18],[19,18],[28,19],[22,13],[28,23]],
"numthickedges":27,
"face":[[22,29,28,21],[8,23,29,22],[23,3,13,29],[29,13,14,28],[21,1,2,22],[22,2,26,8],[1,7,9,2],[28,17,1,21],[14,30,17,28],[17,19,7,1],[30,12,19,17],[2,16,6,26],[16,10,24,6],[8,26,6,23],[23,6,24,3],[3,24,10,13],[13,10,30,14],[10,11,12,30],[7,19,18,9],[19,12,11,18],[2,9,18,16],[16,18,11,10],[12,25,0,20],[15,4,27,5],[20,15,5,12],[25,27,4,0],[0,4,15,20],[12,5,27,25]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,1,1,3,3,2,2,2,1,1,3,3,-1,1,-2,2,-3,3]},

Tri1 : {
"name":"tri#1 (plane, type L)",
"category":["Tricubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[0,-1,-0.5],[0,-1,0.5],[0,0,0.5],[1,0,-0.5],[-1,1,0.5],[-1,1,-0.5],[0,1,-0.5],[1,-1,-0.5],[1,-1,0.5],[-1,0,-0.5],[-1,0,0.5],[0,0,-0.5],[0,1,0.5],[1,0,0.5]],
"edge":[[0,9],[13,4],[6,14],[4,14],[4,15],[0,7],[1,6],[9,5],[7,6],[0,1],[1,10],[9,10],[7,8],[13,8],[10,15],[8,14],[13,5],[5,15],[3,4],[12,4],[2,13],[11,13],[2,3],[11,12]],
"numthickedges":18,
"face":[[1,12,11,0],[12,6,7,11],[0,2,3,1],[2,9,10,3],[11,13,2,0],[7,8,13,11],[13,5,9,2],[1,3,4,12],[12,4,14,6],[3,10,15,4],[13,8,14,4],[6,14,8,7],[9,5,15,10],[4,15,5,13]],
"facedirection":[-1,-1,-2,-2,-3,-3,-3,3,3,3,1,2,1,2]},

Tri2 : {
"name":"tri#2 (plane, type I)",
"category":["Tricubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0]],
"vertex":[[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,-0.5,-0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,-0.5,0.5],[-0.5,0.5,0.5],[1.5,0.5,-0.5],[1.5,0.5,0.5],[0.5,0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,0.5,-0.5],[-1.5,0.5,0.5],[-0.5,0.5,-0.5],[0.5,0.5,0.5]],
"edge":[[1,4],[1,13],[0,3],[7,8],[3,7],[13,8],[0,1],[12,13],[3,4],[12,7],[0,12],[4,8],[2,14],[14,6],[10,11],[9,15],[5,6],[2,5],[10,9],[11,15]],
"numthickedges":12,
"face":[[1,13,12,0],[0,2,5,1],[2,10,11,5],[10,3,4,11],[13,6,14,12],[6,15,9,14],[15,8,7,9],[12,14,2,0],[14,9,10,2],[9,7,3,10],[1,5,6,13],[5,11,15,6],[11,4,8,15],[3,7,8,4]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,3,3,3,1]},

Tetra1 : {
"name":"tetra#1 (plane, type o)",
"category":["Tetracubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0]],
"vertex":[[-1,-1,-0.5],[1,1,-0.5],[-1,-1,0.5],[0,-1,-0.5],[0,-1,0.5],[0,0,0.5],[1,0,-0.5],[-1,1,0.5],[-1,1,-0.5],[0,1,-0.5],[1,-1,-0.5],[1,-1,0.5],[-1,0,-0.5],[-1,0,0.5],[0,0,-0.5],[1,1,0.5],[0,1,0.5],[1,0,0.5]],
"edge":[[0,10],[0,8],[2,7],[10,1],[8,7],[0,2],[2,11],[10,11],[8,1],[7,15],[1,15],[11,15],[3,9],[14,5],[4,16],[9,16],[13,17],[6,17],[12,6],[3,4],[12,13]],
"numthickedges":12,
"face":[[2,13,12,0],[13,7,8,12],[0,3,4,2],[3,10,11,4],[12,14,3,0],[8,9,14,12],[14,6,10,3],[9,1,6,14],[2,4,5,13],[13,5,16,7],[4,11,17,5],[5,17,15,16],[7,16,9,8],[16,15,1,9],[10,6,17,11],[6,1,15,17]],
"facedirection":[-1,-1,-2,-2,-3,-3,-3,-3,3,3,3,3,2,2,1,1]},

Tetra2 : {
"name":"tetra#2 (plane, type l)",
"category":["Tetracubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[1.5,-1,-0.5],[1.5,-1,0.5],[-1.5,1,0.5],[-1.5,1,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,-0.5],[1.5,0,0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[9,16],[14,6],[13,5],[10,9],[15,16],[5,15],[7,4],[9,4],[13,8],[14,7],[8,7],[13,14],[5,6],[19,4],[8,19],[10,19],[10,15],[6,16],[18,9],[1,9],[0,10],[17,10],[2,3],[11,12],[0,1],[2,11],[3,12],[17,18]],
"numthickedges":18,
"face":[[14,18,17,13],[18,7,8,17],[13,0,1,14],[0,2,3,1],[2,5,6,3],[17,10,0,13],[8,19,10,17],[10,11,2,0],[11,15,5,2],[14,1,9,18],[18,9,4,7],[1,3,12,9],[3,6,16,12],[10,19,4,9],[7,4,19,8],[9,12,11,10],[12,16,15,11],[5,15,16,6]],
"facedirection":[-1,-1,-2,-2,-2,-3,-3,-3,-3,3,3,3,3,1,2,2,2,1]},

Tetra3 : {
"name":"tetra#3 (plane, type t)",
"category":["Tetracubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[1.5,-1,-0.5],[0.5,1,-0.5],[1.5,-1,0.5],[0.5,1,0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,-0.5],[1.5,0,0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[13,5],[10,9],[15,16],[9,4],[19,4],[10,19],[5,15],[17,10],[11,15],[4,8],[5,7],[11,12],[6,8],[18,9],[12,16],[14,18],[13,17],[14,7],[19,6],[11,6],[12,8],[13,14],[17,18],[7,16],[1,9],[0,10],[10,11],[9,12],[2,11],[3,12],[2,3],[0,1]],
"numthickedges":24,
"face":[[14,18,17,13],[13,0,1,14],[0,2,3,1],[2,5,7,3],[18,9,10,17],[12,16,15,11],[17,10,0,13],[10,11,2,0],[19,6,11,10],[11,15,5,2],[14,1,9,18],[1,3,12,9],[9,12,8,4],[3,7,16,12],[9,4,19,10],[11,6,8,12],[4,8,6,19],[5,15,16,7]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,3,3,3,3,-1,1,2,1]},

Tetra4 : {
"name":"tetra#4 (plane, type n)",
"category":["Tetracubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[1.5,1,0.5],[1.5,1,-0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[0.5,1,-0.5],[0.5,1,0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[10,9],[16,15],[9,6],[4,5],[19,6],[14,5],[10,19],[17,10],[11,16],[11,12],[13,4],[18,9],[12,15],[14,18],[15,2],[13,17],[4,11],[19,3],[16,3],[3,2],[6,2],[5,12],[13,14],[17,18],[1,9],[0,10],[10,11],[9,12],[11,7],[12,8],[7,8],[0,1]],
"numthickedges":24,
"face":[[14,18,17,13],[13,0,1,14],[0,4,5,1],[18,9,10,17],[17,10,0,13],[10,11,4,0],[19,7,11,10],[7,3,16,11],[14,1,9,18],[1,5,12,9],[9,12,8,6],[12,15,2,8],[4,11,12,5],[9,6,19,10],[6,8,7,19],[8,2,3,7],[16,3,2,15],[11,16,15,12]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,3,3,3,3,1,-1,2,2,1,-2]},

Tetra5 : {
"name":"tetra#5 (plane, type i)",
"category":["Tetracubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-0.5,-0.5],[-1,-0.5,0.5],[2,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[2,0.5,0.5],[2,0.5,-0.5],[1,-0.5,-0.5],[1,-0.5,0.5],[-1,0.5,0.5],[-1,0.5,-0.5],[0,0.5,-0.5],[0,0.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[1,0.5,-0.5],[1,0.5,0.5],[-2,0.5,-0.5],[-2,0.5,0.5],[2,-0.5,0.5]],
"edge":[[14,18],[14,19],[13,2],[18,5],[17,6],[19,5],[13,14],[17,18],[2,19],[6,5],[2,6],[13,17],[0,10],[10,9],[15,16],[3,4],[7,15],[11,12],[7,8],[1,9],[0,1],[3,11],[8,16],[4,12]],
"numthickedges":12,
"face":[[14,18,17,13],[13,0,1,14],[0,3,4,1],[3,7,8,4],[7,2,19,8],[18,9,10,17],[9,12,11,10],[12,16,15,11],[16,5,6,15],[17,10,0,13],[10,11,3,0],[11,15,7,3],[15,6,2,7],[14,1,9,18],[1,4,12,9],[4,8,16,12],[8,19,5,16],[2,6,5,19]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,3,3,3,3,1]},

Tetra6 : {
"name":"tetra#6 (symmetric)",
"category":["Tetracubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0]],
"vertex":[[0,-1,-1],[0,-1,0],[0,0,1],[1,-1,-1],[-1,-1,1],[1,-1,0],[0,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,-1],[1,0,0],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[16,2],[10,2],[4,16],[1,6],[4,15],[8,7],[3,5],[19,6],[10,19],[15,2],[18,12],[13,8],[11,12],[13,3],[13,4],[1,16],[10,11],[18,15],[1,5],[18,7],[3,11],[8,19],[7,6],[5,12],[0,10],[0,1],[17,10],[17,18],[14,1],[14,18]],
"numthickedges":24,
"face":[[14,18,17,13],[4,15,18,14],[18,7,8,17],[13,0,1,14],[14,1,16,4],[0,3,5,1],[17,10,0,13],[8,19,10,17],[10,11,3,0],[1,9,2,16],[10,19,6,9],[15,2,9,18],[9,12,11,10],[4,16,2,15],[7,6,19,8],[18,9,6,7],[1,5,12,9],[3,11,12,5]],
"facedirection":[-1,-1,-1,-2,-2,-2,-3,-3,-3,1,1,2,2,3,2,3,3,1]},

Tetra7 : {
"name":"tetra#7 (mirror of #8, 1st)",
"category":["Tetracubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1]],
"vertex":[[0,-1,-1],[0,-1,0],[0,0,1],[1,-1,0],[-1,-1,1],[0,1,0],[1,0,1],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,0],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,-1,1],[1,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[1,5],[12,0],[4,14],[8,7],[19,5],[18,11],[14,6],[12,8],[12,4],[4,16],[18,14],[0,1],[1,3],[18,7],[0,19],[11,6],[16,6],[8,19],[7,5],[3,11],[3,16],[17,18],[1,15],[13,1],[13,18],[10,2],[15,2],[17,10]],
"numthickedges":21,
"face":[[13,18,17,12],[4,14,18,13],[18,7,8,17],[0,10,9,1],[10,19,5,9],[12,0,1,13],[13,1,15,4],[1,3,16,15],[17,10,0,12],[8,19,10,17],[14,2,9,18],[2,6,11,9],[4,15,2,14],[15,16,6,2],[7,5,19,8],[18,9,5,7],[3,11,6,16],[9,11,3,1]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-3,-3,2,2,3,3,2,3,1,-3]},

Tetra8 : {
"name":"tetra#8 (mirror of #7, 2nd)",
"category":["Tetracubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0]],
"vertex":[[0,-1,-1],[0,-1,0],[0,0,1],[-1,-1,1],[0,1,0],[1,1,-1],[1,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,-1],[1,0,0],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[0,10],[16,2],[10,2],[3,16],[13,0],[3,15],[8,7],[18,12],[0,16],[15,2],[13,8],[5,6],[11,12],[13,3],[10,11],[18,15],[18,7],[7,6],[11,5],[8,5],[12,6],[10,19],[17,10],[17,18],[14,18],[1,4],[19,4],[14,1]],
"numthickedges":21,
"face":[[14,18,17,13],[3,15,18,14],[18,7,8,17],[0,10,9,1],[1,9,2,16],[13,0,1,14],[14,1,16,3],[17,10,0,13],[8,19,10,17],[19,5,11,10],[15,2,9,18],[3,16,2,15],[7,4,19,8],[4,6,5,19],[18,9,4,7],[9,12,6,4],[11,5,6,12],[10,11,12,9]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,2,3,2,2,3,3,1,-2]},

Penta1 : {
"name":"penta#1 (plane, type V)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[1.5,-1.5,-0.5],[1.5,-1.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[16,2],[15,3],[16,8],[15,7],[11,18],[2,19],[7,17],[12,11],[20,19],[17,18],[12,20],[3,20],[3,2],[15,16],[7,8],[11,19],[12,17],[8,18],[22,11],[0,12],[1,11],[21,12],[10,9],[23,6],[4,5],[13,14],[0,1],[4,13],[10,23],[9,6],[5,14],[21,22]],
"numthickedges":18,
"face":[[16,22,21,15],[22,9,10,21],[9,2,3,10],[15,0,1,16],[0,4,5,1],[4,7,8,5],[21,12,0,15],[10,23,12,21],[3,20,23,10],[12,13,4,0],[13,17,7,4],[16,1,11,22],[22,11,6,9],[9,6,19,2],[1,5,14,11],[5,8,18,14],[12,23,6,11],[23,20,19,6],[2,19,20,3],[11,14,13,12],[14,18,17,13],[7,17,18,8]],
"facedirection":[-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,3,3,3,3,3,1,1,2,2,2,1]},

Penta2 : {
"name":"penta#2 (plane, type T)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[-0.5,0.5,0.5],[0.5,0.5,-0.5],[0.5,0.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[16,2],[15,3],[0,12],[23,20],[12,11],[18,17],[15,0],[23,6],[11,17],[12,18],[1,11],[6,19],[17,4],[2,19],[0,1],[3,20],[23,5],[16,1],[18,5],[20,19],[5,4],[6,4],[3,2],[15,16],[12,23],[22,11],[21,12],[11,6],[10,23],[9,6],[10,9],[7,8],[13,14],[13,7],[14,8],[21,22]],
"numthickedges":24,
"face":[[16,22,21,15],[22,9,10,21],[9,2,3,10],[0,12,11,1],[23,20,19,6],[15,0,1,16],[21,12,0,15],[10,23,12,21],[3,20,23,10],[23,7,13,12],[7,5,18,13],[16,1,11,22],[22,11,6,9],[9,6,19,2],[11,14,8,6],[14,17,4,8],[2,19,20,3],[12,13,14,11],[13,18,17,14],[6,8,7,23],[8,4,5,7],[18,5,4,17]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,3,2,-2,-2,2,2,1]},

Penta3 : {
"name":"penta#3 (plane, type P)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[1.5,-1,-0.5],[0.5,1,-0.5],[1.5,-1,0.5],[0.5,1,0.5],[-1.5,1,0.5],[-1.5,1,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,-0.5],[1.5,0,0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[16,7],[15,5],[17,18],[5,17],[13,17],[13,6],[15,10],[16,9],[10,6],[10,9],[15,16],[5,7],[14,8],[9,8],[6,8],[13,14],[14,18],[7,18],[19,13],[2,13],[3,14],[20,14],[0,21],[12,11],[1,4],[21,4],[2,3],[0,1],[19,20]],
"numthickedges":18,
"face":[[16,20,19,15],[20,9,10,19],[15,0,1,16],[0,2,3,1],[2,5,7,3],[19,12,0,15],[10,21,12,19],[12,13,2,0],[21,6,13,12],[13,17,5,2],[16,1,11,20],[20,11,4,9],[1,3,14,11],[11,14,8,4],[3,7,18,14],[9,4,21,10],[4,8,6,21],[13,6,8,14],[5,17,18,7],[14,18,17,13]],
"facedirection":[-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,3,3,3,3,3,2,2,1,1,2]},

Penta4 : {
"name":"penta#4 (plane, type U)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[1.5,1,0.5],[1.5,1,-0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[1.5,-1,-0.5],[1.5,-1,0.5],[0.5,1,0.5],[0.5,1,-0.5],[-1.5,1,0.5],[-1.5,1,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,-0.5],[1.5,0,0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[17,7],[7,3],[14,13],[13,6],[11,6],[9,2],[12,11],[23,6],[14,23],[13,16],[17,12],[7,8],[10,9],[15,16],[14,15],[18,8],[18,11],[8,2],[12,23],[10,3],[3,2],[15,10],[16,9],[17,18],[1,13],[0,14],[22,13],[16,20],[21,14],[15,19],[4,15],[5,16],[19,20],[4,5],[0,1],[21,22]],
"numthickedges":24,
"face":[[18,22,21,17],[22,11,12,21],[17,0,1,18],[0,4,5,1],[4,7,8,5],[21,14,0,17],[12,23,14,21],[14,15,4,0],[15,19,7,4],[10,3,19,15],[18,1,13,22],[22,13,6,11],[1,5,16,13],[5,8,20,16],[16,20,2,9],[14,23,6,13],[11,6,23,12],[9,2,3,10],[13,16,15,14],[7,19,20,8],[19,3,2,20],[16,9,10,15]],
"facedirection":[-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,3,3,3,3,3,1,2,2,2,1,1,-1]},

Penta5 : {
"name":"penta#5 (plane, type L)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[1,-1,0.5],[-2,1,0.5],[-2,1,-0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[18,2],[17,23],[13,7],[11,6],[14,8],[13,6],[14,13],[2,7],[17,12],[18,11],[12,11],[17,18],[23,2],[5,6],[12,5],[14,5],[8,7],[23,8],[22,13],[21,14],[1,13],[0,14],[19,20],[3,4],[9,19],[15,16],[9,10],[0,1],[3,15],[10,20],[4,16],[21,22]],
"numthickedges":18,
"face":[[18,22,21,17],[22,11,12,21],[17,0,1,18],[0,3,4,1],[3,9,10,4],[9,23,2,10],[21,14,0,17],[12,5,14,21],[14,15,3,0],[15,19,9,3],[19,8,23,9],[18,1,13,22],[22,13,6,11],[1,4,16,13],[4,10,20,16],[10,2,7,20],[14,5,6,13],[11,6,5,12],[13,16,15,14],[16,20,19,15],[20,7,8,19],[23,8,7,2]],
"facedirection":[-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,3,3,3,3,3,1,2,2,2,2,1]},

Penta6 : {
"name":"penta#6 (plane, type F)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[-0.5,0.5,0.5],[0.5,0.5,-0.5],[0.5,0.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[-0.5,1.5,-0.5],[-0.5,1.5,0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[0,10],[23,17],[10,9],[16,15],[7,4],[6,2],[13,0],[8,7],[23,4],[9,15],[10,16],[17,19],[1,9],[4,18],[13,8],[5,6],[19,20],[5,19],[6,20],[15,2],[0,1],[14,7],[8,23],[5,3],[14,1],[16,3],[3,2],[17,18],[13,14],[18,20],[10,23],[4,6],[22,9],[21,10],[9,4],[11,5],[12,6],[23,5],[11,12],[21,22]],
"numthickedges":30,
"face":[[14,22,21,13],[22,7,8,21],[0,10,9,1],[13,0,1,14],[21,10,0,13],[8,23,10,21],[23,5,11,10],[17,19,5,23],[5,3,16,11],[14,1,9,22],[22,9,4,7],[9,12,6,4],[4,6,20,18],[12,15,2,6],[7,4,23,8],[6,2,3,5],[10,11,12,9],[11,16,15,12],[4,18,17,23],[5,19,20,6],[18,20,19,17],[16,3,2,15]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,3,2,2,-2,-2,-1,1,2,1]},

Penta7 : {
"name":"penta#7 (plane, type W)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[-0.5,0.5,0.5],[0.5,0.5,-0.5],[0.5,0.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[-0.5,1.5,-0.5],[-0.5,1.5,0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[1.5,1.5,-0.5],[1.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[0,10],[23,15],[10,9],[7,4],[6,2],[13,0],[15,19],[8,7],[23,4],[16,20],[3,19],[9,12],[1,9],[4,16],[13,8],[2,20],[11,12],[5,6],[10,11],[0,1],[14,7],[8,23],[5,3],[14,1],[15,16],[3,2],[11,5],[12,6],[13,14],[19,20],[10,23],[4,6],[22,9],[9,4],[21,10],[23,5],[5,17],[6,18],[17,18],[21,22]],
"numthickedges":30,
"face":[[14,22,21,13],[22,7,8,21],[0,10,9,1],[13,0,1,14],[21,10,0,13],[8,23,10,21],[23,5,11,10],[15,17,5,23],[17,19,3,5],[14,1,9,22],[22,9,4,7],[9,12,6,4],[4,6,18,16],[6,2,20,18],[7,4,23,8],[11,5,6,12],[10,11,12,9],[4,16,15,23],[16,18,17,15],[18,20,19,17],[3,19,20,2],[5,3,2,6]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,3,2,1,-2,-1,2,2,1,-2]},

Penta8 : {
"name":"penta#8 (plane, type Z)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [2,1,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[-0.5,0.5,0.5],[0.5,0.5,-0.5],[0.5,0.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[1.5,1.5,-0.5],[1.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[0,10],[10,9],[16,15],[16,19],[13,0],[8,7],[9,15],[10,16],[17,19],[13,8],[5,6],[17,18],[6,18],[5,17],[1,9],[0,1],[14,7],[7,6],[15,20],[14,1],[18,20],[8,5],[13,14],[19,20],[10,23],[22,9],[21,10],[12,6],[11,5],[9,4],[6,2],[5,3],[23,4],[11,12],[3,2],[21,22]],
"numthickedges":24,
"face":[[14,22,21,13],[22,7,8,21],[0,10,9,1],[13,0,1,14],[21,10,0,13],[8,23,10,21],[23,5,11,10],[5,3,16,11],[17,19,3,5],[14,1,9,22],[22,9,4,7],[9,12,6,4],[12,15,2,6],[6,2,20,18],[7,4,23,8],[4,6,5,23],[10,11,12,9],[11,16,15,12],[16,3,2,15],[3,19,20,2],[6,18,17,5],[18,20,19,17]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,3,2,2,-2,-2,1,1,-1,2]},

Penta9 : {
"name":"penta#9 (plane, type Y)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,-0.5],[1,-1,0.5],[0,1,0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[17,23],[14,13],[13,6],[5,6],[22,13],[16,7],[14,5],[18,2],[6,12],[15,16],[10,12],[21,14],[15,8],[18,22],[23,8],[17,21],[5,10],[23,2],[8,7],[15,10],[16,12],[17,18],[21,22],[2,7],[1,13],[13,16],[0,14],[14,15],[3,15],[4,16],[19,20],[3,4],[9,19],[9,11],[0,1],[11,20]],
"numthickedges":24,
"face":[[18,22,21,17],[17,0,1,18],[0,3,4,1],[3,9,11,4],[9,23,2,11],[22,13,14,21],[16,20,19,15],[20,7,8,19],[21,14,0,17],[14,15,3,0],[5,10,15,14],[15,19,9,3],[19,8,23,9],[18,1,13,22],[1,4,16,13],[13,16,12,6],[4,11,20,16],[11,2,7,20],[13,6,5,14],[15,10,12,16],[6,12,10,5],[23,8,7,2]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,3,-1,1,2,1]},

Penta10 : {
"name":"penta#10 (plane, type N)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[0,1,-0.5],[0,1,0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,0.5],[1,0,-0.5],[2,1,-0.5],[2,1,0.5],[-2,0,-0.5],[-2,0,0.5],[-1,1,-0.5]],
"edge":[[6,20],[12,11],[11,6],[4,5],[23,6],[16,5],[22,11],[14,7],[12,23],[23,19],[13,14],[19,20],[15,4],[21,12],[13,8],[16,22],[15,21],[7,20],[4,13],[8,7],[8,19],[5,14],[15,16],[21,22],[1,11],[11,14],[0,12],[12,13],[13,9],[14,10],[18,17],[9,10],[17,2],[0,1],[18,3],[3,2]],
"numthickedges":24,
"face":[[16,22,21,15],[15,0,1,16],[0,4,5,1],[22,11,12,21],[21,12,0,15],[12,13,4,0],[23,9,13,12],[9,3,18,13],[3,19,8,18],[16,1,11,22],[1,5,14,11],[11,14,10,6],[14,17,2,10],[17,7,20,2],[4,13,14,5],[11,6,23,12],[6,10,9,23],[10,2,3,9],[2,20,19,3],[13,18,17,14],[18,8,7,17],[8,19,20,7]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,3,1,-1,2,2,2,-2,-2,1]},

Penta11 : {
"name":"penta#11 (plane, type I)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [3,0,0], [4,0,0]],
"vertex":[[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[1.5,-0.5,0.5],[-0.5,-0.5,-0.5],[-0.5,-0.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[2.5,0.5,-0.5],[2.5,0.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,0.5,-0.5],[-0.5,0.5,0.5],[-2.5,-0.5,-0.5],[-2.5,-0.5,0.5],[0.5,0.5,-0.5],[0.5,0.5,0.5],[2.5,-0.5,0.5],[2.5,-0.5,-0.5],[-2.5,0.5,-0.5],[-2.5,0.5,0.5],[1.5,-0.5,-0.5]],
"edge":[[22,10],[16,22],[20,19],[21,9],[15,20],[19,10],[15,16],[21,22],[16,19],[9,10],[20,9],[15,21],[0,12],[12,11],[17,18],[3,4],[7,17],[13,14],[7,8],[1,11],[0,1],[2,5],[3,13],[6,5],[23,2],[8,18],[4,14],[23,6]],
"numthickedges":12,
"face":[[16,22,21,15],[15,0,1,16],[0,3,4,1],[3,7,8,4],[7,23,2,8],[23,20,19,2],[22,11,12,21],[11,14,13,12],[14,18,17,13],[18,5,6,17],[5,10,9,6],[21,12,0,15],[12,13,3,0],[13,17,7,3],[17,6,23,7],[6,9,20,23],[16,1,11,22],[1,4,14,11],[4,8,18,14],[8,2,5,18],[2,19,10,5],[20,9,10,19]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,3,1]},

Penta12 : {
"name":"penta#12 (plane, type X)",
"category":["Pentacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[0,12],[23,18],[12,11],[16,15],[9,6],[7,2],[10,9],[23,6],[4,5],[18,19],[21,10],[21,12],[13,16],[1,11],[6,17],[13,14],[8,7],[19,20],[4,13],[8,19],[5,14],[7,20],[22,11],[14,15],[15,2],[0,1],[1,5],[22,9],[10,23],[8,3],[16,3],[3,2],[18,17],[21,22],[17,20],[0,4],[12,23],[6,7],[12,13],[11,6],[13,8],[14,7],[11,14],[23,8]],
"numthickedges":36,
"face":[[22,9,10,21],[21,12,11,22],[13,16,15,14],[9,6,23,10],[7,2,3,8],[10,23,12,21],[12,13,4,0],[23,8,13,12],[18,19,8,23],[8,3,16,13],[22,11,6,9],[1,5,14,11],[11,14,7,6],[6,7,20,17],[14,15,2,7],[1,11,12,0],[6,17,18,23],[4,13,14,5],[8,19,20,7],[0,4,5,1],[17,20,19,18],[16,3,2,15]],
"facedirection":[-1,-2,-2,2,2,-3,-3,-3,-3,-3,3,3,3,3,3,-1,-1,1,1,-2,2,1]},

Penta13 : {
"name":"penta#13 (symmetric)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,1,1], [1,0,0]],
"vertex":[[0,-1,-1],[0,-1,0],[-1,1,1],[0,0,1],[1,-1,-1],[-1,-1,1],[1,-1,0],[0,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,0],[1,0,-1],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,1,1],[0,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[11,10],[21,17],[5,18],[18,17],[4,6],[11,21],[10,12],[14,9],[13,12],[14,4],[14,5],[2,17],[1,18],[11,13],[1,10],[1,6],[4,13],[9,2],[9,21],[5,2],[6,12],[10,3],[0,11],[20,10],[0,1],[19,11],[10,7],[15,1],[16,3],[15,8],[19,16],[8,7]],
"numthickedges":21,
"face":[[15,20,19,14],[5,16,20,15],[20,8,9,19],[16,2,8,20],[14,0,1,15],[15,1,18,5],[0,4,6,1],[19,11,0,14],[9,21,11,19],[11,13,4,0],[1,10,3,18],[11,21,7,10],[10,7,17,3],[5,18,3,16],[16,3,17,2],[8,7,21,9],[2,17,7,8],[4,13,12,6],[10,12,13,11],[1,6,12,10]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,1,1,1,3,3,2,2,1,2,3]},

Penta14 : {
"name":"penta#14 (symmetric)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[1.5,-1,-1],[1.5,-1,0],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[15,7],[20,3],[12,3],[18,19],[4,20],[1,6],[4,17],[10,9],[23,6],[12,23],[12,18],[22,19],[7,18],[17,3],[15,10],[1,8],[7,8],[15,4],[1,20],[22,17],[22,9],[10,23],[9,6],[8,19],[0,12],[21,12],[16,1],[0,1],[21,22],[16,22],[2,5],[14,13],[2,14],[5,13]],
"numthickedges":24,
"face":[[16,22,21,15],[4,17,22,16],[22,9,10,21],[15,0,1,16],[16,1,20,4],[0,2,5,1],[2,7,8,5],[21,12,0,15],[10,23,12,21],[12,14,2,0],[14,18,7,2],[1,11,3,20],[12,23,6,11],[17,3,11,22],[11,13,14,12],[13,19,18,14],[4,20,3,17],[9,6,23,10],[22,11,6,9],[1,5,13,11],[5,8,19,13],[7,18,19,8]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,1,1,2,2,2,3,2,3,3,3,1]},

Penta15 : {
"name":"penta#15 (symmetric)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,0]],
"vertex":[[0,-1,-1],[0,-1,0],[0,0,1],[1,-1,0],[-1,-1,1],[0,1,0],[1,0,1],[1,1,-1],[1,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,-1],[1,0,0],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,-1,1],[1,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[0,12],[12,11],[15,0],[4,17],[10,9],[21,14],[17,6],[15,10],[7,8],[13,6],[15,4],[4,19],[12,13],[21,17],[1,11],[0,1],[1,3],[21,9],[9,8],[19,6],[13,7],[10,7],[3,8],[3,19],[12,22],[11,2],[20,12],[20,21],[11,5],[1,18],[16,1],[16,21],[18,2],[22,5]],
"numthickedges":24,
"face":[[16,21,20,15],[4,17,21,16],[21,9,10,20],[0,12,11,1],[15,0,1,16],[16,1,18,4],[1,3,19,18],[20,12,0,15],[10,22,12,20],[22,7,13,12],[17,2,11,21],[2,6,14,11],[4,18,2,17],[18,19,6,2],[9,5,22,10],[5,8,7,22],[21,11,5,9],[11,14,8,5],[3,14,6,19],[13,7,8,14],[11,14,3,1],[12,13,14,11]],
"facedirection":[-1,-1,-1,1,-2,-2,-2,-3,-3,-3,2,2,3,3,2,2,3,3,1,1,-3,-2]},

Penta16 : {
"name":"penta#16 (symmetric)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,-1],[1.5,-1,0],[0.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[15,7],[12,3],[17,18],[19,3],[1,5],[23,5],[19,20],[12,23],[7,17],[22,18],[21,12],[13,17],[5,10],[7,9],[13,6],[8,10],[1,19],[16,22],[15,21],[3,6],[23,8],[20,6],[16,1],[4,9],[9,18],[13,8],[4,10],[15,16],[21,22],[4,20],[0,12],[12,13],[0,1],[1,4],[2,13],[2,4]],
"numthickedges":30,
"face":[[16,22,21,15],[15,0,1,16],[0,2,4,1],[1,4,20,19],[2,7,9,4],[22,11,12,21],[3,6,14,11],[14,18,17,13],[21,12,0,15],[12,13,2,0],[23,8,13,12],[13,17,7,2],[16,1,11,22],[11,14,10,5],[4,9,18,14],[19,3,11,1],[11,5,23,12],[4,14,6,20],[13,8,10,14],[19,20,6,3],[5,10,8,23],[7,17,18,9]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,3,3,3,-1,-1,1,1,3,2,1]},

Penta17 : {
"name":"penta#17 (symmetric)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[1.5,-1,0],[0.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[13,6],[15,16],[22,16],[1,23],[23,17],[18,17],[4,8],[18,19],[6,15],[23,8],[6,7],[21,15],[1,18],[14,22],[13,21],[14,1],[4,7],[7,16],[19,20],[17,20],[8,20],[13,14],[21,22],[4,19],[0,1],[1,4],[2,4],[0,10],[10,3],[11,5],[3,5],[2,11]],
"numthickedges":24,
"face":[[14,22,21,13],[13,0,1,14],[0,2,4,1],[1,4,19,18],[2,6,7,4],[22,9,10,21],[9,12,11,10],[12,16,15,11],[21,10,0,13],[10,11,2,0],[11,15,6,2],[14,1,9,22],[4,7,16,12],[18,3,9,1],[3,17,23,9],[4,12,5,19],[12,8,20,5],[18,19,5,3],[3,5,20,17],[17,20,8,23],[23,8,12,9],[6,15,16,7]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,3,3,-1,-1,1,1,3,3,2,-3,1]},

Penta18 : {
"name":"penta#18 (mirror of #19, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[22,17],[1,5],[14,0],[4,16],[10,9],[23,5],[20,8],[14,10],[1,7],[16,8],[14,4],[4,20],[22,16],[0,1],[22,9],[0,23],[7,20],[10,23],[9,5],[7,17],[17,8],[15,1],[21,22],[1,18],[15,22],[12,2],[18,2],[21,12],[13,6],[19,6],[3,13],[3,19]],
"numthickedges":21,
"face":[[15,22,21,14],[4,16,22,15],[22,9,10,21],[0,12,11,1],[12,23,5,11],[14,0,1,15],[15,1,18,4],[1,3,19,18],[3,7,20,19],[21,12,0,14],[10,23,12,21],[16,2,11,22],[2,6,13,11],[6,8,17,13],[4,18,2,16],[18,19,6,2],[19,20,8,6],[9,5,23,10],[22,11,5,9],[11,13,3,1],[13,17,7,3],[7,17,8,20]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-2,-3,-3,2,2,2,3,3,3,2,3,-3,-3,1]},

Penta19 : {
"name":"penta#19 (mirror of #18, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,1,0],[0.5,1,-1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,12],[20,4],[12,4],[19,18],[5,20],[22,18],[15,0],[5,17],[10,9],[12,19],[0,20],[17,4],[10,3],[15,10],[15,5],[18,2],[22,17],[22,9],[19,3],[9,2],[3,2],[12,23],[21,12],[21,22],[16,22],[1,6],[23,6],[8,7],[14,13],[16,1],[14,8],[13,7]],
"numthickedges":21,
"face":[[16,22,21,15],[5,17,22,16],[22,9,10,21],[0,12,11,1],[1,11,4,20],[15,0,1,16],[16,1,20,5],[21,12,0,15],[10,23,12,21],[23,8,14,12],[8,3,19,14],[17,4,11,22],[5,20,4,17],[9,6,23,10],[6,7,8,23],[7,2,3,8],[22,11,6,9],[11,13,7,6],[13,18,2,7],[12,14,13,11],[14,19,18,13],[19,3,2,18]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,2,3,2,2,2,3,3,3,-2,-2,1]},

Penta20 : {
"name":"penta#20 (mirror of #21, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[15,7],[18,19],[20,3],[12,3],[4,20],[1,6],[4,17],[23,6],[12,23],[7,18],[17,3],[21,12],[13,18],[6,8],[1,10],[7,10],[13,14],[9,8],[15,4],[1,20],[14,19],[15,21],[23,9],[21,17],[13,9],[14,8],[10,19],[0,12],[12,13],[16,1],[0,1],[22,14],[2,13],[5,14],[2,5],[16,22]],
"numthickedges":27,
"face":[[16,22,21,15],[4,17,22,16],[15,0,1,16],[16,1,20,4],[0,2,5,1],[2,7,10,5],[22,11,12,21],[17,3,11,22],[14,19,18,13],[21,12,0,15],[12,13,2,0],[23,9,13,12],[13,18,7,2],[1,11,3,20],[4,20,3,17],[1,5,14,11],[11,14,8,6],[5,10,19,14],[11,6,23,12],[13,9,8,14],[6,8,9,23],[7,18,19,10]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,1,3,3,3,3,-1,1,2,1]},

Penta21 : {
"name":"penta#21 (mirror of #20, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[0,10],[10,2],[1,23],[12,0],[23,16],[4,14],[14,2],[5,8],[20,8],[2,16],[23,7],[1,6],[12,4],[11,15],[4,20],[12,21],[0,1],[21,10],[11,5],[6,20],[5,19],[21,14],[16,19],[7,19],[11,7],[6,15],[15,8],[2,5],[17,2],[13,1],[22,11],[1,17],[18,5],[3,11],[13,22],[3,18]],
"numthickedges":27,
"face":[[13,22,21,12],[4,14,22,13],[0,10,9,1],[12,0,1,13],[13,1,17,4],[1,3,18,17],[3,6,20,18],[22,9,10,21],[14,2,9,22],[5,8,15,11],[21,10,0,12],[4,17,2,14],[17,18,5,2],[2,5,19,16],[18,20,8,5],[9,11,3,1],[23,7,11,9],[11,15,6,3],[2,16,23,9],[11,7,19,5],[16,19,7,23],[6,15,8,20]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,2,2,2,-3,3,3,3,3,-3,-3,-3,-1,1,2,1]},

Penta22 : {
"name":"penta#22 (mirror of #23, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[20,4],[12,4],[19,18],[6,20],[1,8],[6,17],[5,7],[23,8],[12,23],[17,4],[21,12],[13,19],[13,14],[15,5],[15,6],[1,20],[14,18],[15,21],[18,2],[1,7],[5,13],[23,3],[19,3],[3,2],[21,17],[8,2],[7,14],[0,12],[12,13],[0,1],[22,14],[16,1],[13,10],[14,9],[10,9],[16,22]],
"numthickedges":27,
"face":[[16,22,21,15],[6,17,22,16],[15,0,1,16],[16,1,20,6],[0,5,7,1],[22,11,12,21],[17,4,11,22],[21,12,0,15],[12,13,5,0],[23,10,13,12],[10,3,19,13],[1,11,4,20],[6,20,4,17],[5,13,14,7],[1,7,14,11],[11,14,9,8],[14,18,2,9],[11,8,23,12],[8,9,10,23],[9,2,3,10],[19,3,2,18],[13,19,18,14]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,-3,-3,1,3,1,3,3,3,-1,2,2,1,-2]},

Penta23 : {
"name":"penta#23 (mirror of #22, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[0.5,0,1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[0,10],[10,3],[16,18],[1,23],[2,18],[12,0],[23,16],[5,14],[14,3],[6,8],[3,16],[8,18],[12,5],[5,19],[11,15],[12,21],[15,2],[0,1],[1,4],[21,10],[11,6],[19,6],[21,14],[23,2],[4,11],[4,19],[15,8],[3,6],[17,3],[22,11],[1,17],[13,1],[6,20],[11,7],[13,22],[7,20]],
"numthickedges":27,
"face":[[13,22,21,12],[5,14,22,13],[0,10,9,1],[12,0,1,13],[13,1,17,5],[1,4,19,17],[22,9,10,21],[14,3,9,22],[21,10,0,12],[5,17,3,14],[17,19,6,3],[3,6,20,16],[6,8,18,20],[4,11,6,19],[9,11,4,1],[23,7,11,9],[7,2,15,11],[3,16,23,9],[16,20,7,23],[20,18,2,7],[15,2,18,8],[11,15,8,6]],
"facedirection":[-1,-1,1,-2,-2,-2,2,2,-3,3,3,3,3,1,-3,-3,-3,-1,2,2,1,-2]},

Penta24 : {
"name":"penta#24 (mirror of #25, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[1.5,-1,-1],[1.5,-1,0],[0.5,1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0]],
"edge":[[16,8],[8,3],[21,5],[6,21],[10,2],[6,18],[18,5],[12,15],[1,9],[8,9],[14,15],[11,10],[16,6],[1,21],[16,22],[1,12],[9,2],[22,14],[11,3],[3,2],[22,18],[12,5],[14,11],[15,10],[23,12],[15,20],[17,1],[0,1],[14,19],[13,12],[4,14],[7,15],[0,13],[19,20],[4,7],[17,23]],
"numthickedges":24,
"face":[[17,23,22,16],[6,18,23,17],[16,0,1,17],[17,1,21,6],[0,4,7,1],[4,8,9,7],[23,12,13,22],[18,5,12,23],[12,15,14,13],[22,13,0,16],[13,14,4,0],[14,19,8,4],[11,3,19,14],[1,12,5,21],[6,21,5,18],[1,7,15,12],[7,9,20,15],[15,20,2,10],[8,19,20,9],[19,3,2,20],[15,10,11,14],[10,2,3,11]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,1,3,3,3,3,1,1,-1,2]},

Penta25 : {
"name":"penta#25 (mirror of #24, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [2,0,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0]],
"edge":[[0,11],[11,10],[8,2],[2,18],[13,0],[5,15],[21,18],[10,12],[15,6],[1,7],[13,5],[5,21],[13,22],[1,10],[0,1],[22,11],[12,6],[7,2],[6,20],[7,21],[22,15],[20,18],[8,20],[12,8],[10,3],[23,10],[12,16],[6,9],[14,1],[1,17],[19,6],[4,12],[17,3],[14,23],[4,19],[16,9]],
"numthickedges":24,
"face":[[14,23,22,13],[5,15,23,14],[0,11,10,1],[13,0,1,14],[14,1,17,5],[1,4,19,17],[4,7,21,19],[23,10,11,22],[15,3,10,23],[3,6,12,10],[22,11,0,13],[5,17,3,15],[17,19,6,3],[19,21,9,6],[6,9,18,20],[10,12,4,1],[12,16,7,4],[8,2,16,12],[7,16,9,21],[16,2,18,9],[6,20,8,12],[20,18,2,8]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,2,2,2,-3,3,3,3,3,-3,-3,-3,1,1,-1,2]},

Penta26 : {
"name":"penta#26 (mirror of #27, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,-1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,2],[18,2],[1,5],[2,10],[3,4],[23,5],[4,9],[12,23],[22,17],[20,10],[5,9],[8,9],[15,3],[1,18],[16,22],[15,21],[21,12],[23,8],[7,20],[16,1],[4,7],[7,17],[15,16],[21,22],[3,8],[18,20],[17,10],[4,19],[0,12],[0,1],[12,14],[1,4],[14,6],[19,6]],
"numthickedges":27,
"face":[[16,22,21,15],[15,0,1,16],[0,3,4,1],[1,4,19,18],[4,7,20,19],[22,11,12,21],[2,6,13,11],[6,10,17,13],[21,12,0,15],[12,14,3,0],[23,8,14,12],[16,1,11,22],[11,13,9,5],[3,14,13,4],[14,8,9,13],[18,2,11,1],[11,5,23,12],[18,19,6,2],[19,20,10,6],[5,9,8,23],[7,17,10,20],[13,17,7,4]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,3,3,1,1,-1,-1,3,3,2,1,-3]},

Penta27 : {
"name":"penta#27 (mirror of #26, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,-1],[0.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,4],[19,4],[18,17],[1,7],[23,7],[19,20],[12,23],[22,17],[21,12],[13,18],[13,8],[15,5],[1,19],[16,22],[15,21],[17,2],[4,8],[5,13],[20,8],[23,3],[16,1],[18,3],[3,2],[7,2],[5,20],[15,16],[21,22],[0,12],[12,13],[0,1],[13,9],[1,6],[9,10],[6,10]],
"numthickedges":27,
"face":[[16,22,21,15],[15,0,1,16],[0,5,6,1],[1,6,20,19],[22,11,12,21],[4,8,14,11],[21,12,0,15],[12,13,5,0],[23,9,13,12],[9,3,18,13],[16,1,11,22],[11,14,10,7],[14,17,2,10],[5,13,14,6],[6,14,8,20],[19,4,11,1],[11,7,23,12],[19,20,8,4],[7,10,9,23],[10,2,3,9],[18,3,2,17],[13,18,17,14]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,3,3,3,1,1,-1,-1,3,2,2,1,-2]},

Penta28 : {
"name":"penta#28, 'left screw' (mirror of #29, 1st)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[0.5,0,1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[16,18],[1,23],[2,18],[23,16],[17,16],[6,8],[22,15],[17,19],[8,18],[12,6],[13,4],[1,17],[14,22],[13,21],[15,2],[4,12],[19,6],[21,12],[14,1],[23,2],[4,19],[13,14],[21,22],[15,8],[3,6],[0,1],[6,20],[1,5],[0,10],[10,3],[7,20],[5,7]],
"numthickedges":24,
"face":[[14,22,21,13],[13,0,1,14],[0,4,5,1],[1,5,19,17],[22,9,10,21],[9,11,12,10],[21,10,0,13],[10,12,4,0],[14,1,9,22],[4,12,11,5],[5,11,6,19],[17,3,9,1],[3,16,23,9],[17,19,6,3],[3,6,20,16],[6,8,18,20],[16,20,7,23],[20,18,2,7],[23,7,11,9],[7,2,15,11],[15,2,18,8],[11,15,8,6]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,3,1,1,-1,-1,3,3,3,2,2,-3,-3,1,-2]},

Penta29 : {
"name":"penta#29, 'right screw' (mirror of #28, 2nd)",
"category":["Pentacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[0.5,-1,-1],[0.5,-1,0],[-0.5,0,1],[-0.5,1,0],[0.5,0,1],[0.5,1,-1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[-0.5,1,1],[1.5,1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,5],[23,18],[18,19],[9,2],[2,19],[5,10],[3,4],[16,4],[4,9],[12,23],[22,17],[5,18],[10,19],[8,9],[15,3],[16,22],[15,21],[17,2],[21,12],[23,8],[15,16],[21,22],[3,8],[17,10],[6,9],[0,12],[9,20],[12,14],[1,6],[14,7],[0,1],[7,20]],
"numthickedges":24,
"face":[[16,22,21,15],[15,0,1,16],[0,3,4,1],[22,11,12,21],[21,12,0,15],[12,14,3,0],[23,8,14,12],[16,1,11,22],[1,4,13,11],[3,14,13,4],[14,8,9,13],[11,6,23,12],[5,18,6,11],[6,9,8,23],[18,20,9,6],[20,19,2,9],[11,13,7,5],[13,17,10,7],[5,7,20,18],[7,10,19,20],[17,2,19,10],[9,2,17,13]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,3,3,1,1,-1,-1,2,2,2,-2,-2,3,3,1,-3]},

Hexa1 : {
"name":"hexa#1, 'stairs' (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[1.5,-1.5,-0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[1.5,-1.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[18,2],[17,3],[17,7],[19,20],[25,6],[7,19],[15,19],[6,8],[6,21],[7,10],[15,16],[9,8],[16,20],[18,10],[2,21],[25,9],[3,22],[25,22],[22,21],[15,9],[16,8],[3,2],[17,18],[10,20],[23,15],[11,6],[1,6],[24,16],[12,25],[0,25],[4,15],[5,16],[14,13],[12,11],[4,5],[0,1],[23,24]],
"numthickedges":24,
"face":[[18,24,23,17],[24,11,12,23],[11,2,3,12],[17,0,1,18],[0,4,5,1],[4,7,10,5],[23,14,0,17],[12,25,14,23],[3,22,25,12],[14,15,4,0],[25,9,15,14],[15,19,7,4],[18,1,13,24],[24,13,6,11],[11,6,21,2],[1,5,16,13],[13,16,8,6],[5,10,20,16],[25,22,21,6],[2,21,22,3],[15,9,8,16],[6,8,9,25],[7,19,20,10],[16,20,19,15]],
"facedirection":[-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,1,2,1,2]},

Hexa2 : {
"name":"hexa#2 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[18,2],[17,3],[20,19],[6,7],[25,8],[18,7],[15,20],[8,21],[15,16],[17,6],[16,19],[19,4],[2,21],[6,15],[3,22],[25,5],[20,5],[25,22],[22,21],[5,4],[8,4],[7,16],[3,2],[17,18],[23,15],[1,8],[24,16],[15,10],[12,25],[0,25],[11,8],[16,9],[14,13],[12,11],[10,9],[0,1],[23,24]],
"numthickedges":24,
"face":[[18,24,23,17],[24,11,12,23],[11,2,3,12],[17,0,1,18],[0,6,7,1],[23,14,0,17],[12,25,14,23],[3,22,25,12],[14,15,6,0],[25,10,15,14],[10,5,20,15],[18,1,13,24],[24,13,8,11],[11,8,21,2],[1,7,16,13],[13,16,9,8],[16,19,4,9],[25,22,21,8],[2,21,22,3],[6,15,16,7],[8,9,10,25],[9,4,5,10],[20,5,4,19],[15,20,19,16]],
"facedirection":[-1,-1,-1,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,1,2,2,1,-2]},

Hexa3 : {
"name":"hexa#3 (plane, type J)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [1,2,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[1.5,-1.5,-0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[1.5,-1.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,0.5],[0.5,-0.5,-0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,1.5,-0.5],[-0.5,1.5,0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[18,2],[17,3],[17,7],[14,13],[19,20],[13,6],[27,6],[14,27],[13,20],[14,19],[7,19],[3,23],[6,8],[7,10],[23,24],[9,8],[8,24],[9,23],[18,10],[27,9],[2,24],[3,2],[17,18],[10,20],[1,13],[6,22],[0,14],[27,21],[26,13],[25,14],[11,6],[5,15],[4,16],[12,27],[12,11],[4,5],[16,15],[0,1],[21,22],[25,26]],
"numthickedges":24,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[17,0,1,18],[0,4,5,1],[4,7,10,5],[25,14,0,17],[12,27,14,25],[3,21,27,12],[14,16,4,0],[21,23,9,27],[16,19,7,4],[18,1,13,26],[26,13,6,11],[11,6,22,2],[1,5,15,13],[6,8,24,22],[5,10,20,15],[14,27,6,13],[2,22,21,3],[22,24,23,21],[13,15,16,14],[15,20,19,16],[9,23,24,8],[27,9,8,6],[7,19,20,10]],
"facedirection":[-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,2,2,2,1,-2,1]},

Hexa4 : {
"name":"hexa#4 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[2,-1.5,0.5],[-2,1.5,0.5],[-2,1.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[1,-1.5,-0.5],[1,-1.5,0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,-0.5],[1,-0.5,0.5],[-1,1.5,0.5],[-1,1.5,-0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[2,-1.5,-0.5]],
"edge":[[20,3],[19,4],[3,23],[20,2],[19,27],[16,15],[24,23],[16,10],[2,9],[16,24],[4,24],[4,3],[19,20],[27,2],[15,23],[15,9],[10,9],[27,10],[25,16],[0,16],[1,15],[26,15],[21,22],[14,13],[7,8],[5,6],[11,21],[17,18],[11,12],[0,1],[5,17],[14,7],[13,8],[12,22],[6,18],[25,26]],
"numthickedges":18,
"face":[[20,26,25,19],[26,13,14,25],[13,3,4,14],[19,0,1,20],[0,5,6,1],[5,11,12,6],[11,27,2,12],[25,16,0,19],[14,7,16,25],[4,24,7,14],[16,17,5,0],[17,21,11,5],[21,10,27,11],[20,1,15,26],[26,15,8,13],[13,8,23,3],[1,6,18,15],[6,12,22,18],[12,2,9,22],[16,7,8,15],[7,24,23,8],[3,23,24,4],[15,18,17,16],[18,22,21,17],[22,9,10,21],[27,10,9,2]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,1,2,2,2,2,1]},

Hexa5 : {
"name":"hexa#5 (plane, type h)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[-1.5,1.5,0.5],[-1.5,1.5,-0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[1.5,-1.5,-0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[1.5,-1.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[20,2],[19,3],[0,16],[27,24],[19,0],[6,9],[16,15],[9,5],[27,8],[6,7],[15,18],[1,15],[8,23],[9,12],[17,18],[16,17],[2,23],[0,1],[6,17],[3,24],[12,4],[27,5],[20,1],[7,12],[24,23],[5,4],[8,4],[7,18],[3,2],[19,20],[16,27],[26,15],[18,22],[15,8],[25,16],[17,21],[17,11],[14,27],[13,8],[18,10],[21,22],[14,13],[11,10],[25,26]],
"numthickedges":30,
"face":[[20,26,25,19],[26,13,14,25],[13,2,3,14],[0,16,15,1],[27,24,23,8],[19,0,1,20],[6,9,12,7],[25,16,0,19],[14,27,16,25],[3,24,27,14],[27,11,17,16],[17,21,9,6],[11,5,21,17],[20,1,15,26],[26,15,8,13],[13,8,23,2],[15,18,10,8],[7,12,22,18],[18,22,4,10],[2,23,24,3],[16,17,18,15],[8,10,11,27],[10,4,5,11],[7,18,17,6],[9,21,22,12],[21,5,4,22]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,-2,2,2,-1,1,1]},

Hexa6 : {
"name":"hexa#6 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[-2,1.5,0.5],[-2,1.5,-0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,-0.5],[0,0.5,0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[-1,1.5,0.5],[-1,1.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[18,2],[17,3],[0,14],[27,22],[6,24],[14,13],[17,0],[27,6],[27,23],[1,13],[6,21],[23,24],[2,21],[0,1],[14,8],[7,24],[3,22],[8,7],[18,1],[22,21],[8,23],[3,2],[17,18],[13,7],[14,27],[11,6],[12,27],[13,6],[25,14],[26,13],[20,19],[12,11],[9,10],[15,16],[19,4],[20,5],[5,4],[15,9],[16,10],[25,26]],
"numthickedges":24,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[0,14,13,1],[27,22,21,6],[17,0,1,18],[25,14,0,17],[12,27,14,25],[3,22,27,12],[27,9,15,14],[9,5,20,15],[5,23,8,20],[18,1,13,26],[26,13,6,11],[11,6,21,2],[13,16,10,6],[16,19,4,10],[19,7,24,4],[2,21,22,3],[14,15,16,13],[15,20,19,16],[20,8,7,19],[6,10,9,27],[10,4,5,9],[4,24,23,5],[8,23,24,7]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,-2,-2,-2,2,2,2,1]},

Hexa7 : {
"name":"hexa#7 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,0.5],[1.5,-0.5,-0.5],[-0.5,1.5,-0.5],[-0.5,1.5,0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[18,17],[9,6],[7,2],[10,9],[4,5],[16,5],[25,6],[19,21],[13,18],[6,20],[15,10],[8,7],[13,14],[15,4],[4,13],[8,21],[5,14],[7,22],[21,22],[14,17],[17,2],[16,9],[10,25],[8,3],[18,3],[25,19],[3,2],[19,20],[15,16],[20,22],[6,7],[23,13],[1,6],[13,8],[14,7],[24,14],[25,8],[0,25],[12,11],[0,1],[23,24]],
"numthickedges":30,
"face":[[16,24,23,15],[24,9,10,23],[15,0,1,16],[0,4,5,1],[23,12,0,15],[10,25,12,23],[12,13,4,0],[25,8,13,12],[19,21,8,25],[8,3,18,13],[16,1,11,24],[24,11,6,9],[1,5,14,11],[11,14,7,6],[6,7,22,20],[14,17,2,7],[9,6,25,10],[7,2,3,8],[4,13,14,5],[8,21,22,7],[6,20,19,25],[20,22,21,19],[18,3,2,17],[13,18,17,14]],
"facedirection":[-1,-1,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,1,1,-1,2,1,-2]},

Hexa8 : {
"name":"hexa#8 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,0.5],[0.5,-0.5,-0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[-0.5,1.5,0.5],[-0.5,1.5,-0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[1.5,1.5,-0.5],[1.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[9,6],[7,2],[18,21],[10,9],[4,5],[16,5],[5,7],[25,6],[17,22],[3,21],[6,17],[15,10],[2,22],[8,7],[15,4],[16,9],[10,25],[8,3],[25,18],[18,17],[3,2],[15,16],[21,22],[4,8],[6,7],[7,20],[1,6],[25,8],[0,25],[8,19],[12,11],[24,13],[14,13],[19,20],[23,14],[0,1],[23,24]],
"numthickedges":24,
"face":[[16,24,23,15],[24,9,10,23],[15,0,1,16],[0,4,5,1],[23,12,0,15],[10,25,12,23],[12,14,4,0],[25,8,14,12],[18,19,8,25],[19,21,3,8],[16,1,11,24],[24,11,6,9],[1,5,13,11],[11,13,7,6],[6,7,20,17],[7,2,22,20],[9,6,25,10],[4,14,13,5],[14,8,7,13],[6,17,18,25],[17,20,19,18],[20,22,21,19],[3,21,22,2],[8,3,2,7]],
"facedirection":[-1,-1,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,1,1,-1,2,2,1,-2]},

Hexa9 : {
"name":"hexa#9 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-0.5],[-0.5,-1,0.5],[1.5,1,0.5],[1.5,1,-0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[1.5,-1,-0.5],[0.5,1,-0.5],[0.5,1,0.5],[1.5,-1,0.5],[-1.5,1,0.5],[-1.5,1,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[0.5,0,-0.5],[0.5,0,0.5],[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,0,-0.5],[1.5,0,0.5],[-1.5,0,-0.5],[-1.5,0,0.5],[-0.5,1,-0.5]],
"edge":[[11,2],[18,10],[17,7],[7,3],[3,2],[12,3],[17,12],[18,11],[12,11],[17,18],[7,10],[10,2],[0,23],[14,13],[19,20],[1,6],[23,6],[4,5],[22,20],[21,19],[15,16],[8,9],[0,1],[4,8],[5,9],[21,22]],
"numthickedges":12,
"face":[[18,22,21,17],[22,11,12,21],[17,0,1,18],[0,4,5,1],[4,7,10,5],[21,14,0,17],[12,23,14,21],[14,15,4,0],[23,8,15,14],[15,19,7,4],[8,3,19,15],[18,1,13,22],[22,13,6,11],[1,5,16,13],[13,16,9,6],[5,10,20,16],[16,20,2,9],[11,6,23,12],[6,9,8,23],[9,2,3,8],[7,19,20,10],[19,3,2,20]],
"facedirection":[-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,2,1,1]},

Hexa10 : {
"name":"hexa#10 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [1,1,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,0.5],[0,1,-0.5],[1,-1,0.5],[-2,1,0.5],[-2,1,-0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[8,7],[20,2],[19,25],[18,7],[17,11],[19,14],[20,13],[14,11],[14,13],[19,20],[25,2],[2,7],[17,8],[18,10],[13,10],[11,10],[25,8],[17,18],[24,18],[3,17],[23,17],[4,18],[0,5],[16,15],[21,22],[1,6],[5,6],[3,4],[9,21],[9,12],[0,1],[12,22],[23,24]],
"numthickedges":18,
"face":[[20,24,23,19],[24,13,14,23],[19,0,1,20],[0,3,4,1],[3,9,12,4],[9,25,2,12],[23,16,0,19],[14,5,16,23],[16,17,3,0],[5,11,17,16],[17,21,9,3],[21,8,25,9],[20,1,15,24],[24,15,6,13],[1,4,18,15],[15,18,10,6],[4,12,22,18],[12,2,7,22],[13,6,5,14],[6,10,11,5],[17,11,10,18],[18,22,21,17],[22,7,8,21],[25,8,7,2]],
"facedirection":[-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,1,2,2,1]},

Hexa11 : {
"name":"hexa#11 (plane, type F)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [2,1,0], [3,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,0.5],[1,-1,0.5],[0,1,-0.5],[-2,1,0.5],[-2,1,-0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,0.5],[0,0,-0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[21,27],[18,17],[23,24],[17,8],[15,8],[12,3],[16,15],[7,8],[18,7],[22,2],[17,19],[24,9],[21,16],[14,12],[20,19],[18,20],[23,10],[27,10],[24,3],[22,15],[27,2],[10,9],[16,7],[14,4],[23,4],[4,3],[20,14],[19,12],[21,22],[2,9],[1,17],[0,18],[26,17],[19,24],[25,18],[20,23],[13,24],[11,23],[5,20],[6,19],[5,6],[11,13],[0,1],[25,26]],
"numthickedges":30,
"face":[[22,26,25,21],[26,15,16,25],[21,0,1,22],[0,5,6,1],[5,11,13,6],[11,27,2,13],[25,18,0,21],[16,7,18,25],[18,20,5,0],[20,23,11,5],[14,4,23,20],[23,10,27,11],[22,1,17,26],[26,17,8,15],[1,6,19,17],[6,13,24,19],[19,24,3,12],[13,2,9,24],[18,7,8,17],[15,8,7,16],[12,3,4,14],[17,19,20,18],[24,9,10,23],[19,12,14,20],[23,4,3,24],[27,10,9,2]],
"facedirection":[-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,2,2,2,-1,1,1]},

Hexa12 : {
"name":"hexa#12 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,0.5],[1,-1,0.5],[0,1,-0.5],[-2,1,0.5],[-2,1,-0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[2,1,-0.5],[2,1,0.5],[-2,0,-0.5],[-2,0,0.5],[-1,1,-0.5]],
"edge":[[19,9],[16,15],[21,22],[15,6],[14,13],[27,6],[16,27],[14,27],[12,23],[13,6],[10,24],[9,21],[15,18],[22,7],[19,14],[9,11],[12,10],[23,24],[17,18],[16,17],[21,8],[20,11],[7,24],[20,13],[8,7],[8,23],[17,12],[18,10],[19,20],[11,22],[1,15],[0,16],[21,3],[26,15],[18,22],[25,16],[17,21],[4,17],[5,18],[22,2],[4,5],[0,1],[3,2],[25,26]],
"numthickedges":30,
"face":[[20,26,25,19],[26,13,14,25],[19,0,1,20],[0,4,5,1],[4,9,11,5],[25,16,0,19],[14,27,16,25],[16,17,4,0],[17,21,9,4],[12,3,21,17],[3,23,8,21],[20,1,15,26],[26,15,6,13],[1,5,18,15],[5,11,22,18],[18,22,2,10],[22,7,24,2],[16,27,6,15],[13,6,27,14],[10,2,3,12],[2,24,23,3],[15,18,17,16],[9,21,22,11],[18,10,12,17],[8,23,24,7],[21,8,7,22]],
"facedirection":[-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,2,2,2,1,-1,1,-2]},

Hexa13 : {
"name":"hexa#13 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [3,0,0], [3,1,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[1,-1,0.5],[-2,1,0.5],[-2,1,-0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[2,1,-0.5],[2,1,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[19,27],[16,15],[21,22],[15,8],[14,13],[7,8],[16,7],[2,24],[15,22],[16,21],[20,2],[19,14],[13,8],[3,24],[23,24],[27,23],[22,3],[20,13],[27,2],[14,7],[4,23],[21,4],[4,3],[19,20],[1,15],[0,16],[26,15],[22,9],[25,16],[21,10],[12,22],[11,21],[5,6],[17,18],[11,12],[0,1],[5,17],[10,9],[6,18],[25,26]],
"numthickedges":24,
"face":[[20,26,25,19],[26,13,14,25],[19,0,1,20],[0,5,6,1],[5,11,12,6],[11,27,2,12],[25,16,0,19],[14,7,16,25],[16,17,5,0],[17,21,11,5],[21,10,27,11],[4,23,10,21],[20,1,15,26],[26,15,8,13],[1,6,18,15],[6,12,22,18],[12,2,9,22],[22,9,24,3],[16,7,8,15],[13,8,7,14],[3,24,23,4],[15,18,17,16],[18,22,21,17],[27,10,9,2],[10,23,24,9],[22,3,4,21]],
"facedirection":[-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,2,2,2,1,1,-1]},

Hexa14 : {
"name":"hexa#14 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,0,0], [2,0,0], [3,0,0], [4,0,0]],
"vertex":[[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,-1,-0.5],[-0.5,-1,-0.5],[-0.5,-1,0.5],[-1.5,1,-0.5],[-1.5,1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[0.5,-1,-0.5],[0.5,-1,0.5],[2.5,0,-0.5],[2.5,0,0.5],[-2.5,1,0.5],[-2.5,1,-0.5],[-1.5,0,0.5],[-1.5,0,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[-2.5,-1,-0.5],[-2.5,-1,0.5],[0.5,0,-0.5],[0.5,0,0.5],[2.5,-1,0.5],[2.5,-1,-0.5],[-2.5,0,-0.5],[-2.5,0,0.5],[1.5,-1,0.5]],
"edge":[[16,11],[24,23],[16,5],[19,24],[13,6],[16,15],[23,12],[15,6],[15,12],[19,14],[20,13],[14,13],[19,20],[20,23],[5,6],[14,5],[24,11],[11,12],[25,16],[0,16],[1,15],[26,15],[21,22],[3,4],[9,21],[18,17],[9,10],[0,1],[27,7],[3,18],[8,7],[2,27],[10,22],[4,17],[25,26],[2,8]],
"numthickedges":18,
"face":[[20,26,25,19],[26,13,14,25],[19,0,1,20],[0,3,4,1],[3,9,10,4],[9,2,27,10],[2,24,23,27],[25,16,0,19],[14,5,16,25],[16,18,3,0],[18,21,9,3],[21,8,2,9],[8,11,24,2],[20,1,15,26],[26,15,6,13],[1,4,17,15],[4,10,22,17],[10,27,7,22],[27,23,12,7],[16,5,6,15],[13,6,5,14],[15,17,18,16],[17,22,21,18],[22,7,8,21],[7,12,11,8],[24,11,12,23]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,2,2,2,2,2,1]},

Hexa15 : {
"name":"hexa#15 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-0.5],[-0.5,-1.5,0.5],[1.5,0.5,0.5],[1.5,0.5,-0.5],[0.5,-1.5,-0.5],[0.5,-1.5,0.5],[-0.5,0.5,0.5],[1.5,-1.5,-0.5],[0.5,0.5,0.5],[0.5,0.5,-0.5],[1.5,-1.5,0.5],[-1.5,0.5,0.5],[-1.5,0.5,-0.5],[-0.5,-0.5,0.5],[-0.5,-0.5,-0.5],[0.5,-0.5,0.5],[0.5,-0.5,-0.5],[-1.5,-1.5,-0.5],[-1.5,-1.5,0.5],[1.5,-0.5,-0.5],[1.5,-0.5,0.5],[-0.5,1.5,-0.5],[-0.5,1.5,0.5],[0.5,1.5,-0.5],[0.5,1.5,0.5],[-1.5,-0.5,-0.5],[-1.5,-0.5,0.5],[-0.5,0.5,-0.5]],
"edge":[[0,14],[27,21],[17,0],[4,7],[14,13],[7,3],[11,6],[8,2],[12,11],[4,5],[27,6],[21,23],[13,15],[1,13],[6,22],[17,12],[7,10],[9,8],[16,15],[4,16],[9,23],[5,15],[8,24],[23,24],[14,16],[0,1],[18,11],[10,2],[12,27],[9,3],[18,1],[5,10],[3,2],[21,22],[17,18],[22,24],[14,27],[6,8],[26,13],[15,20],[13,6],[16,9],[15,8],[25,14],[16,19],[27,9],[19,20],[25,26]],
"numthickedges":36,
"face":[[18,26,25,17],[26,11,12,25],[0,14,13,1],[17,0,1,18],[4,7,10,5],[25,14,0,17],[12,27,14,25],[27,9,16,14],[21,23,9,27],[16,19,7,4],[9,3,19,16],[18,1,13,26],[26,13,6,11],[13,15,8,6],[6,8,24,22],[5,10,20,15],[15,20,2,8],[11,6,27,12],[8,2,3,9],[14,16,15,13],[6,22,21,27],[9,23,24,8],[22,24,23,21],[5,15,16,4],[7,19,20,10],[19,3,2,20]],
"facedirection":[-1,-1,1,-2,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,-2,-1,1,2,-1,1,1]},

Hexa16 : {
"name":"hexa#16 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,12],[27,19],[12,11],[15,0],[10,9],[27,4],[10,27],[8,21],[9,4],[7,22],[19,23],[1,11],[4,20],[15,10],[8,7],[21,22],[23,24],[8,23],[7,24],[0,1],[12,6],[5,22],[16,9],[6,5],[16,1],[19,20],[6,21],[15,16],[20,24],[11,5],[12,27],[27,8],[4,7],[11,4],[13,8],[14,7],[25,12],[26,11],[18,17],[13,14],[17,2],[18,3],[3,2],[25,26]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,13,12],[19,23,8,27],[8,3,18,13],[3,21,6,18],[16,1,11,26],[26,11,4,9],[11,14,7,4],[4,7,24,20],[14,17,2,7],[17,5,22,2],[9,4,27,10],[7,2,3,8],[2,22,21,3],[12,13,14,11],[13,18,17,14],[18,6,5,17],[4,20,19,27],[8,23,24,7],[20,24,23,19],[6,21,22,5]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,2,-2,-2,-2,-1,1,2,1]},

Hexa17 : {
"name":"hexa#17 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,2,0], [3,2,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[0,0.5,0.5],[0,0.5,-0.5],[2,1.5,-0.5],[2,1.5,0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,12],[27,17],[12,11],[15,0],[18,8],[10,9],[27,4],[10,27],[6,19],[9,4],[5,20],[19,7],[20,8],[11,13],[1,11],[4,18],[15,10],[14,13],[6,5],[7,8],[19,20],[12,14],[17,7],[0,1],[16,9],[16,1],[17,18],[14,6],[13,5],[15,16],[12,27],[27,6],[4,5],[26,11],[11,4],[25,12],[6,21],[5,22],[3,23],[21,22],[2,24],[3,2],[25,26],[23,24]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,6,14,12],[17,21,6,27],[21,23,3,6],[23,7,19,3],[16,1,11,26],[26,11,4,9],[11,13,5,4],[4,5,22,18],[5,2,24,22],[2,20,8,24],[9,4,27,10],[14,6,5,13],[12,14,13,11],[4,18,17,27],[18,22,21,17],[22,24,23,21],[24,8,7,23],[6,3,2,5],[3,19,20,2],[19,7,8,20]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,1,-2,-1,2,2,2,-2,-2,1]},

Hexa18 : {
"name":"hexa#18 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [2,1,0], [2,2,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,12],[12,11],[15,0],[10,9],[21,23],[3,23],[15,10],[9,7],[2,20],[2,24],[8,7],[8,21],[7,22],[19,20],[21,22],[1,11],[0,1],[12,6],[5,20],[16,9],[6,5],[16,1],[22,24],[10,8],[3,19],[3,2],[6,19],[15,16],[23,24],[11,5],[12,27],[18,3],[7,2],[17,2],[13,8],[14,7],[11,4],[25,12],[8,3],[26,11],[18,17],[27,4],[13,14],[25,26]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,13,12],[8,3,18,13],[21,23,3,8],[3,19,6,18],[16,1,11,26],[26,11,4,9],[11,14,7,4],[14,17,2,7],[7,2,24,22],[17,5,20,2],[9,4,27,10],[4,7,8,27],[2,20,19,3],[12,13,14,11],[13,18,17,14],[18,6,5,17],[7,22,21,8],[3,23,24,2],[22,24,23,21],[6,19,20,5]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,2,-2,-2,-2,-1,1,2,1]},

Hexa19 : {
"name":"hexa#19 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [2,1,0], [2,2,0], [3,2,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[0,0.5,0.5],[0,0.5,-0.5],[2,1.5,-0.5],[2,1.5,0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,12],[12,11],[18,17],[15,0],[10,9],[11,17],[12,18],[19,7],[20,8],[15,10],[9,5],[2,20],[6,5],[21,22],[6,21],[5,22],[7,8],[19,20],[21,7],[22,8],[17,2],[1,11],[0,1],[16,9],[16,1],[18,3],[10,6],[3,19],[3,2],[15,16],[12,27],[26,11],[25,12],[5,2],[14,6],[13,5],[2,24],[11,4],[3,23],[6,3],[27,4],[14,13],[25,26],[23,24]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,6,14,12],[6,3,18,14],[21,23,3,6],[23,7,19,3],[16,1,11,26],[26,11,4,9],[11,13,5,4],[13,17,2,5],[5,2,24,22],[2,20,8,24],[9,4,27,10],[4,5,6,27],[12,14,13,11],[14,18,17,13],[18,3,2,17],[5,22,21,6],[22,24,23,21],[24,8,7,23],[19,7,8,20],[3,19,20,2]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,-2,-2,1,-1,2,2,1,-2]},

Hexa20 : {
"name":"hexa#20 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [2,1,0], [3,1,0], [3,2,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[2,1.5,-0.5],[2,1.5,0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,14],[14,13],[6,9],[17,0],[12,11],[3,23],[24,10],[12,3],[17,12],[2,24],[9,10],[1,13],[0,1],[14,6],[18,11],[6,5],[5,10],[18,1],[11,2],[3,2],[23,9],[17,18],[23,24],[13,5],[14,27],[20,3],[3,21],[19,2],[13,4],[25,14],[2,22],[26,13],[20,19],[27,4],[8,7],[16,15],[21,22],[16,8],[15,7],[25,26]],
"numthickedges":24,
"face":[[18,26,25,17],[26,11,12,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[12,27,14,25],[27,8,16,14],[8,3,20,16],[3,21,6,20],[23,9,21,3],[18,1,13,26],[26,13,4,11],[13,15,7,4],[15,19,2,7],[19,5,22,2],[2,22,10,24],[11,4,27,12],[4,7,8,27],[7,2,3,8],[14,16,15,13],[16,20,19,15],[20,6,5,19],[6,21,22,5],[21,9,10,22],[2,24,23,3],[24,10,9,23]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,2,2,2,-2,-2,-2,1,1,-1,2]},

Hexa21 : {
"name":"hexa#21 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,2,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[2,-1.5,0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,-0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[1,-1.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[1,-1.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,-0.5],[1,-0.5,0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[2,-1.5,-0.5]],
"edge":[[17,27],[14,13],[14,21],[26,13],[16,7],[18,2],[21,23],[15,16],[23,24],[25,14],[15,8],[18,26],[27,8],[17,25],[16,24],[27,2],[8,7],[21,22],[13,22],[17,18],[25,26],[22,24],[15,23],[2,7],[0,14],[13,16],[14,15],[4,16],[1,13],[3,15],[19,20],[3,4],[5,6],[9,19],[6,10],[11,10],[9,12],[0,1],[5,11],[12,20]],
"numthickedges":24,
"face":[[18,26,25,17],[17,0,1,18],[0,3,4,1],[3,9,12,4],[9,27,2,12],[26,13,14,25],[16,20,19,15],[20,7,8,19],[25,14,0,17],[14,15,3,0],[5,11,15,14],[21,23,11,5],[15,19,9,3],[19,8,27,9],[18,1,13,26],[1,4,16,13],[13,16,10,6],[6,10,24,22],[4,12,20,16],[12,2,7,20],[13,6,5,14],[6,22,21,5],[15,11,10,16],[11,23,24,10],[22,24,23,21],[27,8,7,2]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,-1,1,1,2,1]},

Hexa22 : {
"name":"hexa#22 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,2,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,-0.5],[0,0.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[12,11],[12,19],[4,5],[16,5],[26,11],[14,7],[9,21],[10,22],[19,23],[13,14],[9,10],[15,4],[4,13],[9,23],[25,12],[13,8],[5,14],[10,24],[23,24],[21,22],[16,26],[15,25],[7,22],[8,7],[19,20],[8,21],[11,20],[15,16],[25,26],[20,24],[0,12],[11,14],[27,9],[6,10],[13,9],[12,13],[14,10],[1,11],[18,17],[27,6],[17,2],[0,1],[18,3],[3,2]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,13,4,0],[27,9,13,12],[19,23,9,27],[9,3,18,13],[3,21,8,18],[16,1,11,26],[1,5,14,11],[11,14,10,6],[6,10,24,20],[14,17,2,10],[17,7,22,2],[4,13,14,5],[9,23,24,10],[11,6,27,12],[6,20,19,27],[20,24,23,19],[13,18,17,14],[18,8,7,17],[10,2,3,9],[2,22,21,3],[8,21,22,7]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,1,-1,-1,2,-2,-2,2,2,1]},

Hexa23 : {
"name":"hexa#23 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,2,0], [2,2,0], [3,2,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[0,0.5,0.5],[0,0.5,-0.5],[2,1.5,-0.5],[2,1.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[12,11],[12,17],[18,10],[4,5],[16,5],[5,7],[8,19],[7,20],[19,9],[20,10],[8,7],[9,10],[15,4],[19,20],[16,26],[15,25],[17,9],[25,12],[17,18],[11,18],[15,16],[25,26],[4,8],[26,11],[0,12],[7,22],[27,8],[6,7],[12,14],[1,11],[8,21],[11,13],[27,6],[3,23],[14,13],[21,22],[2,24],[0,1],[3,2],[23,24]],
"numthickedges":24,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,14,4,0],[27,8,14,12],[17,21,8,27],[21,23,3,8],[23,9,19,3],[16,1,11,26],[1,5,13,11],[11,13,7,6],[6,7,22,18],[7,2,24,22],[2,20,10,24],[4,14,13,5],[14,8,7,13],[11,6,27,12],[6,18,17,27],[18,22,21,17],[22,24,23,21],[24,10,9,23],[8,3,2,7],[3,19,20,2],[19,9,10,20]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,1,-1,-1,2,2,2,-2,-2,1]},

Hexa24 : {
"name":"hexa#24 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0], [2,1,0], [3,0,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[2,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,-0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,-0.5],[1,-1,0.5],[0,1,0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[-2,0,-0.5],[-2,0,0.5],[2,-1,-0.5]],
"edge":[[19,25],[16,15],[21,22],[15,8],[7,8],[16,7],[20,2],[24,15],[22,9],[20,24],[25,10],[19,23],[22,3],[23,16],[21,10],[25,2],[10,9],[7,4],[21,4],[4,3],[8,3],[19,20],[23,24],[2,9],[1,15],[0,16],[15,22],[13,22],[16,21],[11,21],[5,6],[17,18],[12,14],[11,13],[0,1],[5,12],[6,14]],
"numthickedges":24,
"face":[[20,24,23,19],[19,0,1,20],[0,5,6,1],[5,11,13,6],[11,25,2,13],[24,15,16,23],[22,9,10,21],[23,16,0,19],[16,17,5,0],[7,12,17,16],[17,21,11,5],[12,4,21,17],[21,10,25,11],[20,1,15,24],[1,6,18,15],[15,18,14,8],[6,13,22,18],[18,22,3,14],[13,2,9,22],[15,8,7,16],[8,14,12,7],[14,3,4,12],[21,4,3,22],[25,10,9,2]],
"facedirection":[-1,-2,-2,-2,-2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,2,2,1,1]},

Hexa25 : {
"name":"hexa#25 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-0.5],[-1,-1,0.5],[1,1,0.5],[1,1,-0.5],[0,-1,-0.5],[0,-1,0.5],[-1,1,0.5],[2,0,0.5],[2,0,-0.5],[1,-1,-0.5],[0,1,-0.5],[1,-1,0.5],[0,1,0.5],[-1,0,0.5],[-1,0,-0.5],[0,0,-0.5],[0,0,0.5],[-2,-1,-0.5],[-2,-1,0.5],[1,0,-0.5],[1,0,0.5],[2,1,-0.5],[2,1,0.5],[-2,0,-0.5],[-2,0,0.5],[-1,1,-0.5]],
"edge":[[17,9],[6,22],[14,13],[19,20],[13,6],[25,6],[14,25],[25,21],[9,19],[24,13],[20,7],[9,11],[21,22],[18,24],[17,23],[18,11],[23,14],[19,8],[7,22],[8,7],[8,21],[17,18],[23,24],[11,20],[1,13],[0,14],[19,3],[13,20],[14,19],[20,2],[4,5],[15,16],[10,12],[0,1],[4,10],[3,2],[5,12]],
"numthickedges":24,
"face":[[18,24,23,17],[17,0,1,18],[0,4,5,1],[4,9,11,5],[24,13,14,23],[23,14,0,17],[14,15,4,0],[25,10,15,14],[15,19,9,4],[10,3,19,15],[3,21,8,19],[18,1,13,24],[1,5,16,13],[13,16,12,6],[5,11,20,16],[16,20,2,12],[20,7,22,2],[13,6,25,14],[6,12,10,25],[12,2,3,10],[2,22,21,3],[9,19,20,11],[8,21,22,7],[19,8,7,20]],
"facedirection":[-1,-2,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,2,2,2,1,1,-2]},

Hexa26 : {
"name":"hexa#26 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0], [3,0,0], [4,0,0]],
"vertex":[[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,-1,-0.5],[-0.5,-1,-0.5],[-0.5,-1,0.5],[-1.5,1,-0.5],[-1.5,1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[0.5,-1,-0.5],[-0.5,1,0.5],[-0.5,1,-0.5],[0.5,-1,0.5],[2.5,0,-0.5],[2.5,0,0.5],[-1.5,0,0.5],[-1.5,0,-0.5],[-0.5,0,0.5],[-0.5,0,-0.5],[-2.5,-1,-0.5],[-2.5,-1,0.5],[0.5,0,-0.5],[0.5,0,0.5],[2.5,-1,0.5],[2.5,-1,-0.5],[-2.5,0,-0.5],[-2.5,0,0.5],[1.5,-1,0.5]],
"edge":[[16,15],[15,6],[5,6],[20,23],[16,5],[24,13],[19,24],[6,10],[18,17],[13,14],[11,10],[20,26],[19,25],[25,16],[18,13],[23,14],[5,11],[24,23],[26,15],[17,14],[18,11],[17,10],[19,20],[25,26],[1,15],[0,16],[16,18],[15,17],[3,18],[4,17],[21,22],[3,4],[9,21],[9,12],[0,1],[27,7],[8,7],[2,27],[12,22],[2,8]],
"numthickedges":24,
"face":[[20,26,25,19],[19,0,1,20],[0,3,4,1],[3,9,12,4],[9,2,27,12],[2,24,23,27],[26,15,16,25],[17,22,21,18],[22,7,8,21],[7,14,13,8],[25,16,0,19],[16,18,3,0],[5,11,18,16],[18,21,9,3],[21,8,2,9],[8,13,24,2],[20,1,15,26],[1,4,17,15],[15,17,10,6],[4,12,22,17],[12,27,7,22],[27,23,14,7],[15,6,5,16],[18,11,10,17],[6,10,11,5],[24,13,14,23]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,1,2,1]},

Hexa27 : {
"name":"hexa#27 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0], [2,2,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,-0.5],[0,0.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[12,11],[11,6],[21,22],[4,5],[27,6],[16,5],[26,11],[14,7],[12,27],[21,23],[3,23],[6,10],[2,20],[2,24],[15,4],[4,13],[9,21],[25,12],[13,8],[5,14],[10,22],[13,14],[9,10],[19,20],[16,26],[15,25],[7,20],[27,9],[3,19],[8,7],[22,24],[3,2],[8,19],[15,16],[25,26],[23,24],[1,11],[11,14],[0,12],[18,3],[10,2],[17,2],[13,9],[12,13],[14,10],[9,3],[18,17],[0,1]],
"numthickedges":36,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,13,4,0],[27,9,13,12],[9,3,18,13],[21,23,3,9],[3,19,8,18],[16,1,11,26],[1,5,14,11],[11,14,10,6],[14,17,2,10],[10,2,24,22],[17,7,20,2],[4,13,14,5],[11,6,27,12],[6,10,9,27],[2,20,19,3],[13,18,17,14],[18,8,7,17],[10,22,21,9],[3,23,24,2],[22,24,23,21],[8,19,20,7]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,-1,2,2,-2,-2,-1,1,2,1]},

Hexa28 : {
"name":"hexa#28, 'snake' (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0], [2,2,0], [3,2,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[0,0.5,0.5],[0,0.5,-0.5],[2,1.5,-0.5],[2,1.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[12,11],[18,17],[11,6],[19,20],[4,5],[27,6],[16,5],[12,27],[19,9],[20,10],[25,12],[14,18],[6,7],[2,20],[14,13],[15,4],[4,14],[8,21],[5,13],[7,22],[8,7],[21,22],[21,9],[26,11],[13,17],[16,26],[15,25],[17,2],[22,10],[27,8],[3,19],[18,3],[3,2],[9,10],[15,16],[25,26],[1,11],[0,12],[12,14],[7,2],[14,8],[13,7],[11,13],[2,24],[8,3],[3,23],[0,1],[23,24]],
"numthickedges":36,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,14,4,0],[27,8,14,12],[8,3,18,14],[21,23,3,8],[23,9,19,3],[16,1,11,26],[1,5,13,11],[11,13,7,6],[13,17,2,7],[7,2,24,22],[2,20,10,24],[4,14,13,5],[11,6,27,12],[6,7,8,27],[18,3,2,17],[14,18,17,13],[7,22,21,8],[22,24,23,21],[24,10,9,23],[19,9,10,20],[3,19,20,2]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,-1,2,1,-2,-1,2,2,1,-2]},

Hexa29 : {
"name":"hexa#29 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0], [3,1,0], [4,1,0]],
"vertex":[[-1.5,-1,-0.5],[-1.5,-1,0.5],[0.5,1,0.5],[0.5,1,-0.5],[-0.5,-1,-0.5],[-0.5,-1,0.5],[-1.5,1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[-0.5,1,-0.5],[-0.5,1,0.5],[2.5,0,-0.5],[2.5,0,0.5],[-1.5,0,0.5],[-1.5,0,-0.5],[-0.5,0,-0.5],[-0.5,0,0.5],[-2.5,-1,-0.5],[-2.5,-1,0.5],[0.5,0,0.5],[0.5,0,-0.5],[1.5,1,-0.5],[1.5,1,0.5],[2.5,1,0.5],[2.5,1,-0.5],[-2.5,0,-0.5],[-2.5,0,0.5],[-1.5,1,-0.5]],
"edge":[[27,24],[14,13],[13,6],[4,5],[27,6],[18,5],[14,27],[15,16],[24,23],[17,4],[11,12],[18,26],[17,25],[25,14],[15,11],[4,15],[6,23],[11,24],[12,23],[26,13],[16,12],[5,16],[17,18],[25,26],[1,13],[0,14],[14,15],[15,9],[13,16],[16,10],[20,19],[9,10],[21,22],[19,2],[0,1],[7,22],[8,7],[20,3],[3,2],[8,21]],
"numthickedges":24,
"face":[[18,26,25,17],[17,0,1,18],[0,4,5,1],[26,13,14,25],[25,14,0,17],[14,15,4,0],[27,9,15,14],[9,3,20,15],[3,21,8,20],[21,24,11,8],[18,1,13,26],[1,5,16,13],[13,16,10,6],[16,19,2,10],[19,7,22,2],[7,12,23,22],[4,15,16,5],[13,6,27,14],[6,10,9,27],[10,2,3,9],[2,22,21,3],[22,23,24,21],[15,20,19,16],[20,8,7,19],[8,11,12,7],[11,24,23,12]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,-1,2,2,2,2,-2,-2,-2,1]},

Hexa30 : {
"name":"hexa#30 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [2,1,0], [2,2,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[1,-1.5,-0.5],[0,0.5,-0.5],[1,-1.5,0.5],[0,0.5,0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[-2,-1.5,-0.5],[-2,-1.5,0.5],[1,-0.5,-0.5],[1,-0.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5]],
"edge":[[16,8],[18,19],[27,15],[19,6],[22,24],[8,18],[3,24],[8,10],[14,15],[2,21],[10,19],[2,25],[22,23],[20,21],[17,27],[16,26],[17,10],[6,21],[15,23],[7,6],[26,14],[18,7],[23,25],[3,20],[3,2],[7,20],[16,17],[26,27],[24,25],[14,22],[15,19],[18,3],[11,2],[19,2],[5,15],[14,18],[9,3],[4,14],[0,13],[13,12],[4,5],[9,11],[1,12],[0,1]],
"numthickedges":30,
"face":[[17,27,26,16],[16,0,1,17],[0,4,5,1],[4,8,10,5],[27,12,13,26],[12,15,14,13],[26,13,0,16],[13,14,4,0],[14,18,8,4],[9,3,18,14],[22,24,3,9],[3,20,7,18],[17,1,12,27],[1,5,15,12],[5,10,19,15],[15,19,2,11],[11,2,25,23],[19,6,21,2],[8,18,19,10],[3,24,25,2],[15,11,9,14],[11,23,22,9],[23,25,24,22],[7,20,21,6],[18,7,6,19],[2,21,20,3]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,1,-1,-1,2,1,-2,2]},

Hexa31 : {
"name":"hexa#31 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [2,1,0], [3,0,0], [4,0,0]],
"vertex":[[-1.5,-1,-0.5],[-1.5,-1,0.5],[1.5,-1,0.5],[0.5,1,0.5],[0.5,1,-0.5],[-0.5,-1,-0.5],[-0.5,-1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[0.5,-1,-0.5],[-0.5,1,0.5],[0.5,-1,0.5],[-0.5,1,-0.5],[2.5,0,-0.5],[2.5,0,0.5],[-1.5,0,0.5],[-1.5,0,-0.5],[-0.5,0,-0.5],[-0.5,0,0.5],[-2.5,-1,-0.5],[-2.5,-1,0.5],[0.5,0,-0.5],[0.5,0,0.5],[2.5,-1,0.5],[2.5,-1,-0.5],[-2.5,0,-0.5],[-2.5,0,0.5],[1.5,-1,-0.5]],
"edge":[[26,18],[22,14],[21,22],[10,3],[20,23],[24,13],[19,24],[17,18],[13,14],[12,10],[20,26],[19,25],[22,3],[23,14],[25,17],[21,13],[12,4],[21,4],[24,23],[4,3],[17,12],[18,10],[19,20],[25,26],[18,22],[11,22],[17,21],[9,21],[5,17],[6,18],[0,16],[16,15],[5,6],[9,11],[1,15],[0,1],[2,7],[8,7],[27,2],[27,8]],
"numthickedges":24,
"face":[[20,26,25,19],[19,0,1,20],[0,5,6,1],[5,9,11,6],[9,27,2,11],[27,24,23,2],[26,15,16,25],[15,18,17,16],[22,7,8,21],[7,14,13,8],[25,16,0,19],[16,17,5,0],[17,21,9,5],[12,4,21,17],[21,8,27,9],[8,13,24,27],[20,1,15,26],[1,6,18,15],[6,11,22,18],[18,22,3,10],[11,2,7,22],[2,23,14,7],[18,10,12,17],[21,4,3,22],[10,3,4,12],[24,13,14,23]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,1,2,1]},

Hexa32 : {
"name":"hexa#32 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [2,1,0], [3,1,0], [4,1,0]],
"vertex":[[-1.5,-1,-0.5],[-1.5,-1,0.5],[0.5,1,0.5],[0.5,1,-0.5],[-0.5,-1,-0.5],[-0.5,-1,0.5],[1.5,0,0.5],[1.5,0,-0.5],[0.5,-1,-0.5],[-0.5,1,-0.5],[0.5,-1,0.5],[-0.5,1,0.5],[2.5,0,-0.5],[2.5,0,0.5],[-1.5,0,0.5],[-1.5,0,-0.5],[-0.5,0,-0.5],[-0.5,0,0.5],[-2.5,-1,-0.5],[-2.5,-1,0.5],[0.5,0,-0.5],[0.5,0,0.5],[1.5,1,-0.5],[1.5,1,0.5],[2.5,1,0.5],[2.5,1,-0.5],[-2.5,0,-0.5],[-2.5,0,0.5]],
"edge":[[27,17],[21,13],[18,8],[20,21],[8,20],[8,10],[16,17],[9,11],[25,24],[12,13],[19,27],[18,26],[19,10],[26,16],[20,12],[12,25],[9,25],[13,24],[11,24],[16,9],[17,11],[18,19],[26,27],[10,21],[17,21],[20,3],[16,20],[4,16],[5,17],[21,2],[0,15],[15,14],[4,5],[22,23],[1,14],[0,1],[6,23],[7,6],[3,2],[7,22]],
"numthickedges":24,
"face":[[19,27,26,18],[18,0,1,19],[0,4,5,1],[4,8,10,5],[27,14,15,26],[14,17,16,15],[26,15,0,18],[15,16,4,0],[16,20,8,4],[9,3,20,16],[3,22,7,20],[22,25,12,7],[19,1,14,27],[1,5,17,14],[5,10,21,17],[17,21,2,11],[21,6,23,2],[6,13,24,23],[8,20,21,10],[17,11,9,16],[11,2,3,9],[2,23,22,3],[23,24,25,22],[20,7,6,21],[7,12,13,6],[12,25,24,13]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1,-1,2,2,2,-2,-2,1]},

Hexa33 : {
"name":"hexa#33 (plane)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [2,0,0], [3,0,0], [4,0,0], [5,0,0]],
"vertex":[[-2,-0.5,-0.5],[-2,-0.5,0.5],[1,-0.5,0.5],[-1,-0.5,-0.5],[-1,-0.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[2,0.5,0.5],[2,0.5,-0.5],[3,0.5,0.5],[3,0.5,-0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,0.5,0.5],[-1,0.5,-0.5],[-3,-0.5,-0.5],[-3,-0.5,0.5],[0,0.5,-0.5],[0,0.5,0.5],[3,-0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[-3,0.5,-0.5],[3,-0.5,-0.5],[-3,0.5,0.5],[1,-0.5,-0.5]],
"edge":[[18,26],[26,11],[24,12],[25,12],[21,11],[18,21],[17,25],[17,18],[24,26],[25,21],[12,11],[17,24],[0,14],[14,13],[19,20],[3,4],[23,10],[7,19],[16,15],[7,8],[10,9],[1,13],[0,1],[22,9],[2,5],[3,16],[6,5],[27,2],[8,20],[23,22],[4,15],[27,6]],
"numthickedges":12,
"face":[[18,26,24,17],[17,0,1,18],[0,3,4,1],[3,7,8,4],[7,27,2,8],[27,23,22,2],[23,25,21,22],[26,13,14,24],[13,15,16,14],[15,20,19,16],[20,5,6,19],[5,9,10,6],[9,11,12,10],[24,14,0,17],[14,16,3,0],[16,19,7,3],[19,6,27,7],[6,10,23,27],[10,12,25,23],[18,1,13,26],[1,4,15,13],[4,8,20,15],[8,2,5,20],[2,22,9,5],[22,21,11,9],[25,12,11,21]],
"facedirection":[-1,-2,-2,-2,-2,-2,-2,2,2,2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,1]},

Hexa34 : {
"name":"hexa#34, 'Latin cross' (plane)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [1,2,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,-0.5],[0,-0.5,0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[-1,1.5,-0.5],[-1,1.5,0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,14],[27,19],[14,13],[12,11],[27,6],[4,5],[26,13],[16,7],[11,6],[9,22],[12,27],[10,21],[19,23],[25,12],[1,13],[6,20],[15,16],[10,9],[21,22],[4,15],[10,23],[25,14],[15,8],[5,16],[9,24],[23,24],[0,1],[1,5],[26,11],[7,22],[8,7],[19,20],[8,21],[25,26],[20,24],[0,4],[14,27],[13,16],[6,9],[27,10],[13,6],[15,10],[14,15],[16,9],[18,17],[17,2],[18,3],[3,2]],
"numthickedges":36,
"face":[[26,11,12,25],[25,14,13,26],[15,18,17,16],[18,8,7,17],[11,6,27,12],[9,2,3,10],[2,22,21,3],[12,27,14,25],[14,15,4,0],[27,10,15,14],[19,23,10,27],[10,3,18,15],[3,21,8,18],[26,13,6,11],[1,5,16,13],[13,16,9,6],[6,9,24,20],[16,17,2,9],[17,7,22,2],[1,13,14,0],[6,20,19,27],[4,15,16,5],[10,23,24,9],[0,4,5,1],[20,24,23,19],[8,21,22,7]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,-1,1,1,-2,2,1]},

Hexa35 : {
"name":"hexa#35 (plane)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [2,1,0], [2,2,0], [3,1,0]],
"vertex":[[-1,-1.5,-0.5],[-1,-1.5,0.5],[1,0.5,0.5],[1,0.5,-0.5],[0,-1.5,-0.5],[0,-1.5,0.5],[-1,0.5,0.5],[2,-0.5,0.5],[2,-0.5,-0.5],[0,0.5,0.5],[0,0.5,-0.5],[-2,0.5,0.5],[-2,0.5,-0.5],[-1,-0.5,0.5],[-1,-0.5,-0.5],[0,-0.5,0.5],[0,-0.5,-0.5],[1,-0.5,0.5],[1,-0.5,-0.5],[2,0.5,-0.5],[2,0.5,0.5],[0,1.5,-0.5],[0,1.5,0.5],[1,1.5,-0.5],[1,1.5,0.5],[-2,-0.5,-0.5],[-2,-0.5,0.5],[-1,0.5,-0.5]],
"edge":[[0,14],[14,13],[12,11],[4,5],[26,13],[15,7],[21,23],[3,23],[25,12],[16,15],[10,9],[11,9],[2,20],[19,20],[25,14],[16,8],[4,16],[10,21],[2,24],[5,15],[9,22],[21,22],[1,13],[0,1],[1,5],[26,11],[7,20],[8,7],[22,24],[3,2],[12,10],[3,19],[8,19],[25,26],[23,24],[0,4],[14,27],[13,15],[18,3],[9,2],[14,16],[16,10],[17,2],[15,9],[13,6],[10,3],[18,17],[27,6]],
"numthickedges":36,
"face":[[26,11,12,25],[25,14,13,26],[16,18,17,15],[18,8,7,17],[11,6,27,12],[6,9,10,27],[2,20,19,3],[12,27,14,25],[14,16,4,0],[27,10,16,14],[10,3,18,16],[21,23,3,10],[3,19,8,18],[26,13,6,11],[1,5,15,13],[13,15,9,6],[15,17,2,9],[9,2,24,22],[17,7,20,2],[1,13,14,0],[4,16,15,5],[0,4,5,1],[9,22,21,10],[3,23,24,2],[22,24,23,21],[8,19,20,7]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,-3,3,3,3,3,3,3,-1,1,-2,-1,1,2,1]},

Hexa36 : {
"name":"hexa#36, 'bench' (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,1,1], [1,0,0], [1,0,1]],
"vertex":[[0,-1,-1],[0,-1,0],[-1,1,1],[0,0,1],[1,-1,-1],[-1,-1,1],[1,-1,0],[0,1,0],[1,0,1],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,0],[1,0,-1],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,1,1],[0,-1,1],[1,-1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[10,23],[23,18],[12,3],[3,18],[3,8],[2,18],[4,20],[14,8],[15,10],[4,14],[20,8],[15,4],[10,2],[15,5],[12,23],[5,20],[12,14],[5,2],[19,3],[17,3],[0,12],[21,12],[1,7],[22,13],[0,19],[16,9],[21,17],[16,6],[9,7],[6,13]],
"numthickedges":18,
"face":[[16,22,21,15],[5,17,22,16],[22,9,10,21],[17,2,9,22],[15,0,1,16],[16,1,19,5],[0,4,6,1],[1,6,20,19],[21,12,0,15],[10,23,12,21],[12,14,4,0],[5,19,3,17],[17,3,18,2],[19,20,8,3],[12,23,7,11],[11,7,18,3],[9,7,23,10],[2,18,7,9],[4,14,13,6],[6,13,8,20],[11,13,14,12],[3,8,13,11]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,3,3,3,1,1,2,2,1,1,2,2]},

Hexa37 : {
"name":"hexa#37 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,1,1], [1,0,0], [1,1,1]],
"vertex":[[0,-1,-1],[0,-1,0],[-1,1,1],[0,0,1],[1,-1,-1],[-1,-1,1],[1,-1,0],[0,1,0],[1,0,1],[1,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,0],[1,0,-1],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,1,1],[0,-1,1],[1,1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[20,3],[13,3],[5,20],[1,7],[4,6],[24,7],[13,24],[12,14],[7,9],[16,11],[15,8],[16,4],[16,5],[2,21],[1,20],[13,15],[1,6],[3,8],[4,15],[8,21],[11,2],[11,24],[5,2],[9,21],[6,9],[3,19],[7,19],[0,13],[23,12],[10,7],[0,1],[22,13],[17,1],[18,3],[17,10],[22,18]],
"numthickedges":25,
"face":[[17,23,22,16],[5,18,23,17],[23,10,11,22],[18,2,10,23],[16,0,1,17],[17,1,20,5],[0,4,6,1],[22,13,0,16],[11,24,13,22],[13,15,4,0],[1,12,3,20],[13,24,7,12],[5,20,3,18],[18,3,19,2],[3,8,21,19],[10,7,24,11],[2,19,7,10],[19,21,9,7],[4,15,14,6],[14,9,21,8],[12,14,15,13],[1,6,14,12],[12,14,8,3],[7,9,14,12]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,1,1,3,3,3,2,2,2,1,1,2,3,-2,-3]},

Hexa38 : {
"name":"hexa#38 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,1,1], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-1.5,1,1],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[1.5,-1,-1],[1.5,-1,0],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[16,8],[13,12],[19,20],[25,21],[5,22],[22,21],[13,25],[12,20],[13,19],[8,19],[16,11],[1,9],[8,9],[16,5],[2,21],[1,22],[1,12],[11,2],[11,25],[5,2],[9,20],[12,4],[0,13],[24,12],[23,13],[17,1],[0,1],[12,7],[3,6],[18,4],[15,14],[17,10],[23,18],[3,15],[10,7],[6,14]],
"numthickedges":21,
"face":[[17,24,23,16],[5,18,24,17],[24,10,11,23],[18,2,10,24],[16,0,1,17],[17,1,22,5],[0,3,6,1],[3,8,9,6],[23,13,0,16],[11,25,13,23],[13,15,3,0],[15,19,8,3],[1,12,4,22],[13,25,7,12],[12,7,21,4],[5,22,4,18],[18,4,21,2],[10,7,25,11],[2,21,7,10],[12,14,15,13],[14,20,19,15],[1,6,14,12],[6,9,20,14],[8,19,20,9]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,1,1,1,3,3,2,2,2,2,3,3,1]},

Hexa39 : {
"name":"hexa#39 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,2,0], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[0.5,-1.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-1.5,0],[-0.5,0.5,0],[1.5,-1.5,-1],[1.5,-1.5,0],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[17,3],[17,9],[24,5],[14,5],[20,21],[6,24],[26,2],[6,19],[14,23],[14,20],[26,21],[9,20],[19,5],[1,10],[9,10],[17,6],[1,24],[26,19],[1,22],[2,22],[3,23],[23,22],[3,2],[10,21],[18,26],[0,14],[25,14],[18,1],[0,1],[25,26],[12,11],[27,8],[4,7],[16,15],[4,16],[12,27],[11,8],[7,15]],
"numthickedges":24,
"face":[[18,26,25,17],[6,19,26,18],[26,11,12,25],[11,2,3,12],[17,0,1,18],[18,1,24,6],[0,4,7,1],[4,9,10,7],[25,14,0,17],[12,27,14,25],[3,23,27,12],[14,16,4,0],[16,20,9,4],[1,13,5,24],[14,27,8,13],[27,23,22,8],[19,5,13,26],[13,15,16,14],[15,21,20,16],[6,24,5,19],[26,13,8,11],[11,8,22,2],[1,7,15,13],[7,10,21,15],[2,22,23,3],[9,20,21,10]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,1,1,1,2,2,2,3,3,3,3,3,2,1]},

Hexa40 : {
"name":"hexa#40 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[-1,0,1],[-2,-1,1],[-1,1,-1],[0,-1,0],[-1,1,0],[2,0,0],[1,-1,-1],[1,-1,0],[2,0,-1],[-2,1,0],[-2,1,-1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,-1],[1,0,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[24,4],[16,4],[5,24],[1,8],[5,21],[14,13],[6,8],[16,6],[21,4],[19,14],[19,5],[1,24],[26,21],[26,13],[16,12],[2,9],[27,2],[1,2],[12,9],[14,6],[13,8],[26,9],[27,12],[0,16],[0,1],[25,26],[20,26],[25,16],[20,1],[22,23],[3,7],[10,22],[18,17],[10,11],[3,18],[11,23],[7,17]],
"numthickedges":24,
"face":[[20,26,25,19],[5,21,26,20],[26,13,14,25],[19,0,1,20],[20,1,24,5],[0,3,7,1],[3,10,11,7],[10,27,2,11],[25,16,0,19],[14,6,16,25],[16,18,3,0],[18,22,10,3],[22,12,27,10],[1,15,4,24],[16,6,8,15],[21,4,15,26],[15,17,18,16],[17,23,22,18],[23,9,12,22],[5,24,4,21],[13,8,6,14],[26,15,8,13],[1,7,17,15],[7,11,23,17],[11,2,9,23],[27,12,9,2]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,1,1,2,2,2,2,3,2,3,3,3,3,1]},

Hexa41 : {
"name":"hexa#41 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,0], [1,1,1]],
"vertex":[[0,-1,-1],[0,-1,0],[0,0,1],[1,-1,0],[-1,-1,1],[0,1,0],[1,0,1],[1,1,-1],[1,1,0],[-1,1,0],[-1,1,-1],[0,0,0],[0,0,-1],[1,0,0],[1,0,-1],[-1,-1,-1],[-1,-1,0],[-1,0,1],[0,1,1],[0,-1,1],[1,-1,1],[1,1,1],[-1,0,-1],[-1,0,0],[0,1,-1]],
"edge":[[0,12],[12,2],[1,5],[15,0],[5,18],[4,17],[10,9],[2,18],[17,2],[23,13],[15,10],[14,13],[15,4],[4,20],[12,14],[23,17],[0,1],[1,3],[23,9],[7,21],[9,5],[20,21],[18,21],[14,7],[10,7],[3,13],[3,20],[12,24],[24,5],[19,2],[2,6],[13,6],[22,12],[22,23],[1,19],[16,1],[16,23],[5,8],[13,8]],
"numthickedges":27,
"face":[[16,23,22,15],[4,17,23,16],[23,9,10,22],[0,12,11,1],[15,0,1,16],[16,1,19,4],[1,3,20,19],[22,12,0,15],[10,24,12,22],[24,7,14,12],[17,2,11,23],[4,19,2,17],[19,20,6,2],[2,6,21,18],[9,5,24,10],[5,8,7,24],[18,21,8,5],[23,11,5,9],[3,13,6,20],[14,7,8,13],[13,8,21,6],[11,13,3,1],[12,14,13,11],[2,18,5,11]],
"facedirection":[-1,-1,-1,1,-2,-2,-2,-3,-3,-3,2,3,3,3,2,2,2,3,1,1,1,-3,-2,-1]},

Hexa42 : {
"name":"hexa#42, 'throne' (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,0,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[17,8],[22,3],[14,3],[4,22],[23,24],[1,6],[4,19],[19,3],[7,12],[27,6],[5,9],[14,27],[24,12],[8,20],[25,14],[16,20],[6,9],[16,7],[10,9],[17,4],[1,22],[17,25],[8,24],[1,5],[27,10],[20,12],[23,7],[25,19],[16,10],[5,23],[0,14],[14,16],[0,1],[18,1],[5,11],[2,16],[2,5],[26,21],[18,26],[11,21]],
"numthickedges":30,
"face":[[18,26,25,17],[4,19,26,18],[17,0,1,18],[18,1,22,4],[0,2,5,1],[2,8,11,5],[5,11,24,23],[26,13,14,25],[19,3,13,26],[15,21,20,16],[7,12,21,15],[25,14,0,17],[14,16,2,0],[27,10,16,14],[16,20,8,2],[1,13,3,22],[4,22,3,19],[23,24,12,7],[1,5,15,13],[13,15,9,6],[13,6,27,14],[16,10,9,15],[6,9,10,27],[8,20,21,11],[11,21,12,24],[23,7,15,5]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,1,3,3,3,3,-1,1,2,1,1,-1]},

Hexa43 : {
"name":"hexa#43 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[17,4],[0,14],[27,23],[14,7],[18,26],[11,3],[21,20],[1,22],[17,0],[27,24],[19,2],[14,21],[26,20],[7,24],[19,7],[2,24],[20,5],[26,19],[3,22],[0,1],[11,2],[4,23],[11,5],[27,6],[18,1],[21,6],[23,22],[6,5],[4,3],[17,18],[14,27],[26,11],[25,14],[25,26],[12,11],[12,27],[10,9],[16,15],[16,10],[15,9]],
"numthickedges":30,
"face":[[18,26,25,17],[26,11,12,25],[19,2,11,26],[11,3,4,12],[0,14,13,1],[13,8,24,7],[27,23,22,8],[17,0,1,18],[25,14,0,17],[12,27,14,25],[4,23,27,12],[27,10,16,14],[10,6,21,16],[18,1,13,26],[11,8,22,3],[13,15,9,8],[15,20,5,9],[26,13,7,19],[14,16,15,13],[16,21,20,15],[2,24,8,11],[8,9,10,27],[9,5,6,10],[19,7,24,2],[3,22,23,4],[21,6,5,20]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,-2,-2,-2,2,2,2,3,2,1]},

Hexa44 : {
"name":"hexa#44 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[16,4],[17,26],[11,3],[26,19],[5,23],[1,20],[16,0],[18,2],[2,23],[10,23],[18,10],[19,5],[26,18],[3,20],[0,1],[0,21],[11,2],[4,21],[11,5],[17,1],[21,20],[4,3],[16,17],[19,10],[26,11],[25,26],[12,11],[14,6],[27,22],[6,22],[25,14],[15,8],[8,24],[12,27],[9,24],[15,9]],
"numthickedges":24,
"face":[[17,26,25,16],[26,11,12,25],[18,2,11,26],[11,3,4,12],[0,14,13,1],[14,27,7,13],[27,21,20,7],[16,0,1,17],[25,14,0,16],[12,27,14,25],[4,21,27,12],[17,1,13,26],[11,7,20,3],[26,13,6,18],[13,15,8,6],[15,19,10,8],[2,22,7,11],[22,24,9,7],[24,23,5,9],[18,6,22,2],[6,8,24,22],[8,10,23,24],[3,20,21,4],[7,9,15,13],[9,5,19,15],[19,5,23,10]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-3,-3,-3,3,3,-2,-2,-2,2,2,2,3,3,3,2,-3,-3,1]},

Hexa45 : {
"name":"hexa#45 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [1,1,1], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[18,2],[17,3],[0,14],[27,22],[14,6],[20,19],[27,23],[1,21],[9,4],[17,0],[14,20],[6,23],[16,19],[19,4],[2,21],[0,1],[6,8],[3,22],[16,8],[8,24],[27,5],[18,1],[20,5],[22,21],[5,4],[23,24],[9,24],[16,9],[3,2],[17,18],[14,27],[11,9],[25,14],[26,16],[15,16],[12,27],[10,9],[12,11],[15,10],[25,26]],
"numthickedges":30,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[0,14,13,1],[27,22,21,7],[17,0,1,18],[25,14,0,17],[12,27,14,25],[3,22,27,12],[27,10,15,14],[10,5,20,15],[18,1,13,26],[26,13,7,11],[11,7,21,2],[16,19,4,9],[2,21,22,3],[14,15,16,13],[13,16,8,6],[15,20,19,16],[7,9,10,27],[23,24,9,7],[9,4,5,10],[6,23,7,13],[16,9,24,8],[6,8,24,23],[20,5,4,19]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,-2,-2,-2,2,2,2,-1,1,3,1]},

Hexa46 : {
"name":"hexa#46 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[18,2],[17,3],[0,14],[27,21],[14,5],[27,22],[22,23],[1,20],[8,4],[4,23],[17,0],[5,10],[5,22],[10,23],[16,15],[9,8],[14,16],[15,19],[19,4],[2,20],[0,1],[27,9],[3,21],[18,1],[21,20],[16,9],[15,8],[3,2],[17,18],[19,10],[14,27],[11,8],[15,7],[8,24],[25,14],[26,15],[12,27],[12,11],[7,24],[25,26]],
"numthickedges":30,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[0,14,13,1],[27,21,20,6],[17,0,1,18],[25,14,0,17],[12,27,14,25],[3,21,27,12],[27,9,16,14],[18,1,13,26],[26,13,6,11],[11,6,20,2],[2,20,21,3],[16,9,8,15],[14,16,15,13],[13,15,7,5],[15,19,10,7],[6,8,9,27],[22,24,8,6],[24,23,4,8],[5,22,6,13],[5,7,24,22],[7,10,23,24],[19,4,23,10],[8,4,19,15]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,3,3,3,2,1,-2,-2,-2,2,2,2,-1,3,3,1,-3]},

Hexa47 : {
"name":"hexa#47 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,1,0], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[18,2],[17,3],[0,14],[27,22],[14,13],[17,0],[7,10],[27,6],[14,20],[13,15],[6,8],[1,13],[6,21],[10,23],[2,21],[0,1],[3,22],[15,7],[20,10],[7,24],[27,5],[18,1],[20,5],[22,21],[24,23],[8,24],[15,8],[5,23],[3,2],[17,18],[14,27],[25,14],[26,13],[15,19],[11,6],[8,4],[13,6],[16,15],[12,27],[9,8],[12,11],[19,4],[16,9],[25,26]],
"numthickedges":30,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[0,14,13,1],[27,22,21,6],[17,0,1,18],[25,14,0,17],[12,27,14,25],[3,22,27,12],[27,9,16,14],[9,5,20,16],[18,1,13,26],[26,13,6,11],[11,6,21,2],[13,15,8,6],[2,21,22,3],[14,16,15,13],[16,20,19,15],[15,19,10,7],[6,8,9,27],[8,4,5,9],[24,23,4,8],[20,5,4,19],[19,4,23,10],[7,24,8,15],[7,10,23,24]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,-2,-2,-2,2,2,2,1,1,-1,3]},

Hexa48 : {
"name":"hexa#48 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,18],[12,4],[1,17],[9,2],[15,0],[27,19],[18,22],[10,9],[17,23],[3,22],[4,19],[15,10],[2,23],[8,24],[14,6],[12,14],[0,1],[4,6],[16,9],[6,24],[10,27],[8,3],[16,1],[18,17],[3,2],[19,24],[14,8],[15,16],[22,23],[12,27],[25,12],[27,8],[8,20],[26,13],[20,21],[13,21],[25,26]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,14,12],[18,20,8,27],[20,22,3,8],[16,1,11,26],[26,11,5,9],[5,7,21,17],[7,2,23,21],[9,5,27,10],[19,24,7,5],[14,8,7,13],[13,7,24,6],[12,14,13,11],[11,13,6,4],[4,19,5,11],[5,17,18,27],[4,6,24,19],[17,21,20,18],[21,23,22,20],[3,22,23,2],[8,3,2,7]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,1,1,-2,-2,-1,-1,3,2,2,1,-2]},

Hexa49 : {
"name":"hexa#49 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[14,3],[1,4],[17,0],[4,20],[3,8],[11,10],[24,9],[3,20],[8,12],[17,11],[16,15],[7,24],[15,21],[14,16],[15,19],[0,1],[18,10],[23,12],[19,23],[10,4],[18,1],[9,12],[21,23],[20,24],[21,9],[16,7],[11,7],[17,18],[19,8],[14,27],[27,4],[5,24],[15,5],[25,14],[26,15],[4,2],[24,22],[2,22],[25,26]],
"numthickedges":30,
"face":[[18,26,25,17],[26,10,11,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[11,27,14,25],[27,7,16,14],[18,1,13,26],[26,13,4,10],[10,4,27,11],[4,6,7,27],[20,24,6,4],[16,7,6,15],[14,16,15,13],[13,15,5,3],[15,19,8,5],[3,20,4,13],[3,5,24,20],[5,8,22,24],[24,22,12,9],[19,2,22,8],[2,23,12,22],[6,2,19,15],[21,23,2,6],[24,9,21,6],[9,12,23,21]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,3,3,2,2,2,1,-2,-2,-2,-1,3,3,3,1,1,-3,-3,-1,2]},

Hexa50 : {
"name":"hexa#50 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,1], [1,0,0], [1,0,1], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-1.5,1,1],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-1.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[20,3],[17,3],[6,9],[4,5],[17,2],[25,18],[23,9],[14,6],[15,4],[2,22],[1,20],[16,10],[15,24],[24,17],[1,11],[10,2],[10,8],[4,14],[7,23],[6,22],[24,14],[16,1],[5,7],[8,22],[11,3],[5,8],[15,16],[7,18],[20,23],[18,9],[3,19],[3,6],[5,21],[0,1],[11,26],[21,6],[1,5],[12,11],[0,12],[26,19]],
"numthickedges":30,
"face":[[16,25,24,15],[17,2,10,25],[15,0,1,16],[0,4,5,1],[1,5,21,20],[5,7,23,21],[25,11,12,24],[11,13,14,12],[6,9,18,13],[24,12,0,15],[12,14,4,0],[16,1,11,25],[25,11,3,17],[2,19,26,10],[19,22,8,26],[10,26,11,25],[26,8,13,11],[13,18,7,5],[17,3,19,2],[20,21,6,3],[3,6,22,19],[21,23,9,6],[4,14,13,5],[13,8,22,6],[20,3,11,1],[7,18,9,23]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,3,-2,2,2,-3,-3,-3,3,3,3,3,1,1,-1,1]},

Hexa51 : {
"name":"hexa#51 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,1,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,-1],[0.5,1,0],[1.5,-1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[15,7],[12,11],[17,18],[25,19],[20,19],[20,21],[12,25],[7,17],[23,12],[13,17],[7,10],[13,14],[1,20],[24,11],[14,18],[16,24],[15,23],[1,11],[25,8],[8,22],[16,1],[4,10],[10,18],[21,22],[19,22],[13,8],[4,14],[15,16],[23,24],[4,21],[11,3],[0,12],[12,13],[14,6],[0,1],[11,14],[11,5],[1,4],[2,13],[14,9],[2,4],[5,9],[3,6]],
"numthickedges":30,
"face":[[16,24,23,15],[15,0,1,16],[0,2,4,1],[1,4,21,20],[2,7,10,4],[24,11,12,23],[14,18,17,13],[23,12,0,15],[12,13,2,0],[25,8,13,12],[13,17,7,2],[16,1,11,24],[4,10,18,14],[20,3,11,1],[11,5,25,12],[3,19,5,11],[4,14,6,21],[13,8,9,14],[14,9,22,6],[20,21,6,3],[3,6,22,19],[5,9,8,25],[19,22,9,5],[7,17,18,10]],
"facedirection":[-1,-2,-2,-2,-2,2,2,-3,-3,-3,-3,3,3,-1,-1,-1,1,1,1,3,3,2,2,1]},

Hexa52 : {
"name":"hexa#52 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,11],[25,18],[18,20],[8,2],[2,20],[19,18],[7,10],[12,25],[19,21],[10,20],[9,8],[15,4],[1,19],[24,11],[13,17],[16,24],[15,23],[17,2],[1,11],[23,12],[25,9],[13,7],[21,7],[16,1],[4,21],[13,8],[15,16],[23,24],[4,9],[17,10],[11,3],[6,8],[3,7],[0,12],[8,22],[0,1],[11,13],[11,6],[12,14],[14,13],[7,22],[1,5],[5,13]],
"numthickedges":30,
"face":[[16,24,23,15],[15,0,1,16],[0,4,5,1],[1,5,21,19],[24,11,12,23],[23,12,0,15],[12,14,4,0],[25,9,14,12],[16,1,11,24],[4,14,13,5],[5,13,7,21],[14,9,8,13],[19,3,11,1],[11,6,25,12],[3,18,6,11],[19,21,7,3],[3,7,22,18],[7,10,20,22],[6,8,9,25],[18,22,8,6],[22,20,2,8],[17,2,20,10],[13,17,10,7],[8,2,17,13]],
"facedirection":[-1,-2,-2,-2,2,-3,-3,-3,3,1,1,1,-1,-1,-1,3,3,3,2,2,2,1,-2,-3]},

Hexa53 : {
"name":"hexa#53 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[-1,0,1],[0,-1,0],[-1,1,-1],[-1,1,0],[2,0,0],[0,0,1],[1,-1,-1],[0,1,0],[0,1,-1],[1,-1,0],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[-1,-1,1],[0,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[16,4],[23,4],[1,7],[20,1],[5,2],[6,7],[26,8],[23,24],[16,6],[7,11],[17,9],[12,11],[25,16],[17,14],[1,23],[20,26],[19,25],[4,9],[6,12],[2,8],[27,2],[14,8],[24,9],[17,12],[5,11],[19,20],[25,26],[5,24],[27,14],[1,5],[0,16],[16,17],[0,1],[3,17],[3,5],[21,22],[10,21],[10,13],[13,22]],
"numthickedges":30,
"face":[[20,26,25,19],[19,0,1,20],[0,3,5,1],[1,5,24,23],[3,10,13,5],[10,27,2,13],[26,15,16,25],[4,9,18,15],[18,22,21,17],[22,8,14,21],[25,16,0,19],[16,17,3,0],[6,12,17,16],[17,21,10,3],[21,14,27,10],[20,1,15,26],[15,18,11,7],[5,13,22,18],[13,2,8,22],[23,4,15,1],[15,7,6,16],[5,18,9,24],[17,12,11,18],[23,24,9,4],[7,11,12,6],[27,14,8,2]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,-1,1,1,3,2,1]},

Hexa54 : {
"name":"hexa#54 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,1,0], [0,1,1], [1,0,0], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[-0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[27,20],[19,18],[14,8],[27,22],[1,21],[9,3],[5,6],[17,2],[20,23],[25,12],[17,8],[8,22],[25,14],[16,19],[16,15],[10,9],[23,24],[5,16],[10,23],[6,15],[9,24],[2,22],[15,18],[18,3],[0,1],[1,6],[12,2],[12,27],[10,4],[19,4],[4,3],[20,21],[25,17],[21,24],[0,5],[14,27],[11,9],[14,16],[16,10],[15,9],[26,15],[27,10],[26,11]],
"numthickedges":36,
"face":[[26,11,12,25],[17,2,11,26],[25,14,13,26],[26,13,8,17],[16,19,18,15],[11,7,27,12],[2,22,7,11],[9,3,4,10],[12,27,14,25],[14,16,5,0],[27,10,16,14],[20,23,10,27],[10,4,19,16],[13,7,22,8],[17,8,22,2],[1,13,14,0],[7,21,20,27],[5,16,15,6],[10,23,24,9],[0,5,6,1],[1,6,15,13],[13,15,9,7],[7,9,24,21],[15,18,3,9],[21,24,23,20],[19,4,3,18]],
"facedirection":[-1,-1,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,1,3,-1,-1,1,1,-2,3,3,3,3,2,1]},

Hexa55 : {
"name":"hexa#55 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [1,1,1], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[27,19],[14,6],[18,17],[1,20],[11,2],[27,21],[12,11],[4,5],[19,22],[25,12],[6,21],[26,17],[25,14],[16,18],[16,8],[10,24],[22,23],[4,16],[10,22],[5,23],[17,2],[0,1],[1,5],[26,11],[6,8],[8,24],[12,27],[10,3],[18,3],[3,2],[19,20],[21,24],[25,26],[20,23],[0,4],[14,27],[14,16],[16,10],[27,10]],
"numthickedges":36,
"face":[[26,11,12,25],[25,14,13,26],[13,15,8,6],[16,18,17,15],[11,7,27,12],[21,24,9,7],[9,2,3,10],[12,27,14,25],[14,16,4,0],[27,10,16,14],[19,22,10,27],[10,3,18,16],[26,13,7,11],[1,5,15,13],[7,9,23,20],[15,17,2,9],[1,13,14,0],[6,21,7,13],[7,20,19,27],[4,16,15,5],[15,9,24,8],[10,22,23,9],[0,4,5,1],[6,8,24,21],[20,23,22,19],[18,3,2,17]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,-1,-1,1,1,1,-2,3,2,1]},

Hexa56 : {
"name":"hexa#56 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [1,1,1], [1,2,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[27,18],[14,3],[20,23],[1,19],[2,23],[11,2],[27,20],[3,10],[12,11],[4,5],[26,17],[18,21],[25,12],[3,20],[10,23],[21,22],[5,22],[17,2],[0,1],[1,5],[26,11],[25,14],[12,27],[18,19],[25,26],[4,21],[0,4],[19,22],[17,10],[14,27],[14,16],[27,9],[16,7],[9,24],[7,24]],
"numthickedges":30,
"face":[[26,11,12,25],[25,14,13,26],[13,15,7,3],[15,17,10,7],[11,6,27,12],[20,24,8,6],[24,23,2,8],[12,27,14,25],[14,16,4,0],[27,9,16,14],[18,21,9,27],[26,13,6,11],[1,5,15,13],[6,8,22,19],[1,13,14,0],[3,20,6,13],[6,19,18,27],[4,16,15,5],[16,9,8,15],[9,21,22,8],[0,4,5,1],[3,7,24,20],[7,10,23,24],[19,22,21,18],[17,2,23,10],[8,2,17,15]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,-3,3,3,3,-1,-1,-1,1,1,1,-2,3,3,2,1,-3]},

Hexa57 : {
"name":"hexa#57 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,0], [1,1,0], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[-0.5,-0.5,1],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,16],[20,11],[16,6],[6,11],[1,20],[13,2],[2,23],[6,10],[14,13],[3,4],[4,22],[26,19],[24,12],[25,14],[10,23],[9,24],[19,2],[0,1],[1,4],[26,13],[25,16],[24,23],[22,12],[11,12],[14,9],[3,9],[25,26],[0,3],[20,22],[19,10],[16,27],[7,24],[16,18],[21,24],[27,21],[18,7]],
"numthickedges":30,
"face":[[26,13,14,25],[25,16,15,26],[15,17,7,6],[17,19,10,7],[13,5,27,14],[5,8,9,27],[24,23,2,8],[14,27,16,25],[16,18,3,0],[27,9,18,16],[26,15,5,13],[1,4,17,15],[1,15,16,0],[6,21,5,15],[21,11,20,5],[3,18,17,4],[18,9,8,17],[8,22,12,24],[0,3,4,1],[6,7,24,21],[21,24,12,11],[7,10,23,24],[11,12,22,20],[20,22,8,5],[8,2,19,17],[19,2,23,10]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,3,3,-1,-1,-1,1,1,1,-2,3,3,3,2,-3,-3,1]},

Hexa58 : {
"name":"hexa#58 (symmetric)",
"category":["Hexacubes"],
"cell":[[0,1,0], [1,0,1], [1,1,0], [1,1,1], [1,2,1], [2,1,0]],
"vertex":[[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[0.5,-1.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[19,9],[18,17],[26,17],[0,19],[11,1],[12,11],[22,23],[23,10],[25,12],[12,2],[4,21],[25,18],[0,22],[17,1],[0,4],[26,11],[18,2],[2,1],[21,10],[9,10],[25,26],[4,23],[19,21],[22,9],[14,3],[27,20],[14,27],[8,24],[16,6],[3,6],[20,24],[16,8]],
"numthickedges":24,
"face":[[26,11,12,25],[25,14,13,26],[14,16,15,13],[16,18,17,15],[11,5,27,12],[5,7,8,27],[7,1,2,8],[12,27,14,25],[27,8,16,14],[8,2,18,16],[26,13,5,11],[15,17,1,7],[22,3,13,0],[3,20,5,13],[20,9,19,5],[4,15,6,23],[15,7,24,6],[7,21,10,24],[0,4,23,22],[13,15,4,0],[19,21,7,5],[22,23,6,3],[3,6,24,20],[20,24,10,9],[9,10,21,19],[18,2,1,17]],
"facedirection":[-1,-2,-2,-2,2,2,2,-3,-3,-3,3,3,-1,-1,-1,1,1,1,-2,-3,-3,3,3,3,2,1]},

Hexa59 : {
"name":"hexa#59 (mirror of #60, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,2,0], [1,0,1], [2,0,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[-0.5,-0.5,1],[0.5,-1.5,0],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[1.5,-1.5,0],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,-1.5,1],[0.5,-1.5,1],[1.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[16,3],[26,2],[26,19],[16,0],[6,18],[24,10],[1,9],[18,10],[16,6],[6,24],[26,18],[1,20],[2,20],[0,1],[0,21],[3,21],[9,24],[21,20],[3,2],[9,19],[19,10],[17,26],[17,1],[25,26],[1,22],[14,4],[22,4],[12,11],[27,7],[25,14],[15,8],[23,8],[12,27],[11,7],[5,15],[5,23]],
"numthickedges":21,
"face":[[17,26,25,16],[6,18,26,17],[26,11,12,25],[11,2,3,12],[0,14,13,1],[14,27,7,13],[27,21,20,7],[16,0,1,17],[17,1,22,6],[1,5,23,22],[5,9,24,23],[25,14,0,16],[12,27,14,25],[3,21,27,12],[18,4,13,26],[4,8,15,13],[8,10,19,15],[6,22,4,18],[22,23,8,4],[23,24,10,8],[26,13,7,11],[11,7,20,2],[2,20,21,3],[13,15,5,1],[15,19,9,5],[9,19,10,24]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-2,-2,-2,-3,-3,-3,2,2,2,3,3,3,3,3,2,-3,-3,1]},

Hexa60 : {
"name":"hexa#60 (mirror of #59, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [0,2,1], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[0.5,-1.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-1.5,0],[1.5,-1.5,-1],[1.5,-1.5,0],[-0.5,1.5,1],[-1.5,0.5,0],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[-0.5,-1.5,1],[-1.5,1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[16,8],[21,10],[19,20],[6,23],[26,3],[26,20],[24,10],[8,19],[1,9],[8,9],[16,6],[25,19],[1,23],[16,25],[1,21],[3,21],[3,24],[6,24],[25,26],[9,20],[23,10],[17,26],[17,1],[0,1],[26,18],[0,13],[13,5],[27,22],[4,7],[18,5],[15,14],[2,22],[11,2],[4,15],[11,27],[7,14]],
"numthickedges":21,
"face":[[17,26,25,16],[6,18,26,17],[18,2,11,26],[2,24,3,11],[16,0,1,17],[17,1,23,6],[0,4,7,1],[4,8,9,7],[26,12,13,25],[12,14,15,13],[14,20,19,15],[25,13,0,16],[13,15,4,0],[15,19,8,4],[1,12,5,23],[12,27,22,5],[27,21,10,22],[6,23,5,18],[18,5,22,2],[2,22,10,24],[11,27,12,26],[3,21,27,11],[24,10,21,3],[1,7,14,12],[7,9,20,14],[8,19,20,9]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,1,1,1,3,3,3,-3,-3,2,3,3,1]},

Hexa61 : {
"name":"hexa#61 (mirror of #62, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,2,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[17,3],[0,14],[27,23],[24,6],[14,6],[21,20],[7,24],[26,2],[26,20],[17,0],[7,19],[27,8],[14,21],[0,24],[19,6],[8,22],[17,7],[20,4],[26,19],[2,22],[3,23],[27,5],[21,5],[23,22],[5,4],[8,4],[3,2],[14,27],[18,26],[25,14],[1,8],[25,26],[12,27],[11,8],[12,11],[10,9],[16,15],[18,1],[16,10],[15,9]],
"numthickedges":27,
"face":[[18,26,25,17],[7,19,26,18],[26,11,12,25],[11,2,3,12],[0,14,13,1],[1,13,6,24],[27,23,22,8],[17,0,1,18],[18,1,24,7],[25,14,0,17],[12,27,14,25],[3,23,27,12],[27,10,16,14],[10,5,21,16],[19,6,13,26],[7,24,6,19],[26,13,8,11],[11,8,22,2],[13,15,9,8],[15,20,4,9],[2,22,23,3],[14,16,15,13],[16,21,20,15],[8,9,10,27],[9,4,5,10],[21,5,4,20]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,3,3,3,3,2,-2,-2,2,2,1]},

Hexa62 : {
"name":"hexa#62 (mirror of #61, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [0,2,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[-0.5,1.5,1],[-1.5,0.5,0],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[-0.5,-1.5,1],[-1.5,1.5,1],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[0,13],[19,10],[21,5],[20,10],[13,5],[6,21],[20,23],[26,3],[26,18],[4,23],[15,0],[27,20],[5,9],[22,10],[0,21],[27,19],[9,23],[15,6],[15,25],[18,4],[3,19],[25,13],[3,22],[6,22],[27,4],[25,26],[18,9],[5,20],[2,20],[16,26],[17,5],[1,27],[11,27],[26,17],[11,2],[14,7],[7,24],[16,1],[8,24],[14,8]],
"numthickedges":27,
"face":[[16,26,25,15],[6,17,26,16],[17,2,11,26],[2,22,3,11],[0,13,12,1],[1,12,5,21],[27,19,10,20],[15,0,1,16],[16,1,21,6],[26,12,13,25],[25,13,0,15],[6,21,5,17],[17,5,20,2],[2,20,10,22],[5,7,24,20],[7,9,23,24],[11,27,12,26],[3,19,27,11],[27,8,14,12],[8,4,18,14],[22,10,19,3],[12,14,7,5],[14,18,9,7],[20,24,8,27],[24,23,4,8],[18,4,23,9]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-2,2,-3,3,3,3,3,3,-3,-3,-3,-3,2,-2,-2,2,2,1]},

Hexa63 : {
"name":"hexa#63 (mirror of #64, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [0,2,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[15,3],[21,6],[7,21],[26,2],[13,8],[15,0],[7,17],[27,8],[0,21],[5,23],[17,6],[4,24],[15,7],[26,17],[0,27],[3,23],[2,24],[27,5],[5,4],[8,4],[13,6],[3,2],[23,24],[26,13],[16,26],[1,13],[8,19],[25,26],[27,18],[12,27],[11,8],[14,13],[12,11],[20,22],[10,9],[10,20],[9,22],[25,14],[16,1],[18,19]],
"numthickedges":24,
"face":[[16,26,25,15],[7,17,26,16],[26,11,12,25],[11,2,3,12],[0,14,13,1],[1,13,6,21],[14,27,8,13],[15,0,1,16],[16,1,21,7],[25,14,0,15],[12,27,14,25],[3,18,27,12],[18,20,10,27],[20,23,5,10],[17,6,13,26],[7,21,6,17],[26,13,8,11],[11,8,19,2],[8,9,22,19],[9,4,24,22],[2,19,18,3],[19,22,20,18],[22,24,23,20],[27,10,9,8],[10,5,4,9],[5,23,24,4]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,3,3,3,3,2,2,2,-2,-2,1]},

Hexa64 : {
"name":"hexa#64 (mirror of #63, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [0,2,1], [1,2,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,0.5,0],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[-1.5,1.5,1],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[0,13],[13,12],[6,20],[18,22],[26,3],[12,27],[4,22],[14,0],[27,18],[20,18],[0,20],[4,23],[14,6],[14,25],[22,11],[25,13],[23,11],[3,23],[3,21],[6,21],[27,4],[21,11],[25,26],[26,12],[12,5],[2,18],[15,26],[1,12],[27,17],[18,8],[10,27],[26,16],[17,8],[24,9],[16,5],[7,19],[10,2],[15,1],[7,24],[19,9]],
"numthickedges":24,
"face":[[15,26,25,14],[6,16,26,15],[16,2,10,26],[2,21,3,10],[0,13,12,1],[1,12,5,20],[12,27,18,5],[14,0,1,15],[15,1,20,6],[26,12,13,25],[25,13,0,14],[6,20,5,16],[16,5,18,2],[2,18,8,21],[18,24,9,8],[24,22,11,9],[10,27,12,26],[3,17,27,10],[17,19,7,27],[19,23,4,7],[21,8,17,3],[8,9,19,17],[9,11,23,19],[27,7,24,18],[7,4,22,24],[4,23,11,22]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-2,2,-3,3,3,3,3,3,-3,-3,-3,-3,2,2,2,-2,-2,1]},

Hexa65 : {
"name":"hexa#65 (mirror of #66, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [1,0,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[1.5,-1,0],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[16,8],[13,12],[19,20],[12,6],[4,18],[11,10],[25,6],[13,25],[13,19],[8,19],[18,7],[16,11],[8,9],[16,4],[4,22],[24,12],[14,20],[24,18],[24,10],[14,7],[22,7],[11,25],[10,6],[5,9],[5,14],[5,22],[9,20],[12,3],[1,12],[0,13],[23,13],[12,14],[23,24],[17,24],[15,14],[17,5],[2,5],[21,3],[0,21],[2,15]],
"numthickedges":27,
"face":[[17,24,23,16],[4,18,24,17],[24,10,11,23],[16,0,1,17],[17,1,21,4],[0,2,5,1],[1,5,22,21],[2,8,9,5],[23,13,0,16],[11,25,13,23],[13,15,2,0],[15,19,8,2],[18,3,12,24],[12,14,15,13],[3,7,14,12],[14,20,19,15],[4,21,3,18],[21,22,7,3],[13,25,6,12],[10,6,25,11],[24,12,6,10],[5,9,20,14],[5,14,7,22],[8,19,20,9]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-3,2,2,2,2,3,3,1,2,3,3,1,1]},

Hexa66 : {
"name":"hexa#66 (mirror of #65, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[17,7],[22,3],[20,21],[4,22],[4,19],[12,11],[7,20],[19,3],[16,20],[17,12],[1,10],[7,10],[16,15],[9,8],[17,4],[1,22],[24,13],[15,21],[24,19],[1,13],[24,11],[11,8],[13,3],[16,9],[12,9],[15,8],[10,21],[23,16],[18,1],[0,1],[13,15],[23,24],[13,6],[18,24],[14,13],[2,16],[5,15],[0,25],[25,6],[2,5]],
"numthickedges":27,
"face":[[18,24,23,17],[4,19,24,18],[24,11,12,23],[17,0,1,18],[18,1,22,4],[0,2,5,1],[2,7,10,5],[23,14,0,17],[12,25,14,23],[14,16,2,0],[25,9,16,14],[16,20,7,2],[1,13,3,22],[19,3,13,24],[15,21,20,16],[4,22,3,19],[11,6,25,12],[6,8,9,25],[24,13,6,11],[1,5,15,13],[13,15,8,6],[5,10,21,15],[16,9,8,15],[7,20,21,10]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,1,2,2,3,2,2,3,3,3,3,1,1]},

Hexa67 : {
"name":"hexa#67 (mirror of #68, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [1,0,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[13,12],[12,6],[4,18],[11,10],[3,5],[25,6],[13,25],[22,9],[16,11],[18,9],[15,14],[16,3],[16,4],[13,15],[4,22],[24,12],[14,19],[24,18],[24,10],[3,15],[8,22],[11,25],[10,6],[5,8],[5,14],[8,19],[19,9],[12,2],[1,12],[5,21],[0,13],[14,7],[23,13],[12,14],[23,24],[17,24],[17,5],[20,2],[0,20],[21,7]],
"numthickedges":27,
"face":[[17,24,23,16],[4,18,24,17],[24,10,11,23],[16,0,1,17],[17,1,20,4],[0,3,5,1],[1,5,21,20],[5,8,22,21],[23,13,0,16],[11,25,13,23],[13,15,3,0],[18,2,12,24],[12,14,15,13],[2,7,14,12],[7,9,19,14],[4,20,2,18],[20,21,7,2],[21,22,9,7],[13,25,6,12],[10,6,25,11],[24,12,6,10],[3,15,14,5],[8,19,9,22],[14,19,8,5]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,2,2,2,2,3,3,3,1,2,3,1,1,-3]},

Hexa68 : {
"name":"hexa#68 (mirror of #67, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,1,0],[0.5,1,-1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[22,4],[21,20],[6,22],[6,19],[12,11],[5,7],[19,4],[16,21],[12,3],[17,12],[16,15],[17,5],[17,6],[1,22],[24,13],[15,20],[20,2],[24,19],[1,13],[1,7],[24,11],[5,16],[21,3],[11,2],[3,2],[13,4],[7,15],[23,16],[0,1],[13,15],[23,24],[13,8],[18,1],[18,24],[16,10],[14,13],[15,9],[0,25],[25,8],[10,9]],
"numthickedges":27,
"face":[[18,24,23,17],[6,19,24,18],[24,11,12,23],[17,0,1,18],[18,1,22,6],[0,5,7,1],[23,14,0,17],[12,25,14,23],[14,16,5,0],[25,10,16,14],[10,3,21,16],[1,13,4,22],[19,4,13,24],[6,22,4,19],[11,8,25,12],[8,9,10,25],[9,2,3,10],[24,13,8,11],[1,7,15,13],[13,15,9,8],[15,20,2,9],[5,16,15,7],[21,3,2,20],[16,21,20,15]],
"facedirection":[-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,1,2,3,2,2,2,3,3,3,3,1,1,-2]},

Hexa69 : {
"name":"hexa#69 (mirror of #70, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [2,0,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[1.5,-1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[17,8],[22,3],[14,3],[4,22],[23,24],[1,5],[4,19],[19,3],[7,10],[12,11],[27,5],[14,27],[14,20],[24,10],[8,20],[26,15],[17,12],[17,4],[1,22],[8,24],[26,19],[1,6],[26,11],[15,7],[20,10],[23,7],[12,27],[11,5],[6,15],[6,23],[0,14],[25,14],[15,21],[0,1],[25,26],[18,1],[6,9],[18,26],[16,15],[2,6],[2,16],[9,21]],
"numthickedges":30,
"face":[[18,26,25,17],[4,19,26,18],[26,11,12,25],[17,0,1,18],[18,1,22,4],[0,2,6,1],[2,8,9,6],[6,9,24,23],[25,14,0,17],[12,27,14,25],[14,16,2,0],[16,20,8,2],[1,13,3,22],[14,27,5,13],[19,3,13,26],[13,15,16,14],[15,21,20,16],[7,10,21,15],[4,22,3,19],[23,24,10,7],[11,5,27,12],[26,13,5,11],[1,6,15,13],[8,20,21,9],[9,21,10,24],[23,7,15,6]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-3,1,1,2,2,2,2,3,3,2,3,3,1,1,-1]},

Hexa70 : {
"name":"hexa#70 (mirror of #69, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,-1,0],[1.5,-1,-1],[0.5,1,0],[1.5,-1,0],[0.5,1,-1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[19,9],[9,3],[24,5],[16,5],[6,24],[1,7],[13,7],[10,2],[6,21],[14,13],[27,7],[16,27],[21,5],[26,17],[19,14],[1,11],[9,11],[18,17],[12,10],[19,6],[1,24],[16,18],[26,21],[26,13],[11,2],[14,27],[12,3],[3,2],[18,12],[17,10],[0,16],[17,23],[20,1],[0,1],[25,16],[18,22],[25,26],[20,26],[4,18],[8,17],[22,23],[4,8]],
"numthickedges":30,
"face":[[20,26,25,19],[6,21,26,20],[26,13,14,25],[19,0,1,20],[20,1,24,6],[0,4,8,1],[4,9,11,8],[25,16,0,19],[14,27,16,25],[16,18,4,0],[18,22,9,4],[12,3,22,18],[1,15,5,24],[16,27,7,15],[21,5,15,26],[15,17,18,16],[6,24,5,21],[13,7,27,14],[10,2,3,12],[26,15,7,13],[1,8,17,15],[8,11,23,17],[17,23,2,10],[9,22,23,11],[22,3,2,23],[17,10,12,18]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-3,1,1,2,2,3,2,2,3,3,3,3,1,1,-1]},

Hexa71 : {
"name":"hexa#71 (mirror of #72, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,14],[14,13],[25,20],[17,0],[4,19],[12,11],[23,10],[17,12],[1,7],[19,10],[9,8],[16,15],[17,4],[14,16],[4,23],[25,19],[1,13],[0,1],[25,11],[11,8],[7,23],[16,9],[12,9],[15,8],[7,20],[20,10],[14,26],[13,2],[18,1],[15,6],[24,14],[24,25],[13,5],[1,21],[18,25],[3,15],[21,2],[26,5],[22,6],[3,22]],
"numthickedges":26,
"face":[[18,25,24,17],[4,19,25,18],[25,11,12,24],[0,14,13,1],[17,0,1,18],[18,1,21,4],[1,3,22,21],[3,7,23,22],[24,14,0,17],[12,26,14,24],[26,9,16,14],[19,2,13,25],[2,6,15,13],[6,10,20,15],[4,21,2,19],[21,22,6,2],[22,23,10,6],[11,5,26,12],[5,8,9,26],[25,13,5,11],[13,15,8,5],[13,15,3,1],[15,20,7,3],[16,9,8,15],[14,16,15,13],[7,20,10,23]],
"facedirection":[-1,-1,-1,1,-2,-2,-2,-2,-3,-3,-3,2,2,2,3,3,3,2,2,3,3,-3,-3,1,-2,1]},

Hexa72 : {
"name":"hexa#72 (mirror of #71, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,14],[14,13],[21,20],[25,20],[17,0],[6,19],[12,11],[14,21],[19,8],[12,3],[17,12],[17,6],[6,23],[20,2],[25,19],[1,13],[0,1],[1,5],[25,11],[15,8],[23,8],[21,3],[11,2],[3,2],[5,15],[5,23],[14,26],[13,4],[24,14],[24,25],[13,7],[1,22],[18,1],[18,25],[16,15],[15,9],[22,4],[26,7],[10,9],[16,10]],
"numthickedges":26,
"face":[[18,25,24,17],[6,19,25,18],[25,11,12,24],[0,14,13,1],[17,0,1,18],[18,1,22,6],[1,5,23,22],[24,14,0,17],[12,26,14,24],[26,10,16,14],[10,3,21,16],[19,4,13,25],[4,8,15,13],[6,22,4,19],[22,23,8,4],[11,7,26,12],[7,9,10,26],[9,2,3,10],[25,13,7,11],[13,15,9,7],[15,20,2,9],[5,15,8,23],[13,15,5,1],[14,16,15,13],[16,21,20,15],[21,3,2,20]],
"facedirection":[-1,-1,-1,1,-2,-2,-2,-3,-3,-3,-3,2,2,3,3,2,2,2,3,3,3,1,-3,-2,-2,1]},

Hexa73 : {
"name":"hexa#73 (mirror of #74, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[1,5],[15,0],[26,19],[4,17],[17,2],[6,9],[11,10],[23,9],[2,19],[10,8],[15,11],[1,7],[15,4],[4,23],[25,12],[14,18],[25,17],[0,1],[25,10],[0,26],[14,6],[7,23],[6,22],[11,26],[19,22],[8,22],[12,2],[14,8],[7,18],[18,9],[2,6],[20,2],[16,1],[12,14],[24,25],[1,20],[16,25],[21,6],[13,12],[3,14],[24,13],[3,21]],
"numthickedges":30,
"face":[[16,25,24,15],[4,17,25,16],[25,10,11,24],[0,13,12,1],[13,26,5,12],[15,0,1,16],[16,1,20,4],[1,3,21,20],[3,7,23,21],[24,13,0,15],[11,26,13,24],[17,2,12,25],[6,9,18,14],[4,20,2,17],[20,21,6,2],[2,6,22,19],[21,23,9,6],[10,5,26,11],[19,22,8,5],[25,12,5,10],[12,14,3,1],[5,8,14,12],[14,18,7,3],[2,19,5,12],[14,8,22,6],[7,18,9,23]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-2,-3,-3,2,2,3,3,3,3,2,2,3,-3,-3,-3,-1,1,1]},

Hexa74 : {
"name":"hexa#74 (mirror of #73, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [1,1,1], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,1,1],[-0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,13],[22,21],[20,19],[5,22],[12,6],[10,6],[8,2],[16,0],[6,21],[5,18],[11,10],[13,20],[0,22],[18,7],[11,3],[16,11],[16,5],[25,12],[14,19],[19,2],[25,18],[13,4],[25,10],[14,7],[7,23],[20,3],[3,2],[21,23],[8,23],[14,8],[13,26],[1,12],[6,8],[26,6],[24,13],[12,14],[24,25],[17,25],[15,14],[9,8],[17,1],[15,9]],
"numthickedges":30,
"face":[[17,25,24,16],[5,18,25,17],[25,10,11,24],[0,13,12,1],[1,12,4,22],[16,0,1,17],[17,1,22,5],[24,13,0,16],[11,26,13,24],[26,9,15,13],[9,3,20,15],[18,4,12,25],[5,22,4,18],[4,7,23,21],[10,6,26,11],[6,8,9,26],[21,23,8,6],[8,2,3,9],[25,12,6,10],[14,19,2,8],[13,15,14,12],[12,14,7,4],[15,20,19,14],[4,21,6,12],[14,8,23,7],[20,3,2,19]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,2,3,3,2,2,2,2,3,3,-2,-2,-2,-1,1,1]},

Hexa75 : {
"name":"hexa#75 (mirror of #76, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[19,21],[1,6],[2,21],[15,0],[26,19],[5,17],[17,3],[7,9],[11,10],[3,19],[9,21],[15,11],[15,5],[5,22],[25,12],[14,18],[18,2],[25,17],[0,1],[1,4],[25,10],[0,26],[14,7],[22,7],[11,26],[10,2],[12,3],[4,14],[4,22],[18,9],[3,7],[20,3],[12,14],[24,25],[1,20],[16,1],[16,25],[7,23],[13,12],[14,8],[24,13],[8,23]],
"numthickedges":30,
"face":[[16,25,24,15],[5,17,25,16],[25,10,11,24],[0,13,12,1],[13,26,6,12],[15,0,1,16],[16,1,20,5],[1,4,22,20],[24,13,0,15],[11,26,13,24],[17,3,12,25],[5,20,3,17],[20,22,7,3],[3,7,23,19],[7,9,21,23],[10,6,26,11],[19,23,8,6],[23,21,2,8],[25,12,6,10],[4,14,7,22],[12,14,4,1],[6,8,14,12],[8,2,18,14],[3,19,6,12],[18,2,21,9],[14,18,9,7]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-3,-3,2,3,3,3,3,2,2,2,3,1,-3,-3,-3,-1,1,-2]},

Hexa76 : {
"name":"hexa#76 (mirror of #75, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,13],[21,20],[4,21],[20,22],[12,5],[10,5],[7,2],[2,22],[16,0],[5,20],[18,9],[4,18],[11,10],[0,21],[9,22],[16,11],[8,7],[15,14],[16,4],[13,15],[25,12],[14,19],[19,2],[25,18],[13,3],[25,10],[15,8],[11,8],[14,7],[19,9],[13,26],[1,12],[5,7],[26,5],[7,23],[14,6],[24,13],[12,14],[24,25],[17,25],[6,23],[17,1]],
"numthickedges":30,
"face":[[17,25,24,16],[4,18,25,17],[25,10,11,24],[0,13,12,1],[1,12,3,21],[16,0,1,17],[17,1,21,4],[24,13,0,16],[11,26,13,24],[26,8,15,13],[18,3,12,25],[4,21,3,18],[3,6,23,20],[6,9,22,23],[10,5,26,11],[5,7,8,26],[20,23,7,5],[23,22,2,7],[25,12,5,10],[15,8,7,14],[13,15,14,12],[12,14,6,3],[14,19,9,6],[3,20,5,12],[19,2,22,9],[7,2,19,14]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,2,3,3,3,2,2,2,2,3,1,-2,-2,-2,-1,1,-3]},

Hexa77 : {
"name":"hexa#77 (mirror of #78, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [2,0,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[1.5,-1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[17,0],[2,8],[1,5],[4,19],[12,11],[27,5],[2,6],[26,15],[24,10],[8,20],[16,20],[17,12],[19,10],[16,15],[17,4],[4,24],[8,24],[26,19],[0,1],[1,6],[26,11],[0,27],[2,16],[20,10],[12,27],[11,5],[6,15],[6,23],[15,21],[25,14],[15,7],[25,26],[1,22],[18,1],[6,9],[18,26],[14,3],[22,3],[23,7],[9,21]],
"numthickedges":27,
"face":[[18,26,25,17],[4,19,26,18],[26,11,12,25],[0,14,13,1],[14,27,5,13],[17,0,1,18],[18,1,22,4],[1,6,23,22],[2,8,9,6],[6,9,24,23],[25,14,0,17],[12,27,14,25],[16,20,8,2],[19,3,13,26],[3,7,15,13],[15,21,20,16],[7,10,21,15],[4,22,3,19],[22,23,7,3],[23,24,10,7],[11,5,27,12],[26,13,5,11],[13,15,6,1],[6,15,16,2],[8,20,21,9],[9,21,10,24]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-2,-2,-3,-3,-3,2,2,2,2,3,3,3,2,3,-3,-1,1,1]},

Hexa78 : {
"name":"hexa#78 (mirror of #77, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,0],[0.5,-1,0],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,16],[19,0],[4,9],[24,5],[9,3],[16,5],[6,24],[6,21],[14,13],[4,8],[26,17],[0,24],[21,5],[14,3],[19,14],[9,12],[18,17],[19,6],[16,18],[26,21],[26,13],[4,18],[12,2],[13,2],[8,12],[3,2],[8,17],[16,27],[17,23],[25,16],[18,22],[25,26],[20,26],[18,11],[20,1],[17,10],[22,23],[1,7],[27,7],[11,10]],
"numthickedges":27,
"face":[[20,26,25,19],[6,21,26,20],[26,13,14,25],[0,16,15,1],[1,15,5,24],[19,0,1,20],[20,1,24,6],[4,9,12,8],[25,16,0,19],[14,27,16,25],[27,11,18,16],[18,22,9,4],[11,3,22,18],[21,5,15,26],[6,24,5,21],[13,7,27,14],[7,10,11,27],[10,2,3,11],[26,15,7,13],[15,17,10,7],[8,12,23,17],[17,23,2,10],[16,18,17,15],[8,17,18,4],[9,22,23,12],[22,3,2,23]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-3,-3,-3,-3,-3,2,3,2,2,2,3,3,3,3,-2,-1,1,1]},

Hexa79 : {
"name":"hexa#79 (mirror of #80, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [2,0,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[1,6],[11,6],[9,2],[2,21],[16,0],[5,18],[12,11],[27,6],[26,15],[24,21],[18,7],[16,12],[1,8],[16,5],[5,24],[26,18],[0,1],[26,11],[0,27],[15,7],[8,2],[8,24],[7,23],[12,27],[23,21],[9,23],[15,9],[15,19],[7,10],[17,1],[25,26],[1,20],[17,26],[22,7],[4,15],[14,3],[20,3],[25,14],[4,22],[19,10]],
"numthickedges":27,
"face":[[17,26,25,16],[5,18,26,17],[26,11,12,25],[0,14,13,1],[14,27,6,13],[16,0,1,17],[17,1,20,5],[1,4,22,20],[4,8,24,22],[25,14,0,16],[12,27,14,25],[18,3,13,26],[3,7,15,13],[5,20,3,18],[20,22,7,3],[22,24,10,7],[7,10,21,23],[11,6,27,12],[23,21,2,9],[26,13,6,11],[13,15,4,1],[15,19,8,4],[9,2,19,15],[8,19,10,24],[19,2,21,10],[7,23,9,15]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-2,-3,-3,2,2,3,3,3,3,2,2,3,-3,-3,-3,1,1,-1]},

Hexa80 : {
"name":"hexa#80 (mirror of #79, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[-1.5,-1,1],[-0.5,1,-1],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-1.5,1,0],[-1.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[1.5,1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[0,14],[22,4],[14,4],[5,22],[17,0],[5,19],[19,4],[7,10],[12,11],[26,15],[14,21],[0,22],[12,3],[10,23],[17,12],[17,5],[26,19],[26,11],[11,8],[15,7],[21,10],[7,24],[21,3],[24,23],[8,24],[15,8],[3,23],[14,6],[15,20],[25,14],[25,26],[18,26],[8,2],[16,15],[9,8],[1,27],[6,27],[20,2],[18,1],[16,9]],
"numthickedges":27,
"face":[[18,26,25,17],[5,19,26,18],[26,11,12,25],[0,14,13,1],[1,13,4,22],[17,0,1,18],[18,1,22,5],[25,14,0,17],[12,6,14,25],[6,9,16,14],[9,3,21,16],[19,4,13,26],[5,22,4,19],[7,10,23,24],[11,27,6,12],[27,8,9,6],[8,2,3,9],[24,23,2,8],[26,13,27,11],[13,15,8,27],[14,16,15,13],[16,21,20,15],[15,20,10,7],[21,3,2,20],[20,2,23,10],[7,24,8,15]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,2,3,3,2,2,2,2,3,3,-2,-2,-2,1,1,-1]},

Hexa81 : {
"name":"hexa#81 (mirror of #82, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,0,1], [2,0,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[-1,1,0],[2,0,0],[0,0,1],[1,-1,0],[1,0,1],[-2,1,0],[-2,1,-1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[2,-1,1],[-1,-1,1],[0,-1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[18,23],[1,6],[16,0],[5,18],[12,11],[27,6],[5,20],[7,23],[16,12],[20,23],[16,5],[26,18],[0,1],[26,11],[0,27],[1,2],[12,27],[11,6],[26,7],[2,20],[2,7],[25,26],[1,21],[17,26],[17,1],[14,3],[21,3],[24,10],[25,14],[15,8],[22,8],[9,24],[9,19],[4,15],[4,22],[19,10]],
"numthickedges":21,
"face":[[17,26,25,16],[5,18,26,17],[26,11,12,25],[0,14,13,1],[14,27,6,13],[16,0,1,17],[17,1,21,5],[1,4,22,21],[4,9,24,22],[9,2,20,24],[25,14,0,16],[12,27,14,25],[18,3,13,26],[3,8,15,13],[8,10,19,15],[10,23,7,19],[5,21,3,18],[21,22,8,3],[22,24,10,8],[24,20,23,10],[11,6,27,12],[26,13,6,11],[13,15,4,1],[15,19,9,4],[19,7,2,9],[2,7,23,20]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-2,-2,-2,-3,-3,2,2,2,2,3,3,3,3,2,3,-3,-3,-3,1]},

Hexa82 : {
"name":"hexa#82 (mirror of #81, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[-1,0,1],[-2,-1,1],[-1,1,0],[2,0,0],[2,0,-1],[0,1,0],[0,1,-1],[-2,1,0],[-2,1,-1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[1,0,-1],[2,1,-1],[2,1,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[0,14],[24,4],[14,4],[5,24],[17,0],[5,19],[12,11],[0,24],[19,4],[17,12],[22,23],[17,5],[26,19],[26,11],[14,8],[11,23],[7,23],[8,7],[26,7],[12,22],[8,22],[14,27],[25,26],[18,26],[25,14],[21,20],[1,6],[27,6],[10,9],[16,15],[20,2],[18,1],[21,3],[3,2],[16,10],[15,9]],
"numthickedges":21,
"face":[[18,26,25,17],[5,19,26,18],[26,11,12,25],[0,14,13,1],[1,13,4,24],[17,0,1,18],[18,1,24,5],[25,14,0,17],[12,27,14,25],[27,10,16,14],[10,3,21,16],[3,22,8,21],[19,4,13,26],[5,24,4,19],[11,6,27,12],[6,9,10,27],[9,2,3,10],[2,23,22,3],[26,13,6,11],[13,15,9,6],[15,20,2,9],[20,7,23,2],[14,16,15,13],[16,21,20,15],[21,8,7,20],[8,22,23,7]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,2,2,2,2,3,3,3,3,-2,-2,-2,1]},

Hexa83 : {
"name":"hexa#83 (mirror of #84, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,20],[23,4],[12,4],[19,18],[5,23],[26,18],[9,6],[7,2],[15,0],[5,17],[10,9],[27,6],[12,19],[0,23],[20,22],[17,4],[6,21],[15,10],[8,7],[22,24],[8,22],[15,5],[7,24],[18,2],[26,17],[26,9],[10,27],[8,3],[19,3],[3,2],[20,21],[21,24],[12,27],[6,7],[25,12],[1,6],[14,8],[13,7],[25,26],[16,26],[27,8],[14,13],[16,1]],
"numthickedges":33,
"face":[[16,26,25,15],[5,17,26,16],[26,9,10,25],[0,12,11,1],[1,11,4,23],[15,0,1,16],[16,1,23,5],[25,12,0,15],[10,27,12,25],[27,8,14,12],[20,22,8,27],[8,3,19,14],[17,4,11,26],[5,23,4,17],[9,6,27,10],[7,2,3,8],[26,11,6,9],[11,13,7,6],[6,7,24,21],[13,18,2,7],[12,14,13,11],[14,19,18,13],[6,21,20,27],[8,22,24,7],[21,24,22,20],[19,3,2,18]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,2,2,3,3,3,3,-2,-2,-1,1,2,1]},

Hexa84 : {
"name":"hexa#84 (mirror of #83, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[0,13],[19,9],[22,4],[20,9],[13,4],[5,22],[26,18],[11,27],[7,3],[3,23],[15,0],[27,20],[4,8],[24,10],[0,22],[27,19],[8,23],[7,21],[15,5],[2,20],[24,23],[15,25],[18,3],[26,11],[25,13],[11,2],[5,2],[7,24],[21,10],[9,10],[25,26],[19,21],[18,8],[4,20],[27,7],[17,4],[6,24],[1,27],[14,7],[20,24],[16,26],[26,17],[14,6],[16,1]],
"numthickedges":33,
"face":[[16,26,25,15],[5,17,26,16],[17,2,11,26],[0,13,12,1],[1,12,4,22],[15,0,1,16],[16,1,22,5],[26,12,13,25],[25,13,0,15],[5,22,4,17],[17,4,20,2],[4,6,24,20],[20,24,10,9],[6,8,23,24],[2,20,27,11],[24,23,3,7],[11,27,12,26],[27,7,14,12],[19,21,7,27],[7,3,18,14],[12,14,6,4],[14,18,8,6],[20,9,19,27],[7,21,10,24],[9,10,21,19],[18,3,23,8]],
"facedirection":[-1,-1,-1,1,1,-2,-2,2,-3,3,3,3,3,3,2,2,-3,-3,-3,-3,-2,-2,-1,1,2,1]},

Hexa85 : {
"name":"hexa#85 (mirror of #86, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,18],[21,4],[12,4],[5,21],[9,6],[7,2],[15,0],[18,23],[5,17],[10,9],[27,6],[26,13],[19,24],[0,21],[3,23],[17,4],[6,19],[15,10],[2,24],[14,13],[8,7],[15,5],[12,14],[26,17],[26,9],[10,27],[8,3],[18,19],[3,2],[14,8],[13,7],[23,24],[12,27],[6,7],[1,6],[25,12],[25,26],[16,26],[27,8],[8,20],[7,22],[20,22],[16,1]],
"numthickedges":33,
"face":[[16,26,25,15],[5,17,26,16],[26,9,10,25],[0,12,11,1],[1,11,4,21],[15,0,1,16],[16,1,21,5],[25,12,0,15],[10,27,12,25],[27,8,14,12],[18,20,8,27],[20,23,3,8],[17,4,11,26],[5,21,4,17],[9,6,27,10],[26,11,6,9],[11,13,7,6],[6,7,22,19],[7,2,24,22],[14,8,7,13],[12,14,13,11],[6,19,18,27],[19,22,20,18],[22,24,23,20],[3,23,24,2],[8,3,2,7]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,2,3,3,3,3,1,-2,-1,2,2,1,-2]},

Hexa86 : {
"name":"hexa#86 (mirror of #85, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [1,1,1], [1,2,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-0.5,1],[0.5,0.5,0],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[0,13],[18,8],[21,4],[19,8],[13,4],[5,21],[10,27],[7,3],[3,22],[15,0],[27,19],[26,14],[18,23],[0,21],[27,18],[3,23],[15,5],[2,19],[24,22],[8,11],[15,25],[26,10],[25,13],[4,6],[22,11],[10,2],[23,11],[14,6],[6,24],[5,2],[7,24],[14,7],[25,26],[4,19],[27,7],[1,27],[19,24],[16,26],[17,4],[24,9],[7,20],[26,17],[16,1],[20,9]],
"numthickedges":33,
"face":[[16,26,25,15],[5,17,26,16],[17,2,10,26],[0,13,12,1],[1,12,4,21],[15,0,1,16],[16,1,21,5],[26,12,13,25],[25,13,0,15],[5,21,4,17],[17,4,19,2],[4,6,24,19],[19,24,9,8],[24,22,11,9],[2,19,27,10],[10,27,12,26],[27,7,14,12],[18,20,7,27],[20,23,3,7],[14,7,24,6],[12,14,6,4],[19,8,18,27],[8,9,20,18],[9,11,23,20],[3,23,11,22],[7,3,22,24]],
"facedirection":[-1,-1,-1,1,1,-2,-2,2,-3,3,3,3,3,3,2,-3,-3,-3,-3,1,-2,-1,2,2,1,-2]},

Hexa87 : {
"name":"hexa#87 (mirror of #88, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,0], [1,1,0], [2,1,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-1.5,-1.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[21,4],[12,4],[19,23],[5,21],[19,18],[26,18],[15,0],[5,17],[10,9],[12,19],[20,23],[0,21],[17,4],[15,10],[8,7],[20,22],[8,20],[15,5],[7,22],[26,17],[26,9],[9,7],[18,24],[22,24],[10,8],[23,24],[12,27],[25,12],[14,8],[13,7],[25,26],[16,26],[7,2],[8,3],[1,6],[27,6],[14,13],[16,1],[3,2]],
"numthickedges":27,
"face":[[16,26,25,15],[5,17,26,16],[26,9,10,25],[0,12,11,1],[1,11,4,21],[15,0,1,16],[16,1,21,5],[25,12,0,15],[10,27,12,25],[27,8,14,12],[8,3,19,14],[20,23,3,8],[17,4,11,26],[5,21,4,17],[9,6,27,10],[6,7,8,27],[26,11,6,9],[11,13,7,6],[13,18,2,7],[7,2,24,22],[12,14,13,11],[14,19,18,13],[19,3,2,18],[3,23,24,2],[7,22,20,8],[22,24,23,20]],
"facedirection":[-1,-1,-1,1,1,-2,-2,-3,-3,-3,-3,-3,2,3,2,2,3,3,3,3,-2,-2,1,1,-1,2]},

Hexa88 : {
"name":"hexa#88 (mirror of #87, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [0,1,1], [1,1,1], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-1.5,-1.5,1],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[0.5,1.5,1],[-1.5,0.5,0],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[0,13],[21,4],[13,4],[5,21],[26,18],[15,0],[4,8],[24,9],[0,21],[8,11],[7,20],[15,5],[2,24],[15,25],[26,10],[25,13],[10,2],[10,7],[23,11],[18,23],[9,11],[5,2],[20,23],[7,24],[20,9],[25,26],[18,8],[4,19],[17,4],[6,24],[14,7],[24,22],[16,26],[7,3],[26,17],[1,27],[3,22],[27,19],[14,6],[16,1]],
"numthickedges":27,
"face":[[16,26,25,15],[5,17,26,16],[17,2,10,26],[0,13,12,1],[1,12,4,21],[15,0,1,16],[16,1,21,5],[26,12,13,25],[25,13,0,15],[5,21,4,17],[17,4,19,2],[4,6,24,19],[6,8,22,24],[24,22,11,9],[2,19,27,10],[19,24,7,27],[10,27,12,26],[27,7,14,12],[7,3,18,14],[20,23,3,7],[12,14,6,4],[14,18,8,6],[18,3,22,8],[3,23,11,22],[24,9,20,7],[9,11,23,20]],
"facedirection":[-1,-1,-1,1,1,-2,-2,2,-3,3,3,3,3,3,2,2,-3,-3,-3,-3,-2,-2,1,1,-1,2]},

Hexa89 : {
"name":"hexa#89 (mirror of #90, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,0], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[16,8],[13,12],[19,20],[12,6],[4,18],[25,6],[13,25],[8,19],[12,20],[18,7],[23,13],[15,19],[6,9],[8,11],[15,7],[10,9],[16,4],[4,22],[16,23],[25,10],[22,7],[5,11],[23,18],[15,10],[5,9],[5,22],[11,20],[12,3],[1,12],[0,13],[24,12],[13,15],[17,5],[2,15],[2,5],[21,3],[0,21],[17,24]],
"numthickedges":27,
"face":[[17,24,23,16],[4,18,24,17],[16,0,1,17],[17,1,21,4],[0,2,5,1],[1,5,22,21],[2,8,11,5],[24,12,13,23],[18,3,12,24],[3,7,14,12],[14,20,19,15],[23,13,0,16],[13,15,2,0],[25,10,15,13],[15,19,8,2],[4,21,3,18],[21,22,7,3],[5,14,7,22],[15,10,9,14],[12,6,25,13],[6,9,10,25],[12,14,9,6],[5,11,20,14],[8,19,20,11]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,3,3,1,1,-1,2,3,3,1]},

Hexa90 : {
"name":"hexa#90 (mirror of #89, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[10,25],[25,18],[4,16],[16,2],[6,9],[3,5],[22,9],[2,18],[10,17],[25,8],[13,6],[14,3],[14,4],[4,22],[14,23],[3,13],[7,22],[6,21],[23,13],[5,7],[23,16],[18,21],[8,21],[10,2],[5,8],[7,17],[17,9],[1,10],[2,6],[5,20],[19,2],[24,10],[20,6],[15,5],[11,10],[0,11],[0,19],[15,24]],
"numthickedges":27,
"face":[[15,24,23,14],[4,16,24,15],[14,0,1,15],[15,1,19,4],[0,3,5,1],[1,5,20,19],[5,7,22,20],[24,10,11,23],[16,2,10,24],[10,12,13,11],[6,9,17,12],[23,11,0,14],[11,13,3,0],[4,19,2,16],[19,20,6,2],[2,6,21,18],[20,22,9,6],[3,13,12,5],[12,8,21,6],[2,18,25,10],[18,21,8,25],[25,8,12,10],[12,17,7,5],[7,17,9,22]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,3,3,3,3,1,1,-1,2,-3,-3,1]},

Hexa91 : {
"name":"hexa#91 (mirror of #92, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,0], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[13,12],[12,6],[4,18],[3,5],[25,6],[5,9],[13,25],[12,19],[22,11],[6,9],[18,11],[10,9],[16,3],[16,4],[4,22],[16,23],[23,13],[25,10],[8,22],[8,19],[5,8],[23,18],[3,10],[19,11],[12,2],[1,12],[5,21],[0,13],[24,12],[13,15],[17,5],[20,2],[15,7],[0,20],[17,24],[21,7]],
"numthickedges":24,
"face":[[17,24,23,16],[4,18,24,17],[16,0,1,17],[17,1,20,4],[0,3,5,1],[1,5,21,20],[5,8,22,21],[24,12,13,23],[18,2,12,24],[2,7,14,12],[7,11,19,14],[23,13,0,16],[13,15,3,0],[25,10,15,13],[4,20,2,18],[20,21,7,2],[21,22,11,7],[3,15,14,5],[15,10,9,14],[12,6,25,13],[6,9,10,25],[12,14,9,6],[8,19,11,22],[14,19,8,5]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,3,3,3,1,1,-1,2,3,1,-3]},

Hexa92 : {
"name":"hexa#92 (mirror of #91, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[1.5,-1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[14,7],[17,18],[10,25],[25,19],[4,16],[5,8],[10,18],[7,17],[3,19],[16,3],[25,8],[7,9],[14,4],[23,17],[4,21],[14,23],[21,22],[5,9],[23,16],[19,22],[8,22],[10,3],[5,21],[9,18],[1,10],[24,10],[20,3],[3,6],[15,5],[11,10],[2,5],[0,11],[13,6],[0,20],[15,24],[2,13]],
"numthickedges":24,
"face":[[15,24,23,14],[4,16,24,15],[14,0,1,15],[15,1,20,4],[0,2,5,1],[1,5,21,20],[2,7,9,5],[24,10,11,23],[16,3,10,24],[10,12,13,11],[12,18,17,13],[23,11,0,14],[11,13,2,0],[13,17,7,2],[4,20,3,16],[20,21,6,3],[3,6,22,19],[5,12,6,21],[12,8,22,6],[3,19,25,10],[19,22,8,25],[25,8,12,10],[7,17,18,9],[5,9,18,12]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,3,3,3,1,1,-1,2,-3,1,3]},

Hexa93 : {
"name":"hexa#93 (mirror of #94, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[13,12],[20,19],[12,8],[6,18],[25,8],[13,25],[12,19],[18,9],[23,13],[15,20],[15,9],[16,5],[16,6],[6,22],[16,23],[19,2],[5,15],[22,9],[25,3],[20,3],[3,2],[23,18],[8,2],[5,22],[12,4],[1,12],[0,13],[24,12],[13,15],[15,11],[21,4],[11,10],[0,21],[17,24],[17,7],[7,10]],
"numthickedges":24,
"face":[[17,24,23,16],[6,18,24,17],[16,0,1,17],[17,1,21,6],[0,5,7,1],[1,7,22,21],[24,12,13,23],[18,4,12,24],[4,9,14,12],[23,13,0,16],[13,15,5,0],[25,11,15,13],[11,3,20,15],[6,21,4,18],[21,22,9,4],[5,15,14,7],[7,14,9,22],[12,8,25,13],[8,10,11,25],[10,2,3,11],[12,14,10,8],[14,19,2,10],[20,3,2,19],[15,20,19,14]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,3,3,1,1,-1,2,2,3,3,1,-2]},

Hexa94 : {
"name":"hexa#94 (mirror of #93, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[0.5,0,1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[18,20],[10,25],[2,20],[25,18],[5,16],[16,3],[7,9],[10,17],[3,18],[9,20],[13,7],[14,4],[14,5],[5,21],[14,23],[17,2],[4,13],[21,7],[23,13],[23,16],[25,2],[4,21],[10,3],[17,9],[1,10],[3,7],[24,10],[19,3],[7,22],[11,10],[0,11],[0,19],[15,24],[15,6],[8,22],[6,8]],
"numthickedges":24,
"face":[[15,24,23,14],[5,16,24,15],[14,0,1,15],[15,1,19,5],[0,4,6,1],[1,6,21,19],[24,10,11,23],[16,3,10,24],[10,12,13,11],[23,11,0,14],[11,13,4,0],[5,19,3,16],[19,21,7,3],[3,7,22,18],[7,9,20,22],[4,13,12,6],[6,12,7,21],[3,18,25,10],[18,22,8,25],[22,20,2,8],[25,8,12,10],[8,2,17,12],[17,2,20,9],[12,17,9,7]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,3,3,3,3,1,1,-1,2,2,-3,-3,1,-2]},

Hexa95 : {
"name":"hexa#95 (mirror of #96, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [2,0,0], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[1.5,-1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,-1,1],[0.5,-1,1],[-1.5,0,-1],[-1.5,0,0]],
"edge":[[17,9],[9,3],[10,2],[6,19],[7,10],[19,8],[9,11],[15,8],[12,10],[17,6],[6,23],[17,24],[23,8],[11,2],[24,15],[12,3],[7,11],[3,2],[24,19],[15,12],[7,23],[15,20],[18,7],[4,15],[4,7],[0,14],[14,5],[22,5],[20,21],[25,21],[0,22],[18,25],[1,13]],
"numthickedges":21,
"face":[[18,25,24,17],[6,19,25,18],[17,0,1,18],[18,1,22,6],[0,4,7,1],[1,7,23,22],[4,9,11,7],[25,13,14,24],[19,5,13,25],[13,16,15,14],[5,8,16,13],[24,14,0,17],[14,15,4,0],[15,20,9,4],[12,3,20,15],[6,22,5,19],[22,23,8,5],[7,16,8,23],[9,20,21,11],[20,3,2,21],[7,11,21,16],[16,21,2,10],[16,10,12,15],[10,2,3,12]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,3,3,1,1,1,3,3,-1,2]},

Hexa96 : {
"name":"hexa#96 (mirror of #95, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,0,1], [2,0,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0]],
"edge":[[2,20],[9,2],[5,17],[4,6],[6,9],[23,20],[17,7],[14,7],[15,4],[15,5],[5,23],[15,24],[4,14],[8,2],[8,23],[7,22],[24,14],[6,8],[24,17],[22,20],[9,22],[6,21],[7,10],[21,7],[16,6],[0,12],[12,3],[19,3],[25,18],[0,19],[16,25],[1,11],[18,10]],
"numthickedges":21,
"face":[[16,25,24,15],[5,17,25,16],[15,0,1,16],[16,1,19,5],[0,4,6,1],[1,6,21,19],[6,8,23,21],[25,11,12,24],[17,3,11,25],[11,13,14,12],[3,7,13,11],[24,12,0,15],[12,14,4,0],[5,19,3,17],[19,21,7,3],[21,23,10,7],[7,10,20,22],[4,14,13,6],[8,18,10,23],[18,2,20,10],[13,18,8,6],[9,2,18,13],[7,22,9,13],[22,20,2,9]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,3,3,3,3,1,1,1,-3,-3,-1,2]},

Hexa97 : {
"name":"hexa#97 (mirror of #98, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [1,1,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[0.5,-1,-1],[-0.5,0,1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[0.5,1,-1],[1.5,-1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[16,8],[19,20],[22,21],[26,21],[4,22],[4,18],[13,26],[12,20],[8,19],[18,7],[24,13],[15,19],[1,11],[8,11],[15,7],[16,4],[1,22],[16,24],[1,12],[13,3],[26,10],[10,23],[7,23],[24,18],[21,23],[15,10],[11,20],[0,13],[25,12],[13,15],[17,1],[0,1],[12,6],[2,15],[2,5],[6,9],[17,25],[5,9]],
"numthickedges":27,
"face":[[17,25,24,16],[4,18,25,17],[16,0,1,17],[17,1,22,4],[0,2,5,1],[2,8,11,5],[25,12,13,24],[18,3,12,25],[14,20,19,15],[24,13,0,16],[13,15,2,0],[26,10,15,13],[15,19,8,2],[1,12,3,22],[4,22,3,18],[3,7,23,21],[1,5,14,12],[5,11,20,14],[12,6,26,13],[3,21,6,12],[15,10,9,14],[14,9,23,7],[6,9,10,26],[21,23,9,6],[12,14,7,3],[8,19,20,11]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,1,3,3,3,3,-1,-1,1,1,2,2,-2,1]},

Hexa98 : {
"name":"hexa#98 (mirror of #97, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,0], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,-1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,26],[12,2],[26,19],[15,0],[4,17],[17,2],[6,10],[23,10],[11,18],[2,19],[1,7],[14,6],[15,4],[4,23],[15,24],[24,14],[1,11],[0,1],[26,8],[8,22],[7,23],[6,22],[24,17],[19,22],[14,8],[7,18],[18,10],[2,6],[25,11],[20,2],[16,1],[11,5],[1,20],[21,6],[5,9],[16,25],[3,9],[3,21]],
"numthickedges":27,
"face":[[16,25,24,15],[4,17,25,16],[0,12,11,1],[15,0,1,16],[16,1,20,4],[1,3,21,20],[3,7,23,21],[25,11,12,24],[17,2,11,25],[6,10,18,13],[24,12,0,15],[26,8,14,12],[4,20,2,17],[20,21,6,2],[2,6,22,19],[21,23,10,6],[11,13,3,1],[13,18,7,3],[11,5,26,12],[2,19,5,11],[14,8,9,13],[13,9,22,6],[12,14,13,11],[5,9,8,26],[19,22,9,5],[7,18,10,23]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,2,2,2,-3,-3,3,3,3,3,-3,-3,-1,-1,1,1,-2,2,2,1]},

Hexa99 : {
"name":"hexa#99 (mirror of #100, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [1,1,1], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,1,1],[-0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[22,21],[20,19],[26,21],[6,22],[10,2],[6,18],[5,7],[13,26],[18,9],[24,13],[15,20],[12,19],[15,9],[16,5],[16,6],[1,22],[16,24],[19,2],[1,12],[1,7],[13,4],[5,15],[9,23],[26,3],[20,3],[3,2],[24,18],[21,23],[10,23],[7,10],[8,10],[0,13],[13,15],[25,12],[0,1],[12,8],[17,1],[15,11],[11,10],[17,25]],
"numthickedges":30,
"face":[[17,25,24,16],[6,18,25,17],[16,0,1,17],[17,1,22,6],[0,5,7,1],[25,12,13,24],[18,4,12,25],[24,13,0,16],[13,15,5,0],[26,11,15,13],[11,3,20,15],[1,12,4,22],[6,22,4,18],[4,9,23,21],[5,15,14,7],[14,10,23,9],[1,7,14,12],[14,19,2,10],[12,8,26,13],[4,21,8,12],[8,10,11,26],[21,23,10,8],[10,2,3,11],[12,14,9,4],[15,20,19,14],[20,3,2,19]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,-3,-3,1,3,3,1,1,3,3,-1,-1,2,2,2,-2,-2,1]},

Hexa100 : {
"name":"hexa#100 (mirror of #99, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,26],[12,3],[26,19],[19,21],[8,2],[2,21],[15,0],[5,17],[17,3],[7,10],[3,19],[11,18],[10,21],[14,7],[9,8],[15,5],[5,22],[24,14],[15,24],[18,2],[1,11],[0,1],[1,4],[26,9],[22,7],[24,17],[14,9],[4,8],[4,22],[18,10],[6,8],[3,7],[20,3],[25,11],[8,23],[11,6],[1,20],[16,1],[7,23],[16,25]],
"numthickedges":30,
"face":[[16,25,24,15],[5,17,25,16],[0,12,11,1],[15,0,1,16],[16,1,20,5],[1,4,22,20],[25,11,12,24],[17,3,11,25],[24,12,0,15],[26,9,14,12],[5,20,3,17],[20,22,7,3],[3,7,23,19],[7,10,21,23],[4,13,7,22],[14,9,8,13],[11,13,4,1],[8,2,18,13],[11,6,26,12],[3,19,6,11],[12,14,13,11],[13,18,10,7],[6,8,9,26],[19,23,8,6],[23,21,2,8],[18,2,21,10]],
"facedirection":[-1,-1,1,-2,-2,-2,2,2,-3,-3,3,3,3,3,1,1,-3,-3,-1,-1,-2,-2,2,2,2,1]},

Hexa101 : {
"name":"hexa#101 (mirror of #102, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[21,20],[26,20],[5,21],[20,22],[9,2],[2,22],[18,11],[5,18],[4,6],[6,9],[13,26],[12,19],[11,22],[10,9],[16,4],[16,5],[1,21],[16,24],[19,2],[1,12],[1,6],[13,3],[24,13],[26,10],[24,18],[4,10],[19,11],[7,9],[0,13],[25,12],[9,23],[0,1],[12,7],[17,1],[13,15],[15,8],[17,25],[8,23]],
"numthickedges":27,
"face":[[17,25,24,16],[5,18,25,17],[16,0,1,17],[17,1,21,5],[0,4,6,1],[25,12,13,24],[18,3,12,25],[24,13,0,16],[13,15,4,0],[26,10,15,13],[1,12,3,21],[5,21,3,18],[3,8,23,20],[8,11,22,23],[4,15,14,6],[15,10,9,14],[1,6,14,12],[12,7,26,13],[3,20,7,12],[7,9,10,26],[20,23,9,7],[23,22,2,9],[12,14,8,3],[14,19,11,8],[19,2,22,11],[9,2,19,14]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,-3,1,3,3,3,1,1,3,-1,-1,2,2,2,-2,-2,1,-3]},

Hexa102 : {
"name":"hexa#102 (mirror of #101, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,0], [1,1,1], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[-0.5,1,0],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[0,26],[12,4],[19,18],[26,20],[9,2],[15,0],[6,17],[5,9],[24,19],[11,18],[4,20],[17,4],[15,6],[6,22],[15,24],[18,2],[1,11],[0,1],[1,5],[26,3],[19,3],[22,23],[3,2],[24,17],[20,23],[9,23],[5,22],[7,9],[25,11],[21,4],[4,8],[11,7],[1,21],[16,1],[10,9],[13,8],[16,25],[13,10]],
"numthickedges":27,
"face":[[16,25,24,15],[6,17,25,16],[0,12,11,1],[15,0,1,16],[16,1,21,6],[1,5,22,21],[25,11,12,24],[17,4,11,25],[24,12,0,15],[26,10,13,12],[10,3,19,13],[6,21,4,17],[21,22,8,4],[4,8,23,20],[5,14,8,22],[14,9,23,8],[11,14,5,1],[11,7,26,12],[4,20,7,11],[12,13,14,11],[13,19,18,14],[7,9,10,26],[20,23,9,7],[9,2,3,10],[19,3,2,18],[14,18,2,9]],
"facedirection":[-1,-1,1,-2,-2,-2,2,2,-3,-3,-3,3,3,3,1,1,-3,-1,-1,-2,-2,2,2,2,1,3]},

Hexa103 : {
"name":"hexa#103 (mirror of #104, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[-1,0,1],[-2,-1,1],[0,-1,0],[-1,1,-1],[2,0,0],[-1,1,0],[1,-1,-1],[0,1,0],[0,1,-1],[1,-1,0],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,-1],[1,0,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[24,4],[16,4],[5,24],[1,9],[5,21],[7,9],[17,8],[16,7],[21,4],[9,11],[18,17],[12,11],[25,16],[18,14],[19,5],[1,24],[19,25],[7,12],[2,8],[27,2],[1,2],[14,8],[25,21],[18,12],[17,11],[27,14],[26,17],[0,16],[16,18],[0,1],[20,1],[3,18],[6,17],[22,23],[3,6],[10,22],[10,13],[20,26],[13,23]],
"numthickedges":27,
"face":[[20,26,25,19],[5,21,26,20],[19,0,1,20],[20,1,24,5],[0,3,6,1],[3,10,13,6],[10,27,2,13],[26,15,16,25],[21,4,15,26],[17,23,22,18],[23,8,14,22],[25,16,0,19],[16,18,3,0],[7,12,18,16],[18,22,10,3],[22,14,27,10],[1,15,4,24],[5,24,4,21],[1,6,17,15],[15,17,11,9],[6,13,23,17],[13,2,8,23],[15,9,7,16],[18,12,11,17],[9,11,12,7],[27,14,8,2]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,1,3,3,3,3,3,-1,1,2,1]},

Hexa104 : {
"name":"hexa#104 (mirror of #103, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,1], [2,0,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[2,-1,1],[-1,1,1],[-1,-1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,0]],
"edge":[[0,12],[12,3],[1,27],[14,0],[27,19],[5,16],[13,6],[5,18],[6,23],[3,19],[16,3],[7,23],[27,9],[14,5],[18,23],[14,25],[0,1],[25,12],[13,7],[1,2],[7,22],[25,16],[19,22],[9,22],[13,9],[2,18],[2,6],[26,13],[20,3],[3,7],[1,20],[15,1],[21,7],[4,13],[24,10],[15,26],[8,24],[8,17],[4,21],[17,10]],
"numthickedges":27,
"face":[[15,26,25,14],[5,16,26,15],[0,12,11,1],[14,0,1,15],[15,1,20,5],[1,4,21,20],[4,8,24,21],[8,2,18,24],[26,11,12,25],[16,3,11,26],[7,10,17,13],[10,23,6,17],[25,12,0,14],[5,20,3,16],[20,21,7,3],[3,7,22,19],[21,24,10,7],[24,18,23,10],[11,13,4,1],[27,9,13,11],[13,17,8,4],[17,6,2,8],[3,19,27,11],[13,9,22,7],[19,22,9,27],[2,6,23,18]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,-2,2,2,2,2,-3,3,3,3,3,3,-3,-3,-3,-3,-1,1,2,1]},

Hexa105 : {
"name":"hexa#105 (mirror of #106, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[-1.5,-1,1],[0.5,-1,0],[-0.5,1,-1],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,-1,1],[1.5,1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[22,4],[14,4],[6,22],[1,27],[6,19],[19,4],[9,12],[5,7],[8,27],[7,10],[14,8],[25,14],[16,21],[27,10],[12,23],[16,9],[17,5],[17,6],[1,22],[17,25],[1,7],[5,16],[21,12],[9,24],[8,3],[21,3],[25,19],[24,23],[10,24],[3,23],[0,14],[14,16],[10,2],[0,1],[18,1],[16,11],[11,10],[26,20],[18,26],[20,2]],
"numthickedges":30,
"face":[[18,26,25,17],[6,19,26,18],[17,0,1,18],[18,1,22,6],[0,5,7,1],[26,13,14,25],[19,4,13,26],[25,14,0,17],[14,16,5,0],[8,11,16,14],[11,3,21,16],[1,13,4,22],[6,22,4,19],[9,12,23,24],[5,16,15,7],[1,7,15,13],[13,15,10,27],[13,27,8,14],[27,10,11,8],[10,2,3,11],[24,23,2,10],[21,3,2,20],[20,2,23,12],[16,21,20,15],[15,20,12,9],[9,24,10,15]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,-3,-3,1,3,3,1,3,3,-1,2,2,2,1,1,-2,-2,-1]},

Hexa106 : {
"name":"hexa#106 (mirror of #105, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,1], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,0],[-1.5,-1,1],[0.5,0,1],[0.5,1,0],[0.5,1,-1],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[1.5,0,-1],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[0,12],[12,4],[20,22],[1,27],[15,0],[27,20],[6,17],[17,4],[7,10],[5,8],[4,20],[25,12],[14,19],[27,8],[10,22],[9,8],[14,7],[15,6],[6,23],[15,25],[0,1],[1,5],[23,7],[19,10],[9,3],[19,3],[25,17],[14,9],[3,22],[5,23],[4,7],[21,4],[8,2],[8,24],[1,21],[16,1],[7,24],[26,18],[16,26],[18,2]],
"numthickedges":30,
"face":[[16,26,25,15],[6,17,26,16],[0,12,11,1],[15,0,1,16],[16,1,21,6],[1,5,23,21],[26,11,12,25],[17,4,11,26],[25,12,0,15],[9,3,19,14],[6,21,4,17],[21,23,7,4],[4,7,24,20],[7,10,22,24],[5,13,7,23],[11,13,5,1],[27,8,13,11],[4,20,27,11],[20,24,8,27],[8,2,3,9],[24,22,2,8],[13,8,9,14],[19,3,2,18],[18,2,22,10],[14,19,18,13],[13,18,10,7]],
"facedirection":[-1,-1,1,-2,-2,-2,2,2,-3,-3,3,3,3,3,1,-3,-3,-1,2,2,2,-1,1,1,-2,-2]},

Hexa107 : {
"name":"hexa#107 (mirror of #108, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [1,1,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[-1,0,1],[0,-1,-1],[-2,-1,1],[0,-1,0],[-1,1,0],[2,0,0],[2,0,-1],[0,1,0],[0,1,-1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[1,0,-1],[2,1,-1],[2,1,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[8,23],[24,4],[14,4],[6,24],[1,8],[6,19],[5,7],[27,8],[15,9],[14,27],[27,22],[19,4],[16,15],[22,23],[17,5],[25,14],[16,10],[17,6],[1,24],[17,25],[1,7],[9,23],[5,16],[10,9],[25,19],[10,22],[7,15],[26,15],[0,14],[14,16],[0,1],[18,1],[16,12],[15,11],[21,20],[12,11],[18,26],[20,2],[21,3],[3,2]],
"numthickedges":27,
"face":[[18,26,25,17],[6,19,26,18],[17,0,1,18],[18,1,24,6],[0,5,7,1],[26,13,14,25],[19,4,13,26],[25,14,0,17],[14,16,5,0],[27,12,16,14],[12,3,21,16],[3,22,10,21],[1,13,4,24],[6,24,4,19],[5,16,15,7],[1,7,15,13],[13,15,11,8],[15,20,2,11],[20,9,23,2],[13,8,27,14],[8,11,12,27],[11,2,3,12],[2,23,22,3],[16,21,20,15],[21,10,9,20],[10,22,23,9]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,1,3,1,3,3,3,3,-1,2,2,2,-2,-2,1]},

Hexa108 : {
"name":"hexa#108 (mirror of #107, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [1,1,1], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[2,0,0],[0,0,1],[0,1,0],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[-1,1,1],[2,1,0],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[-2,0,-1],[-2,0,0],[-1,1,0]],
"edge":[[0,12],[27,19],[12,3],[1,27],[14,0],[27,18],[5,16],[13,6],[6,24],[3,18],[16,3],[7,24],[24,10],[14,5],[5,22],[14,25],[0,1],[1,4],[25,12],[6,19],[13,7],[22,7],[18,10],[25,16],[19,10],[4,13],[4,22],[26,13],[20,3],[3,7],[1,20],[15,1],[7,23],[13,8],[2,21],[9,21],[15,26],[17,2],[8,23],[17,9]],
"numthickedges":27,
"face":[[15,26,25,14],[5,16,26,15],[0,12,11,1],[14,0,1,15],[15,1,20,5],[1,4,22,20],[26,11,12,25],[16,3,11,26],[25,12,0,14],[5,20,3,16],[20,22,7,3],[3,7,23,18],[7,9,21,23],[9,24,10,21],[4,13,7,22],[11,13,4,1],[27,8,13,11],[8,2,17,13],[2,19,6,17],[3,18,27,11],[18,23,8,27],[23,21,2,8],[21,10,19,2],[13,17,9,7],[17,6,24,9],[6,19,10,24]],
"facedirection":[-1,-1,1,-2,-2,-2,2,2,-3,3,3,3,3,3,1,-3,-3,-3,-3,-1,2,2,2,-2,-2,1]},

Hexa109 : {
"name":"hexa#109 (mirror of #110, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [2,0,0], [2,1,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[-1,0,1],[-2,-1,1],[0,-1,0],[2,0,0],[2,0,-1],[1,-1,-1],[0,1,0],[1,-1,0],[0,1,-1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,-1],[1,0,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[22,23],[24,6],[7,24],[12,3],[7,21],[15,17],[23,9],[21,6],[18,17],[14,12],[19,7],[1,24],[19,25],[23,3],[1,15],[2,9],[27,2],[1,2],[10,9],[25,18],[22,10],[14,4],[22,4],[4,3],[25,21],[15,6],[18,14],[17,12],[27,10],[26,15],[17,23],[0,1],[13,23],[20,1],[18,22],[11,22],[16,15],[5,18],[8,17],[0,16],[5,8],[11,13],[20,26]],
"numthickedges":30,
"face":[[20,26,25,19],[7,21,26,20],[19,0,1,20],[20,1,24,7],[0,5,8,1],[5,11,13,8],[11,27,2,13],[26,15,16,25],[21,6,15,26],[15,17,18,16],[23,9,10,22],[25,16,0,19],[16,18,5,0],[18,22,11,5],[14,4,22,18],[22,10,27,11],[1,15,6,24],[7,24,6,21],[1,8,17,15],[8,13,23,17],[17,23,3,12],[13,2,9,23],[17,12,14,18],[22,4,3,23],[12,3,4,14],[27,10,9,2]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,1,3,3,3,3,3,-1,1,2,1]},

Hexa110 : {
"name":"hexa#110 (mirror of #109, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [2,0,1], [2,1,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[2,-1,1],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,0]],
"edge":[[0,12],[12,11],[9,2],[2,20],[14,0],[5,16],[5,18],[6,23],[11,13],[17,6],[16,7],[10,23],[10,20],[14,5],[18,23],[14,25],[17,2],[1,11],[0,1],[25,12],[27,6],[13,7],[1,27],[7,22],[25,16],[22,20],[9,22],[13,9],[27,18],[17,10],[11,3],[26,11],[13,17],[7,10],[24,10],[8,17],[1,19],[15,1],[21,7],[4,13],[19,3],[15,26],[8,24],[4,21]],
"numthickedges":30,
"face":[[15,26,25,14],[5,16,26,15],[0,12,11,1],[14,0,1,15],[15,1,19,5],[1,4,21,19],[4,8,24,21],[8,27,18,24],[26,11,12,25],[16,3,11,26],[3,7,13,11],[10,23,6,17],[25,12,0,14],[5,19,3,16],[19,21,7,3],[21,24,10,7],[7,10,20,22],[24,18,23,10],[11,13,4,1],[13,17,8,4],[9,2,17,13],[17,6,27,8],[7,22,9,13],[17,2,20,10],[22,20,2,9],[27,6,23,18]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,-2,2,2,2,2,-3,3,3,3,3,3,-3,-3,-3,-3,-1,1,2,1]},

Hexa111 : {
"name":"hexa#111 (mirror of #112, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [2,0,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[-1,0,1],[-2,-1,1],[0,-1,0],[2,0,0],[2,0,-1],[1,-1,-1],[0,1,0],[1,-1,0],[0,1,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,-1],[1,0,0],[2,1,-1],[2,1,0],[-1,-1,1],[-2,0,-1],[-2,0,0]],
"edge":[[18,10],[25,5],[21,22],[6,25],[6,20],[13,23],[11,24],[10,21],[14,17],[22,8],[20,5],[1,12],[10,12],[16,17],[13,11],[23,24],[18,6],[1,25],[18,26],[1,14],[8,24],[9,8],[26,16],[21,9],[26,20],[9,23],[14,5],[16,13],[17,11],[12,22],[21,3],[27,14],[17,22],[19,1],[0,1],[16,21],[15,14],[4,16],[7,17],[22,2],[0,15],[4,7],[19,27],[3,2]],
"numthickedges":30,
"face":[[19,27,26,18],[6,20,27,19],[18,0,1,19],[19,1,25,6],[0,4,7,1],[4,10,12,7],[27,14,15,26],[20,5,14,27],[14,17,16,15],[26,15,0,18],[15,16,4,0],[16,21,10,4],[13,3,21,16],[3,23,9,21],[1,14,5,25],[6,25,5,20],[1,7,17,14],[7,12,22,17],[17,22,2,11],[22,8,24,2],[10,21,22,12],[17,11,13,16],[11,2,3,13],[2,24,23,3],[9,23,24,8],[21,9,8,22]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,1,3,3,3,3,3,1,-1,2,2,1,-2]},

Hexa112 : {
"name":"hexa#112 (mirror of #111, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [2,0,1], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[2,1,0],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0]],
"edge":[[0,13],[13,12],[23,11],[15,0],[5,17],[25,10],[9,19],[6,24],[12,14],[18,6],[17,7],[10,24],[24,11],[1,8],[15,5],[5,25],[15,26],[1,12],[0,1],[26,13],[6,19],[14,7],[8,25],[7,23],[26,17],[9,23],[14,9],[19,11],[8,18],[18,10],[12,3],[10,21],[27,12],[14,18],[7,10],[16,1],[1,20],[22,7],[4,14],[18,2],[20,3],[2,21],[16,27],[4,22]],
"numthickedges":30,
"face":[[16,27,26,15],[5,17,27,16],[0,13,12,1],[15,0,1,16],[16,1,20,5],[1,4,22,20],[4,8,25,22],[27,12,13,26],[17,3,12,27],[3,7,14,12],[26,13,0,15],[5,20,3,17],[20,22,7,3],[22,25,10,7],[7,10,21,23],[10,24,11,21],[12,14,4,1],[14,18,8,4],[9,2,18,14],[2,19,6,18],[8,18,10,25],[7,23,9,14],[23,21,2,9],[21,11,19,2],[6,19,11,24],[18,6,24,10]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,2,2,2,-3,3,3,3,3,3,-3,-3,-3,-3,1,-1,2,2,1,-2]},

Hexa113 : {
"name":"hexa#113 (mirror of #114, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,0], [2,0,0], [3,0,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[-1,0,1],[-2,-1,1],[0,-1,0],[2,0,0],[2,0,-1],[1,-1,-1],[1,-1,0],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,-1],[1,0,0],[2,1,-1],[2,1,0],[-1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[17,27],[20,21],[24,6],[7,24],[7,19],[2,23],[13,21],[19,6],[3,23],[22,23],[17,7],[25,20],[27,22],[1,24],[17,25],[21,3],[1,13],[27,2],[1,2],[20,4],[4,22],[4,3],[25,19],[13,6],[26,13],[21,9],[20,10],[0,1],[12,21],[18,1],[11,20],[14,13],[0,14],[5,8],[15,16],[11,12],[18,26],[5,15],[10,9],[8,16]],
"numthickedges":24,
"face":[[18,26,25,17],[7,19,26,18],[17,0,1,18],[18,1,24,7],[0,5,8,1],[5,11,12,8],[11,27,2,12],[26,13,14,25],[19,6,13,26],[13,16,15,14],[16,21,20,15],[25,14,0,17],[14,15,5,0],[15,20,11,5],[20,10,27,11],[4,22,10,20],[1,13,6,24],[7,24,6,19],[1,8,16,13],[8,12,21,16],[12,2,9,21],[21,9,23,3],[27,10,9,2],[10,22,23,9],[21,3,4,20],[3,23,22,4]],
"facedirection":[-1,-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,1,3,3,3,3,3,1,1,-1,2]},

Hexa114 : {
"name":"hexa#114 (mirror of #113, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,0,1], [1,0,1], [2,0,1], [3,0,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,0],[-2,-1,1],[2,0,0],[0,0,1],[1,-1,0],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[-2,0,1],[1,0,0],[2,-1,1],[2,1,0],[-1,-1,1],[1,1,1],[0,-1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,0]],
"edge":[[0,12],[12,11],[2,21],[14,0],[5,16],[27,19],[11,17],[5,18],[9,21],[16,9],[2,19],[14,5],[14,25],[17,2],[1,11],[0,1],[25,12],[1,27],[21,10],[25,16],[18,10],[19,10],[27,18],[17,9],[11,3],[26,11],[17,6],[24,9],[9,23],[8,17],[1,20],[15,1],[20,3],[6,23],[15,26],[13,7],[22,7],[8,24],[4,13],[4,22]],
"numthickedges":24,
"face":[[15,26,25,14],[5,16,26,15],[0,12,11,1],[14,0,1,15],[15,1,20,5],[1,4,22,20],[4,8,24,22],[8,27,18,24],[26,11,12,25],[16,3,11,26],[3,7,13,11],[7,9,17,13],[25,12,0,14],[5,20,3,16],[20,22,7,3],[22,24,9,7],[24,18,23,9],[9,23,10,21],[11,13,4,1],[13,17,8,4],[17,6,27,8],[2,19,6,17],[27,6,23,18],[6,19,10,23],[9,21,2,17],[21,10,19,2]],
"facedirection":[-1,-1,1,-2,-2,-2,-2,-2,2,2,2,2,-3,3,3,3,3,3,-3,-3,-3,-3,1,1,-1,2]},

Hexa115 : {
"name":"hexa#115 (mirror of #116, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,0], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[-1.5,1.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[1.5,-1.5,-1],[1.5,-1.5,0],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[17,4],[17,9],[14,7],[18,26],[11,3],[20,21],[26,21],[8,24],[14,23],[19,2],[14,20],[9,20],[7,24],[19,7],[8,22],[9,10],[2,24],[26,19],[18,10],[3,22],[11,2],[4,23],[11,8],[23,22],[4,3],[17,18],[10,21],[26,11],[27,8],[0,14],[25,14],[1,8],[25,26],[12,11],[5,6],[16,15],[0,1],[5,16],[12,27],[6,15]],
"numthickedges":27,
"face":[[18,26,25,17],[26,11,12,25],[19,2,11,26],[11,3,4,12],[17,0,1,18],[0,5,6,1],[5,9,10,6],[25,14,0,17],[12,27,14,25],[4,23,27,12],[14,16,5,0],[16,20,9,5],[18,1,13,26],[11,8,22,3],[1,6,15,13],[6,10,21,15],[14,27,8,13],[13,8,24,7],[27,23,22,8],[26,13,7,19],[2,24,8,11],[19,7,24,2],[3,22,23,4],[13,15,16,14],[15,21,20,16],[9,20,21,10]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-2,2,3,2,2,2,1]},

Hexa116 : {
"name":"hexa#116 (mirror of #115, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[-1.5,1.5,-1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[15,4],[16,26],[11,3],[27,20],[15,0],[17,2],[6,23],[7,20],[17,7],[5,24],[2,20],[26,17],[1,13],[0,1],[0,27],[11,2],[4,23],[3,24],[11,5],[27,6],[16,1],[6,5],[13,7],[4,3],[15,16],[23,24],[26,13],[26,11],[25,26],[13,19],[27,18],[12,11],[12,27],[14,13],[21,22],[10,9],[10,21],[9,22],[25,14],[18,19]],
"numthickedges":27,
"face":[[16,26,25,15],[26,11,12,25],[17,2,11,26],[11,3,4,12],[0,14,13,1],[14,27,8,13],[13,8,20,7],[15,0,1,16],[25,14,0,15],[12,27,14,25],[4,18,27,12],[18,21,10,27],[21,23,6,10],[16,1,13,26],[11,8,19,3],[8,9,22,19],[9,5,24,22],[26,13,7,17],[2,20,8,11],[17,7,20,2],[3,19,18,4],[19,22,21,18],[22,24,23,21],[27,10,9,8],[10,6,5,9],[6,23,24,5]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,-2,2,3,2,2,2,-2,-2,1]},

Hexa117 : {
"name":"hexa#117 (mirror of #118, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,1], [1,0,0], [2,0,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[-0.5,-0.5,1],[1.5,-1.5,-1],[1.5,-1.5,0],[-0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,-1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[-1.5,1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[17,8],[22,10],[14,7],[18,26],[11,3],[7,10],[20,21],[26,21],[12,11],[27,6],[14,27],[24,10],[14,20],[19,24],[8,20],[19,7],[6,22],[17,12],[8,9],[26,19],[18,9],[3,22],[12,27],[11,6],[3,24],[17,18],[9,21],[26,11],[11,2],[6,23],[0,14],[25,14],[1,6],[25,26],[4,5],[16,15],[2,23],[0,1],[4,16],[5,15]],
"numthickedges":27,
"face":[[18,26,25,17],[26,11,12,25],[19,2,11,26],[2,24,3,11],[17,0,1,18],[0,4,5,1],[4,8,9,5],[25,14,0,17],[12,27,14,25],[14,16,4,0],[16,20,8,4],[18,1,13,26],[1,5,15,13],[5,9,21,15],[14,27,6,13],[13,6,23,7],[6,22,10,23],[11,6,27,12],[26,13,7,19],[19,7,23,2],[2,23,10,24],[24,10,22,3],[3,22,6,11],[13,15,16,14],[15,21,20,16],[8,20,21,9]],
"facedirection":[-1,-1,-1,-1,-2,-2,-2,-3,-3,-3,-3,3,3,3,1,1,1,2,-2,3,3,2,-3,2,2,1]},

Hexa118 : {
"name":"hexa#118 (mirror of #117, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,2,0], [1,0,0], [1,0,1], [2,0,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,1.5,0],[-1.5,1.5,-1],[0.5,-1.5,-1],[-0.5,-0.5,1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[1.5,-1.5,0],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,-1.5,1],[0.5,-1.5,1],[1.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[18,2],[17,3],[14,5],[22,5],[5,10],[14,21],[4,6],[24,10],[16,15],[17,4],[1,22],[14,16],[15,19],[1,20],[2,20],[4,16],[3,21],[9,24],[18,1],[6,9],[21,20],[6,15],[3,2],[17,18],[9,19],[22,24],[19,10],[0,14],[6,23],[15,8],[0,1],[25,14],[26,15],[1,6],[12,11],[27,7],[23,8],[12,27],[11,7],[25,26]],
"numthickedges":27,
"face":[[18,26,25,17],[26,11,12,25],[11,2,3,12],[17,0,1,18],[0,4,6,1],[1,6,23,22],[6,9,24,23],[25,14,0,17],[12,27,14,25],[3,21,27,12],[14,16,4,0],[18,1,13,26],[26,13,7,11],[11,7,20,2],[14,27,7,13],[27,21,20,7],[2,20,21,3],[4,16,15,6],[13,15,16,14],[5,8,15,13],[8,10,19,15],[22,5,13,1],[22,23,8,5],[23,24,10,8],[9,19,10,24],[15,19,9,6]],
"facedirection":[-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,3,3,3,1,1,2,1,2,2,2,-1,3,3,1,-3]},

Hexa119 : {
"name":"hexa#119 (mirror of #120, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [0,2,1], [1,1,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[-1.5,1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[-1.5,1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[22,10],[14,6],[18,26],[11,3],[6,10],[21,20],[1,22],[17,0],[12,11],[24,10],[14,21],[26,20],[19,24],[19,6],[12,5],[17,12],[20,4],[26,19],[3,22],[0,1],[11,4],[3,24],[18,1],[21,5],[5,4],[17,18],[14,27],[26,11],[11,2],[25,14],[25,26],[27,23],[9,8],[16,15],[2,23],[16,9],[15,8]],
"numthickedges":27,
"face":[[18,26,25,17],[26,11,12,25],[19,2,11,26],[2,24,3,11],[0,14,13,1],[13,7,23,6],[7,22,10,23],[17,0,1,18],[25,14,0,17],[12,27,14,25],[27,9,16,14],[9,5,21,16],[18,1,13,26],[13,15,8,7],[15,20,4,8],[11,7,27,12],[7,8,9,27],[8,4,5,9],[26,13,6,19],[14,16,15,13],[16,21,20,15],[19,6,23,2],[2,23,10,24],[24,10,22,3],[3,22,7,11],[21,5,4,20]],
"facedirection":[-1,-1,-1,-1,1,1,1,-2,-3,-3,-3,-3,3,3,3,2,2,2,-2,-2,-2,3,3,2,-3,1]},

Hexa120 : {
"name":"hexa#120 (mirror of #119, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,2,0], [2,0,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[1.5,-1.5,0],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[0.5,-1.5,1],[1.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,2],[21,2],[2,10],[12,18],[3,4],[26,17],[24,10],[18,20],[20,22],[15,3],[1,21],[16,26],[15,25],[1,19],[25,12],[4,22],[7,24],[16,1],[4,7],[7,17],[18,19],[15,16],[25,26],[3,20],[21,24],[19,22],[17,10],[0,12],[4,23],[0,1],[12,14],[1,4],[27,5],[5,8],[14,6],[9,8],[27,9],[23,6]],
"numthickedges":27,
"face":[[16,26,25,15],[15,0,1,16],[0,3,4,1],[1,4,23,21],[4,7,24,23],[26,11,12,25],[2,6,13,11],[6,10,17,13],[25,12,0,15],[12,14,3,0],[27,9,14,12],[18,20,9,27],[16,1,11,26],[11,13,8,5],[5,8,22,19],[3,14,13,4],[14,9,8,13],[9,20,22,8],[21,2,11,1],[11,5,27,12],[5,19,18,27],[21,23,6,2],[23,24,10,6],[19,22,20,18],[7,17,10,24],[13,17,7,4]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,3,3,3,1,1,1,-1,-1,-1,3,3,2,1,-3]},

Hexa121 : {
"name":"hexa#121 (mirror of #122, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,20],[12,5],[19,18],[27,22],[1,21],[7,3],[15,0],[17,2],[12,19],[26,18],[20,23],[5,22],[17,5],[15,10],[8,7],[23,24],[8,23],[7,24],[2,22],[16,26],[18,3],[26,17],[0,1],[10,2],[10,27],[8,4],[16,1],[19,4],[4,3],[20,21],[15,16],[21,24],[12,27],[9,7],[25,12],[14,8],[13,7],[26,9],[25,26],[27,8],[14,13]],
"numthickedges":33,
"face":[[16,26,25,15],[26,9,10,25],[17,2,9,26],[0,12,11,1],[11,6,22,5],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,14,12],[20,23,8,27],[8,4,19,14],[16,1,11,26],[11,13,7,6],[6,7,24,21],[13,18,3,7],[9,6,27,10],[2,22,6,9],[7,3,4,8],[26,11,5,17],[12,14,13,11],[14,19,18,13],[17,5,22,2],[6,21,20,27],[8,23,24,7],[21,24,23,20],[19,4,3,18]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,2,-2,-2,-2,3,-1,1,2,1]},

Hexa122 : {
"name":"hexa#122 (mirror of #121, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[0.5,-1.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,4],[22,4],[18,17],[9,2],[12,19],[22,24],[26,17],[19,21],[25,12],[13,18],[10,9],[21,23],[15,5],[5,13],[10,21],[9,23],[13,8],[1,22],[16,26],[15,25],[17,2],[1,20],[4,8],[24,8],[10,3],[16,1],[18,3],[19,20],[3,2],[5,24],[15,16],[25,26],[20,23],[7,9],[0,12],[12,13],[13,10],[6,9],[0,1],[27,10],[1,6],[27,7]],
"numthickedges":33,
"face":[[16,26,25,15],[15,0,1,16],[0,5,6,1],[1,6,24,22],[26,11,12,25],[4,8,14,11],[25,12,0,15],[12,13,5,0],[27,10,13,12],[19,21,10,27],[10,3,18,13],[16,1,11,26],[11,14,9,7],[7,9,23,20],[14,17,2,9],[5,13,14,6],[6,14,8,24],[10,21,23,9],[22,4,11,1],[11,7,27,12],[7,20,19,27],[22,24,8,4],[20,23,21,19],[18,3,2,17],[13,18,17,14],[9,2,3,10]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-1,-1,-1,3,2,1,-2,2]},

Hexa123 : {
"name":"hexa#123 (mirror of #124, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,18],[12,5],[27,20],[1,19],[7,3],[15,0],[18,23],[17,2],[19,24],[4,23],[5,20],[17,5],[26,13],[15,10],[3,24],[14,13],[8,7],[2,20],[12,14],[16,26],[26,17],[0,1],[10,2],[10,27],[8,4],[16,1],[18,19],[4,3],[14,8],[13,7],[15,16],[23,24],[12,27],[9,7],[25,12],[26,9],[25,26],[27,8],[8,21],[7,22],[21,22]],
"numthickedges":33,
"face":[[16,26,25,15],[26,9,10,25],[17,2,9,26],[0,12,11,1],[11,6,20,5],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,14,12],[18,21,8,27],[21,23,4,8],[16,1,11,26],[11,13,7,6],[6,7,22,19],[7,3,24,22],[9,6,27,10],[2,20,6,9],[26,11,5,17],[12,14,13,11],[17,5,20,2],[14,8,7,13],[6,19,18,27],[19,22,21,18],[22,24,23,21],[4,23,24,3],[8,4,3,7]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,-2,-2,3,1,-1,2,2,1,-2]},

Hexa124 : {
"name":"hexa#124 (mirror of #123, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [1,2,1], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,18],[12,11],[27,19],[9,2],[15,0],[18,22],[10,9],[24,8],[3,22],[11,13],[15,10],[2,23],[14,13],[6,24],[13,21],[18,7],[12,14],[1,11],[0,1],[16,9],[10,27],[6,3],[16,1],[21,23],[3,2],[19,24],[21,8],[14,6],[7,8],[15,16],[22,23],[19,7],[12,27],[26,11],[25,12],[11,17],[27,6],[17,21],[20,21],[6,20],[25,26]],
"numthickedges":33,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,6,14,12],[18,20,6,27],[20,22,3,6],[16,1,11,26],[26,11,4,9],[11,13,5,4],[5,2,23,21],[9,4,27,10],[14,6,5,13],[5,21,8,24],[12,14,13,11],[4,17,18,27],[19,7,17,4],[17,21,20,18],[7,8,21,17],[21,23,22,20],[4,5,24,19],[6,3,2,5],[19,24,8,7],[3,22,23,2]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,1,1,-2,-1,-1,2,2,2,-2,-2,3,1]},

Hexa125 : {
"name":"hexa#125 (mirror of #126, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,0], [2,1,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[12,5],[19,18],[19,23],[1,6],[15,0],[6,20],[17,2],[12,19],[26,18],[21,23],[5,20],[17,5],[6,7],[15,10],[8,7],[21,22],[8,21],[7,22],[2,20],[16,26],[26,17],[0,1],[18,24],[10,2],[16,1],[22,24],[10,8],[15,16],[23,24],[12,27],[27,6],[25,12],[9,6],[7,3],[14,8],[13,7],[26,9],[25,26],[8,4],[14,13],[4,3]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[17,2,9,26],[0,12,11,1],[11,6,20,5],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,14,12],[8,4,19,14],[21,23,4,8],[16,1,11,26],[11,13,7,6],[13,18,3,7],[7,3,24,22],[9,6,27,10],[2,20,6,9],[6,7,8,27],[26,11,5,17],[12,14,13,11],[14,19,18,13],[17,5,20,2],[19,4,3,18],[4,23,24,3],[7,22,21,8],[22,24,23,21]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,2,-2,-2,-2,3,1,1,-1,2]},

Hexa126 : {
"name":"hexa#126 (mirror of #125, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[-0.5,-1.5,1],[0.5,1.5,0],[0.5,-1.5,1],[1.5,1.5,-1],[1.5,1.5,0],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,4],[20,4],[9,2],[17,23],[12,17],[20,22],[18,24],[3,23],[26,13],[2,24],[10,9],[15,5],[1,20],[16,26],[15,25],[1,18],[25,12],[4,8],[13,8],[22,8],[10,3],[16,1],[17,18],[3,2],[5,22],[13,9],[15,16],[25,26],[5,10],[23,24],[7,9],[0,12],[0,1],[12,14],[14,13],[27,10],[1,6],[6,13],[9,21],[10,19],[27,7],[19,21]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,5,6,1],[1,6,22,20],[26,11,12,25],[4,8,13,11],[25,12,0,15],[12,14,5,0],[27,10,14,12],[17,19,10,27],[19,23,3,10],[16,1,11,26],[11,13,9,7],[7,9,21,18],[9,2,24,21],[5,14,13,6],[6,13,8,22],[14,10,9,13],[20,4,11,1],[11,7,27,12],[7,18,17,27],[20,22,8,4],[18,21,19,17],[21,24,23,19],[3,23,24,2],[10,3,2,9]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-1,-1,-1,3,2,2,1,-2]},

Hexa127 : {
"name":"hexa#127 (mirror of #128, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[20,9],[27,21],[26,19],[7,3],[3,23],[16,0],[18,2],[24,10],[1,20],[8,23],[16,12],[18,8],[7,22],[2,21],[24,23],[17,26],[19,3],[26,18],[0,1],[0,27],[12,2],[12,27],[17,1],[7,24],[22,10],[9,10],[16,17],[20,22],[21,9],[19,8],[11,7],[6,24],[15,7],[21,24],[26,11],[25,26],[4,21],[14,4],[25,14],[15,6]],
"numthickedges":30,
"face":[[17,26,25,16],[26,11,12,25],[18,2,11,26],[0,14,13,1],[14,27,5,13],[16,0,1,17],[25,14,0,16],[12,27,14,25],[17,1,13,26],[11,5,27,12],[2,21,5,11],[24,23,3,7],[26,13,4,18],[13,15,6,4],[15,19,8,6],[18,4,21,2],[4,6,24,21],[21,24,10,9],[6,8,23,24],[5,7,15,13],[20,22,7,5],[7,3,19,15],[21,9,20,5],[7,22,10,24],[9,10,22,20],[19,3,23,8]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,3,2,2,2,-2,-2,-2,3,3,3,3,-3,-3,-3,-1,1,2,1]},

Hexa128 : {
"name":"hexa#128 (mirror of #127, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[1.5,0.5,1],[0.5,-1.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[18,9],[7,2],[2,22],[6,8],[26,17],[21,23],[23,6],[24,10],[8,22],[14,6],[15,4],[7,20],[1,21],[16,26],[15,25],[17,2],[1,18],[4,14],[25,14],[16,1],[4,23],[7,24],[20,10],[24,22],[9,10],[15,16],[25,26],[18,20],[17,8],[21,9],[27,7],[3,6],[6,24],[5,7],[0,1],[1,5],[19,24],[0,12],[12,3],[27,19]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[1,5,23,21],[26,11,12,25],[11,13,14,12],[25,12,0,15],[12,14,4,0],[16,1,11,26],[4,14,13,5],[5,13,6,23],[7,20,10,24],[21,3,11,1],[3,19,27,11],[19,9,18,27],[21,23,6,3],[3,6,24,19],[19,24,10,9],[6,8,22,24],[27,7,13,11],[18,20,7,27],[7,2,17,13],[9,10,20,18],[17,2,22,8],[13,17,8,6],[24,22,2,7]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,3,1,1,1,-1,-1,-1,3,3,3,3,-3,-3,-3,2,1,-2,2]},

Hexa129 : {
"name":"hexa#129 (mirror of #130, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,1], [1,2,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[19,8],[27,20],[7,3],[3,22],[16,0],[18,2],[26,15],[19,23],[18,6],[1,19],[16,11],[3,23],[2,20],[24,22],[8,12],[17,26],[26,18],[0,1],[22,12],[0,27],[23,12],[15,6],[6,24],[11,2],[11,27],[17,1],[7,24],[15,7],[16,17],[20,8],[10,7],[20,24],[26,10],[25,26],[24,9],[7,21],[4,20],[14,4],[25,14],[21,9]],
"numthickedges":30,
"face":[[17,26,25,16],[26,10,11,25],[18,2,10,26],[0,14,13,1],[14,27,5,13],[16,0,1,17],[25,14,0,16],[11,27,14,25],[17,1,13,26],[10,5,27,11],[2,20,5,10],[26,13,4,18],[13,15,6,4],[18,4,20,2],[4,6,24,20],[20,24,9,8],[24,22,12,9],[15,7,24,6],[5,7,15,13],[19,21,7,5],[21,23,3,7],[20,8,19,5],[8,9,21,19],[9,12,23,21],[3,23,12,22],[7,3,22,24]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,3,2,2,-2,-2,3,3,3,3,1,-3,-3,-3,-1,2,2,1,-2]},

Hexa130 : {
"name":"hexa#130 (mirror of #129, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[0.5,-1.5,-1],[0.5,-1.5,0],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[0.5,1.5,1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,0.5,1],[0.5,1.5,0],[-0.5,-1.5,1],[1.5,0.5,1],[0.5,-1.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,0]],
"edge":[[1,27],[27,18],[20,18],[6,8],[26,17],[20,22],[22,6],[24,9],[8,10],[27,7],[14,6],[15,4],[7,19],[1,20],[16,26],[15,25],[23,10],[4,14],[17,23],[25,14],[16,1],[9,10],[19,23],[18,24],[4,22],[7,24],[19,9],[15,16],[25,26],[17,8],[3,6],[6,24],[7,2],[5,7],[0,1],[1,5],[24,21],[0,12],[12,3],[2,21]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[1,5,22,20],[26,11,12,25],[11,13,14,12],[25,12,0,15],[12,14,4,0],[16,1,11,26],[4,14,13,5],[5,13,6,22],[20,3,11,1],[3,18,27,11],[20,22,6,3],[3,6,24,18],[6,8,21,24],[24,21,10,9],[18,24,7,27],[27,7,13,11],[7,2,17,13],[19,23,2,7],[17,2,21,8],[2,23,10,21],[13,17,8,6],[24,9,19,7],[9,10,23,19]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,3,1,1,-1,-1,3,3,3,3,2,-3,-3,-3,1,1,-2,-1,2]},

Hexa131 : {
"name":"hexa#131 (mirror of #132, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [0,1,1], [1,1,1], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[-1.5,0.5,1],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[1.5,-0.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-1.5,-0.5,1],[1.5,-0.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[26,19],[1,5],[16,0],[27,5],[18,2],[24,9],[8,12],[5,7],[16,11],[18,8],[7,21],[2,24],[17,26],[26,18],[0,1],[0,27],[23,12],[19,23],[11,2],[11,27],[17,1],[9,12],[21,23],[7,24],[21,9],[16,17],[19,8],[5,20],[6,24],[10,5],[7,3],[15,7],[24,22],[26,10],[25,26],[14,4],[3,22],[4,20],[25,14],[15,6]],
"numthickedges":27,
"face":[[17,26,25,16],[26,10,11,25],[18,2,10,26],[0,14,13,1],[14,27,5,13],[16,0,1,17],[25,14,0,16],[11,27,14,25],[17,1,13,26],[10,5,27,11],[2,20,5,10],[20,24,7,5],[26,13,4,18],[13,15,6,4],[15,19,8,6],[18,4,20,2],[4,6,24,20],[6,8,22,24],[24,22,12,9],[5,7,15,13],[7,3,19,15],[21,23,3,7],[19,3,22,8],[3,23,12,22],[24,9,21,7],[9,12,23,21]],
"facedirection":[-1,-1,-1,1,1,-2,-3,-3,3,2,2,2,-2,-2,-2,3,3,3,3,-3,-3,-3,1,1,-1,2]},

Hexa132 : {
"name":"hexa#132 (mirror of #131, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [2,1,0], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[14,13],[10,2],[17,0],[5,8],[11,10],[14,20],[8,12],[13,15],[11,3],[17,11],[2,23],[15,21],[1,13],[0,1],[18,10],[15,5],[20,8],[23,12],[18,1],[20,3],[5,9],[9,12],[21,23],[3,2],[21,9],[17,18],[14,27],[25,14],[26,13],[15,19],[19,2],[13,4],[16,15],[2,22],[27,4],[7,24],[24,22],[16,7],[25,26]],
"numthickedges":27,
"face":[[18,26,25,17],[26,10,11,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[11,27,14,25],[27,7,16,14],[7,3,20,16],[18,1,13,26],[26,13,4,10],[13,15,6,4],[10,4,27,11],[4,6,7,27],[6,2,3,7],[14,16,15,13],[16,20,19,15],[15,19,8,5],[20,3,2,19],[19,2,22,8],[2,23,12,22],[5,24,6,15],[24,9,21,6],[5,8,22,24],[24,22,12,9],[9,12,23,21],[21,23,2,6]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,3,3,3,2,2,2,-2,-2,-2,1,1,1,-1,-1,3,3,2,-3]},

Hexa133 : {
"name":"hexa#133 (mirror of #134, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,19],[12,4],[18,17],[1,20],[9,2],[15,0],[27,21],[10,9],[12,18],[19,22],[4,21],[15,10],[8,24],[22,23],[8,22],[14,23],[14,17],[17,2],[0,1],[4,6],[16,9],[14,6],[6,24],[10,27],[8,3],[16,1],[18,3],[3,2],[19,20],[21,24],[15,16],[20,23],[12,27],[25,12],[13,8],[26,14],[13,14],[27,8],[25,26]],
"numthickedges":33,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,13,12],[19,22,8,27],[8,3,18,13],[16,1,11,26],[26,11,5,9],[5,7,23,20],[14,17,2,7],[9,5,27,10],[21,24,7,5],[7,2,3,8],[12,13,14,11],[11,14,6,4],[13,18,17,14],[4,21,5,11],[5,20,19,27],[14,7,24,6],[8,22,23,7],[4,6,24,21],[20,23,22,19],[18,3,2,17]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,2,-2,-2,-2,-1,-1,1,1,3,2,1]},

Hexa134 : {
"name":"hexa#134 (mirror of #133, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [1,2,0], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,6],[18,17],[7,2],[7,21],[12,19],[4,5],[16,5],[26,17],[19,22],[6,21],[25,12],[13,18],[7,20],[13,8],[10,24],[15,4],[4,13],[10,22],[5,23],[22,23],[16,26],[15,25],[17,2],[6,8],[8,24],[10,3],[18,3],[19,20],[3,2],[21,24],[15,16],[25,26],[20,23],[27,7],[0,12],[12,13],[1,7],[13,10],[27,10],[0,1]],
"numthickedges":33,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,13,4,0],[27,10,13,12],[19,22,10,27],[10,3,18,13],[16,1,11,26],[1,5,14,11],[7,9,23,20],[14,17,2,9],[4,13,14,5],[14,9,24,8],[10,22,23,9],[11,7,27,12],[6,21,7,11],[7,20,19,27],[11,14,8,6],[13,18,17,14],[21,24,9,7],[9,2,3,10],[6,8,24,21],[20,23,22,19],[18,3,2,17]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-1,-1,-1,-2,-2,2,2,3,2,1]},

Hexa135 : {
"name":"hexa#135 (mirror of #136, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,18],[12,3],[20,23],[1,19],[2,23],[9,2],[15,0],[27,20],[3,8],[10,9],[18,21],[3,20],[8,23],[15,10],[14,13],[21,22],[13,22],[12,14],[13,17],[17,2],[0,1],[16,9],[10,27],[16,1],[18,19],[15,16],[19,22],[14,21],[17,8],[12,27],[13,5],[25,12],[26,13],[27,7],[7,24],[5,24],[25,26]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,7,14,12],[18,21,7,27],[16,1,11,26],[26,11,4,9],[4,6,22,19],[9,4,27,10],[20,24,6,4],[24,23,2,6],[14,7,6,13],[7,21,22,6],[12,14,13,11],[11,13,5,3],[13,17,8,5],[3,20,4,11],[4,19,18,27],[3,5,24,20],[5,8,23,24],[19,22,21,18],[17,2,23,8],[6,2,17,13]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,3,3,3,2,2,2,1,1,-2,-2,-2,-1,-1,3,3,2,1,-3]},

Hexa136 : {
"name":"hexa#136 (mirror of #135, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [1,2,1], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[21,11],[14,6],[20,19],[6,11],[7,2],[4,5],[27,7],[18,5],[14,27],[26,19],[25,14],[16,20],[7,21],[16,8],[17,4],[5,23],[18,26],[17,25],[19,2],[6,8],[4,16],[27,3],[20,3],[8,12],[3,2],[23,12],[11,12],[17,18],[25,26],[21,23],[7,22],[0,14],[14,16],[1,7],[16,10],[10,24],[0,1],[22,24]],
"numthickedges":30,
"face":[[18,26,25,17],[17,0,1,18],[0,4,5,1],[26,13,14,25],[25,14,0,17],[14,16,4,0],[27,10,16,14],[10,3,20,16],[18,1,13,26],[1,5,15,13],[15,19,2,9],[4,16,15,5],[15,9,24,8],[9,23,12,24],[13,7,27,14],[6,22,7,13],[22,11,21,7],[7,9,10,27],[9,2,3,10],[13,15,8,6],[16,20,19,15],[6,8,24,22],[22,24,12,11],[11,12,23,21],[21,23,9,7],[20,3,2,19]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,3,3,3,1,1,1,-1,-1,-1,2,2,-2,-2,3,3,2,-3,1]},

Hexa137 : {
"name":"hexa#137 (mirror of #138, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,1], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[21,9],[14,4],[20,19],[4,9],[11,2],[17,0],[12,11],[14,20],[12,3],[1,21],[17,12],[15,23],[15,19],[19,2],[0,1],[4,6],[18,11],[15,6],[18,1],[20,3],[6,10],[3,2],[23,10],[9,10],[17,18],[21,23],[14,27],[25,14],[26,15],[16,15],[27,22],[8,24],[22,24],[16,8],[25,26]],
"numthickedges":27,
"face":[[18,26,25,17],[26,11,12,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[12,27,14,25],[27,8,16,14],[8,3,20,16],[18,1,13,26],[26,13,5,11],[15,19,2,7],[11,5,27,12],[5,7,8,27],[7,2,3,8],[14,16,15,13],[13,15,6,4],[16,20,19,15],[4,22,5,13],[22,9,21,5],[15,7,24,6],[7,23,10,24],[4,6,24,22],[22,24,10,9],[9,10,23,21],[21,23,7,5],[20,3,2,19]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,3,3,3,2,2,2,-2,-2,-2,-1,-1,1,1,3,3,2,-3,1]},

Hexa138 : {
"name":"hexa#138 (mirror of #137, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [1,2,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,5],[20,23],[2,23],[6,2],[6,20],[5,10],[12,19],[3,4],[16,4],[26,17],[19,21],[5,20],[6,18],[10,23],[21,22],[15,3],[4,22],[16,26],[15,25],[17,2],[25,12],[19,18],[15,16],[25,26],[3,21],[18,22],[17,10],[27,6],[0,12],[1,6],[12,14],[14,7],[9,24],[0,1],[27,9],[7,24]],
"numthickedges":27,
"face":[[16,26,25,15],[15,0,1,16],[0,3,4,1],[26,11,12,25],[25,12,0,15],[12,14,3,0],[27,9,14,12],[19,21,9,27],[16,1,11,26],[1,4,13,11],[6,8,22,18],[3,14,13,4],[14,9,8,13],[9,21,22,8],[11,6,27,12],[5,20,6,11],[6,18,19,27],[11,13,7,5],[13,17,10,7],[20,24,8,6],[24,23,2,8],[5,7,24,20],[7,10,23,24],[18,22,21,19],[17,2,23,10],[8,2,17,13]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,3,3,3,1,1,1,-1,-1,-1,-2,-2,2,2,3,3,2,1,-3]},

Hexa139 : {
"name":"hexa#139 (mirror of #140, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[20,9],[14,3],[3,9],[11,2],[2,23],[17,0],[3,8],[12,11],[24,10],[1,20],[8,23],[17,12],[7,24],[16,15],[15,22],[14,16],[15,19],[19,2],[0,1],[18,11],[18,1],[24,23],[22,10],[16,7],[12,7],[17,18],[9,10],[20,22],[19,8],[14,27],[5,24],[15,5],[25,14],[26,15],[21,24],[27,21],[25,26]],
"numthickedges":30,
"face":[[18,26,25,17],[26,11,12,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[12,27,14,25],[27,7,16,14],[18,1,13,26],[26,13,4,11],[11,4,27,12],[4,6,7,27],[24,23,2,6],[16,7,6,15],[6,22,10,24],[14,16,15,13],[13,15,5,3],[15,19,8,5],[3,21,4,13],[21,9,20,4],[3,5,24,21],[21,24,10,9],[5,8,23,24],[9,10,22,20],[20,22,6,4],[6,2,19,15],[19,2,23,8]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,3,3,2,2,2,1,1,-2,-2,-2,-1,-1,3,3,3,2,-3,-3,1]},

Hexa140 : {
"name":"hexa#140 (mirror of #139, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [1,2,1], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,1.5,1],[0.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[20,11],[14,5],[5,11],[6,2],[2,23],[5,10],[3,4],[27,6],[18,4],[4,22],[14,27],[26,19],[24,12],[6,20],[10,23],[9,24],[17,3],[18,26],[17,25],[19,2],[25,14],[27,9],[24,23],[22,12],[11,12],[17,18],[25,26],[3,9],[20,22],[19,10],[6,21],[0,14],[7,24],[1,6],[14,16],[21,24],[16,7],[0,1]],
"numthickedges":30,
"face":[[18,26,25,17],[17,0,1,18],[0,3,4,1],[26,13,14,25],[25,14,0,17],[14,16,3,0],[27,9,16,14],[18,1,13,26],[1,4,15,13],[3,16,15,4],[16,9,8,15],[8,22,12,24],[13,6,27,14],[5,21,6,13],[21,11,20,6],[6,8,9,27],[24,23,2,8],[13,15,7,5],[15,19,10,7],[5,7,24,21],[21,24,12,11],[7,10,23,24],[11,12,22,20],[20,22,8,6],[8,2,19,15],[19,2,23,10]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,3,3,1,1,1,-1,-1,-1,2,2,-2,-2,3,3,3,2,-3,-3,1]},

Hexa141 : {
"name":"hexa#141, 'left screw' (mirror of #142, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [1,2,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,14],[19,8],[14,3],[3,8],[2,22],[10,2],[17,0],[11,10],[19,23],[1,19],[17,11],[7,24],[2,23],[16,5],[8,12],[14,16],[0,1],[22,12],[3,5],[18,10],[23,12],[5,24],[18,1],[24,22],[16,7],[11,7],[17,18],[14,27],[25,14],[24,9],[20,24],[27,20],[26,15],[15,21],[21,9],[25,26]],
"numthickedges":27,
"face":[[18,26,25,17],[26,10,11,25],[0,14,13,1],[17,0,1,18],[25,14,0,17],[11,27,14,25],[27,7,16,14],[18,1,13,26],[26,13,4,10],[10,4,27,11],[4,6,7,27],[16,7,6,15],[15,6,24,5],[14,16,15,13],[13,15,5,3],[3,20,4,13],[20,8,19,4],[3,5,24,20],[20,24,9,8],[24,22,12,9],[8,9,21,19],[9,12,23,21],[19,21,6,4],[21,23,2,6],[2,23,12,22],[6,2,22,24]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,3,3,2,2,1,1,-2,-2,-1,-1,3,3,3,2,2,-3,-3,1,-2]},

Hexa142 : {
"name":"hexa#142, 'right screw' (mirror of #141, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [2,1,1], [2,2,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[0.5,1.5,1],[1.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[-0.5,0.5,1],[0.5,1.5,0],[1.5,0.5,1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[14,5],[27,20],[5,10],[3,4],[18,4],[4,21],[14,27],[26,19],[24,11],[5,20],[10,12],[9,24],[17,3],[18,26],[17,25],[25,14],[27,9],[23,12],[19,23],[11,12],[21,23],[20,24],[21,11],[17,18],[25,26],[3,9],[19,10],[0,14],[7,24],[14,16],[24,22],[1,6],[2,22],[6,2],[16,7],[0,1]],
"numthickedges":27,
"face":[[18,26,25,17],[17,0,1,18],[0,3,4,1],[26,13,14,25],[25,14,0,17],[14,16,3,0],[27,9,16,14],[18,1,13,26],[1,4,15,13],[3,16,15,4],[16,9,8,15],[13,6,27,14],[5,20,6,13],[6,8,9,27],[20,24,8,6],[13,15,7,5],[15,19,10,7],[5,7,24,20],[7,10,22,24],[24,22,12,11],[19,2,22,10],[2,23,12,22],[8,2,19,15],[21,23,2,8],[24,11,21,8],[11,12,23,21]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,3,3,1,1,-1,-1,2,2,-2,-2,3,3,3,1,1,-3,-3,-1,2]},

Hexa143 : {
"name":"hexa#143 (mirror of #144, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,1,1], [2,1,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[12,4],[18,17],[18,22],[1,5],[15,0],[5,19],[10,9],[12,18],[20,22],[4,19],[15,10],[8,24],[20,21],[8,20],[13,21],[13,17],[0,1],[4,6],[16,9],[13,6],[17,23],[6,24],[9,5],[16,1],[21,23],[19,24],[10,8],[15,16],[22,23],[12,27],[27,5],[25,12],[14,8],[26,13],[14,13],[5,2],[8,3],[3,2],[25,26]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,8,14,12],[8,3,18,14],[20,22,3,8],[16,1,11,26],[26,11,5,9],[13,17,2,7],[7,2,23,21],[9,5,27,10],[5,7,8,27],[19,24,7,5],[12,14,13,11],[11,13,6,4],[14,18,17,13],[4,19,5,11],[13,7,24,6],[4,6,24,19],[18,3,2,17],[3,22,23,2],[7,21,20,8],[21,23,22,20]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,2,-2,-2,-2,-1,1,3,1,1,-1,2]},

Hexa144 : {
"name":"hexa#144 (mirror of #143, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [1,2,0], [2,2,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,-0.5,1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,-1],[0.5,-0.5,0],[-1.5,-1.5,-1],[-1.5,-1.5,0],[-0.5,1.5,-1],[-0.5,1.5,0],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[1.5,1.5,-1],[1.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,6],[7,2],[7,19],[17,22],[12,17],[4,5],[16,5],[26,14],[18,23],[3,22],[6,19],[7,18],[2,23],[10,24],[15,4],[16,26],[15,25],[25,12],[6,8],[14,8],[8,24],[10,3],[17,18],[3,2],[19,24],[5,14],[15,16],[25,26],[4,10],[22,23],[27,7],[0,12],[1,7],[12,13],[13,14],[27,10],[14,21],[10,20],[20,21],[0,1]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,13,4,0],[27,10,13,12],[17,20,10,27],[20,22,3,10],[16,1,11,26],[1,5,14,11],[7,9,21,18],[9,2,23,21],[4,13,14,5],[13,10,9,14],[14,9,24,8],[11,7,27,12],[6,19,7,11],[7,18,17,27],[11,14,8,6],[19,24,9,7],[6,8,24,19],[18,21,20,17],[21,23,22,20],[3,22,23,2],[10,3,2,9]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-1,-1,-1,-2,2,3,2,2,1,-2]},

Hexa145 : {
"name":"hexa#145 (mirror of #146, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [1,2,1], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,20],[12,11],[18,17],[27,21],[22,8],[9,2],[15,0],[10,9],[11,17],[12,18],[24,8],[20,22],[15,10],[6,24],[6,22],[20,7],[17,2],[1,11],[0,1],[16,9],[10,27],[6,3],[16,1],[18,3],[3,2],[21,24],[7,8],[15,16],[21,7],[12,27],[26,11],[25,12],[14,6],[11,19],[27,6],[14,13],[13,23],[25,26],[19,23]],
"numthickedges":30,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,6,14,12],[20,22,6,27],[6,3,18,14],[16,1,11,26],[26,11,4,9],[11,13,5,4],[13,17,2,5],[9,4,27,10],[5,2,3,6],[12,14,13,11],[14,18,17,13],[4,19,20,27],[21,7,19,4],[6,22,23,5],[5,23,8,24],[19,23,22,20],[7,8,23,19],[4,5,24,21],[21,24,8,7],[18,3,2,17]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,-2,-2,-1,-1,1,1,2,2,-2,3,1]},

Hexa146 : {
"name":"hexa#146 (mirror of #145, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,2,0], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,11],[12,19],[7,10],[4,5],[16,5],[19,21],[25,12],[14,18],[10,23],[14,7],[9,24],[15,4],[4,14],[9,21],[5,22],[21,22],[16,26],[15,25],[18,10],[7,24],[9,3],[18,3],[19,20],[24,23],[11,20],[15,16],[25,26],[20,22],[3,23],[26,11],[0,12],[12,14],[14,9],[27,9],[1,11],[11,17],[6,2],[27,6],[17,2],[0,1]],
"numthickedges":30,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,14,4,0],[27,9,14,12],[19,21,9,27],[9,3,18,14],[16,1,11,26],[1,5,13,11],[11,13,8,6],[6,8,22,20],[4,14,13,5],[9,21,22,8],[11,6,27,12],[6,20,19,27],[20,22,21,19],[18,3,2,17],[17,2,23,10],[14,18,17,13],[13,17,10,7],[8,2,3,9],[24,23,2,8],[7,24,8,13],[7,10,23,24]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,-1,-1,2,1,1,-2,-2,2,2,-1,3]},

Hexa147 : {
"name":"hexa#147 (mirror of #148, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,0], [1,1,0], [1,2,0], [2,1,0], [2,1,1]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[-0.5,0.5,0],[0.5,-0.5,1],[0.5,0.5,0],[0.5,0.5,-1],[1.5,-0.5,1],[-1.5,0.5,0],[-1.5,0.5,-1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,-1],[-0.5,1.5,0],[0.5,1.5,-1],[0.5,1.5,0],[1.5,0.5,1],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[0,12],[27,19],[12,11],[15,0],[5,8],[10,9],[27,4],[12,18],[19,21],[11,13],[1,11],[4,20],[8,23],[15,10],[7,24],[21,22],[7,21],[13,22],[0,1],[16,9],[13,5],[18,8],[5,24],[10,27],[7,3],[9,4],[16,1],[18,3],[19,20],[24,23],[3,23],[15,16],[20,22],[12,27],[25,12],[26,11],[13,17],[11,4],[14,7],[14,13],[27,7],[4,2],[17,2],[25,26]],
"numthickedges":33,
"face":[[16,26,25,15],[26,9,10,25],[0,12,11,1],[15,0,1,16],[25,12,0,15],[10,27,12,25],[27,7,14,12],[19,21,7,27],[7,3,18,14],[16,1,11,26],[26,11,4,9],[11,13,6,4],[4,6,22,20],[9,4,27,10],[6,2,3,7],[24,23,2,6],[12,14,13,11],[14,18,17,13],[13,17,8,5],[4,20,19,27],[7,21,22,6],[20,22,21,19],[18,3,2,17],[17,2,23,8],[5,24,6,13],[5,8,23,24]],
"facedirection":[-1,-1,1,-2,-3,-3,-3,-3,-3,3,3,3,3,2,2,2,-2,-2,-2,-1,1,2,1,1,-1,3]},

Hexa148 : {
"name":"hexa#148 (mirror of #147, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,2,0], [1,2,1], [2,1,0]],
"vertex":[[-0.5,-1.5,-1],[-0.5,-1.5,0],[1.5,0.5,0],[1.5,0.5,-1],[0.5,-1.5,-1],[0.5,-1.5,0],[-0.5,0.5,0],[0.5,0.5,0],[0.5,0.5,-1],[-0.5,1.5,1],[0.5,1.5,1],[-0.5,-0.5,0],[-0.5,-0.5,-1],[0.5,-0.5,0],[0.5,-0.5,-1],[-1.5,-1.5,-1],[-1.5,-1.5,0],[1.5,-0.5,0],[1.5,-0.5,-1],[-0.5,1.5,0],[-0.5,1.5,-1],[-0.5,0.5,1],[0.5,1.5,-1],[0.5,1.5,0],[0.5,0.5,1],[-1.5,-0.5,-1],[-1.5,-0.5,0],[-0.5,0.5,-1]],
"edge":[[12,11],[18,17],[22,10],[11,6],[6,2],[6,21],[12,20],[4,5],[16,5],[24,10],[20,22],[25,12],[14,18],[14,13],[8,24],[15,4],[4,14],[8,22],[20,9],[26,11],[13,17],[16,26],[15,25],[17,2],[8,3],[18,3],[3,2],[21,24],[9,10],[5,13],[15,16],[25,26],[21,9],[1,11],[6,19],[27,6],[0,12],[12,14],[14,8],[11,13],[27,8],[13,23],[0,1],[19,23]],
"numthickedges":33,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[26,11,12,25],[25,12,0,15],[12,14,4,0],[27,8,14,12],[20,22,8,27],[8,3,18,14],[16,1,11,26],[1,5,13,11],[11,13,7,6],[13,17,2,7],[4,14,13,5],[8,22,23,7],[7,23,10,24],[11,6,27,12],[6,19,20,27],[21,9,19,6],[19,23,22,20],[9,10,23,19],[6,7,24,21],[21,24,10,9],[18,3,2,17],[14,18,17,13],[7,2,3,8]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,1,-1,-1,-1,2,2,-2,3,1,-2,2]},

Hexa149 : {
"name":"hexa#149 (mirror of #150, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,1], [1,0,0], [1,0,1], [1,1,1], [2,0,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-1.5,1,1],[0.5,-1,-1],[-0.5,0,1],[0.5,-1,0],[0.5,0,1],[1.5,-1,-1],[0.5,1,0],[1.5,-1,0],[-1.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,-1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[15,7],[18,19],[21,4],[25,19],[5,8],[17,2],[21,22],[7,18],[17,4],[7,9],[24,18],[2,23],[1,21],[16,10],[15,24],[24,17],[1,11],[10,2],[10,8],[16,1],[5,9],[9,19],[22,23],[8,23],[11,4],[15,16],[5,22],[4,20],[4,6],[0,1],[11,26],[1,5],[12,11],[3,5],[0,12],[26,20],[13,6],[3,13]],
"numthickedges":27,
"face":[[16,25,24,15],[17,2,10,25],[15,0,1,16],[0,3,5,1],[1,5,22,21],[3,7,9,5],[25,11,12,24],[11,14,13,12],[14,19,18,13],[24,12,0,15],[12,13,3,0],[13,18,7,3],[16,1,11,25],[5,9,19,14],[25,11,4,17],[2,20,26,10],[20,23,8,26],[10,26,11,25],[26,8,14,11],[17,4,20,2],[21,22,6,4],[4,6,23,20],[21,4,11,1],[5,14,6,22],[14,8,23,6],[7,18,19,9]],
"facedirection":[-1,-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,3,3,-2,2,2,-3,-3,3,3,3,-1,1,1,1]},

Hexa150 : {
"name":"hexa#150 (mirror of #149, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [0,1,1], [1,0,0], [1,0,1], [1,1,1], [2,1,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-1.5,1,1],[1.5,1,0],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[0.5,0,1],[0.5,1,0],[1.5,0,1],[-1.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,0],[0.5,0,-1],[-1.5,-1,-1],[-1.5,-1,0],[-1.5,0,1],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[1.5,1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,0]],
"edge":[[20,4],[25,18],[3,21],[17,4],[7,9],[17,2],[20,22],[2,21],[9,21],[14,7],[15,5],[1,20],[16,10],[15,24],[24,17],[1,11],[18,3],[10,2],[5,14],[22,7],[24,14],[16,1],[10,3],[5,22],[11,4],[15,16],[18,9],[4,19],[4,7],[0,1],[11,26],[7,23],[1,6],[12,11],[0,12],[26,19],[8,23],[6,8]],
"numthickedges":27,
"face":[[16,25,24,15],[17,2,10,25],[15,0,1,16],[0,5,6,1],[1,6,22,20],[25,11,12,24],[11,13,14,12],[24,12,0,15],[12,14,5,0],[16,1,11,25],[25,11,4,17],[13,18,9,7],[2,19,26,10],[19,23,8,26],[23,21,3,8],[10,26,11,25],[26,8,13,11],[8,3,18,13],[17,4,19,2],[20,22,7,4],[4,7,23,19],[7,9,21,23],[5,14,13,6],[6,13,7,22],[20,4,11,1],[18,3,21,9]],
"facedirection":[-1,-1,-2,-2,-2,2,2,-3,-3,3,-2,-2,2,2,2,-3,-3,-3,3,3,3,3,1,1,-1,1]},

Hexa151 : {
"name":"hexa#151 (mirror of #152, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,1,1], [2,0,1]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[1.5,-1,0],[0.5,1,-1],[0.5,1,0],[1.5,0,1],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[1.5,-1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,11],[25,18],[19,18],[6,10],[3,4],[12,25],[22,10],[15,3],[1,19],[24,11],[14,17],[16,24],[15,23],[1,11],[23,12],[25,8],[14,6],[8,21],[7,22],[6,21],[16,1],[4,7],[7,17],[18,21],[4,14],[15,16],[23,24],[3,8],[19,22],[17,10],[11,2],[2,6],[4,20],[0,12],[0,1],[11,14],[11,5],[12,13],[13,14],[20,6],[1,4],[14,9],[5,9]],
"numthickedges":30,
"face":[[16,24,23,15],[15,0,1,16],[0,3,4,1],[1,4,20,19],[4,7,22,20],[24,11,12,23],[6,10,17,14],[23,12,0,15],[12,13,3,0],[25,8,13,12],[16,1,11,24],[3,13,14,4],[13,8,9,14],[14,9,21,6],[19,2,11,1],[11,5,25,12],[2,18,5,11],[19,20,6,2],[2,6,21,18],[20,22,10,6],[5,9,8,25],[18,21,9,5],[7,17,10,22],[14,17,7,4]],
"facedirection":[-1,-2,-2,-2,-2,2,2,-3,-3,-3,3,1,1,1,-1,-1,-1,3,3,3,2,2,1,-3]},

Hexa152 : {
"name":"hexa#152 (mirror of #151, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [1,1,1], [2,1,0]],
"vertex":[[-0.5,-1,-1],[-0.5,-1,0],[1.5,1,0],[1.5,1,-1],[-0.5,0,1],[0.5,-1,-1],[0.5,-1,0],[-0.5,1,0],[0.5,0,1],[0.5,1,-1],[0.5,1,0],[-0.5,0,0],[-0.5,0,-1],[0.5,0,-1],[0.5,0,0],[-1.5,-1,-1],[-1.5,-1,0],[1.5,0,0],[1.5,0,-1],[-0.5,1,1],[-0.5,-1,1],[0.5,-1,1],[0.5,1,1],[-1.5,0,-1],[-1.5,0,0],[-0.5,1,-1]],
"edge":[[12,11],[18,17],[25,19],[10,2],[20,19],[12,25],[20,21],[23,12],[13,18],[13,14],[15,5],[1,20],[24,11],[14,17],[16,24],[15,23],[17,2],[1,11],[5,13],[25,3],[16,1],[18,3],[21,22],[3,2],[19,22],[5,21],[10,22],[14,10],[15,16],[23,24],[11,4],[7,10],[0,12],[12,13],[14,8],[0,1],[11,14],[11,7],[13,9],[1,6],[9,10],[6,14],[4,8]],
"numthickedges":30,
"face":[[16,24,23,15],[15,0,1,16],[0,5,6,1],[1,6,21,20],[24,11,12,23],[23,12,0,15],[12,13,5,0],[25,9,13,12],[9,3,18,13],[16,1,11,24],[14,17,2,10],[5,13,14,6],[6,14,8,21],[14,10,22,8],[20,4,11,1],[11,7,25,12],[4,19,7,11],[20,21,8,4],[4,8,22,19],[7,10,9,25],[19,22,10,7],[10,2,3,9],[18,3,2,17],[13,18,17,14]],
"facedirection":[-1,-2,-2,-2,2,-3,-3,-3,-3,3,3,1,1,1,-1,-1,-1,3,3,2,2,2,1,-2]},

Hexa153 : {
"name":"hexa#153 (mirror of #154, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,0,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[-1,0,1],[0,-1,-1],[0,-1,0],[-1,1,0],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[0,1,-1],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[2,-1,1],[-1,-1,1],[0,-1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[14,3],[21,3],[21,20],[1,6],[18,1],[5,2],[4,5],[27,6],[5,10],[26,7],[14,27],[7,23],[6,10],[11,10],[17,4],[20,23],[1,21],[18,26],[17,25],[3,23],[25,14],[27,11],[17,18],[25,26],[4,11],[2,20],[2,7],[1,5],[5,22],[0,14],[0,1],[14,16],[24,12],[16,8],[22,8],[9,24],[9,19],[19,12]],
"numthickedges":27,
"face":[[18,26,25,17],[17,0,1,18],[0,4,5,1],[1,5,22,21],[5,9,24,22],[9,2,20,24],[26,13,14,25],[3,8,15,13],[8,12,19,15],[12,23,7,19],[25,14,0,17],[14,16,4,0],[27,11,16,14],[18,1,13,26],[13,15,10,6],[4,16,15,5],[16,11,10,15],[21,3,13,1],[13,6,27,14],[21,22,8,3],[22,24,12,8],[24,20,23,12],[6,10,11,27],[15,19,9,5],[19,7,2,9],[2,7,23,20]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,3,3,1,1,-1,-1,3,3,3,2,-3,-3,1]},

Hexa154 : {
"name":"hexa#154 (mirror of #153, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[-1,0,1],[0,-1,-1],[0,-1,0],[-1,1,0],[2,0,0],[0,0,1],[2,0,-1],[0,1,-1],[0,1,0],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,0],[1,0,-1],[2,1,-1],[2,1,0],[-1,-1,1],[0,-1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[7,22],[14,4],[23,4],[1,7],[27,7],[26,8],[23,24],[14,27],[27,21],[21,22],[15,9],[17,5],[25,14],[15,10],[1,23],[18,26],[17,25],[4,9],[8,22],[5,15],[24,9],[10,8],[18,1],[10,21],[5,24],[17,18],[25,26],[0,14],[14,15],[0,1],[15,11],[1,6],[20,19],[11,12],[19,2],[20,3],[3,2],[6,12]],
"numthickedges":27,
"face":[[18,26,25,17],[17,0,1,18],[0,5,6,1],[1,6,24,23],[26,13,14,25],[4,9,16,13],[25,14,0,17],[14,15,5,0],[27,11,15,14],[11,3,20,15],[3,21,10,20],[18,1,13,26],[13,16,12,7],[16,19,2,12],[19,8,22,2],[5,15,16,6],[6,16,9,24],[23,4,13,1],[13,7,27,14],[23,24,9,4],[7,12,11,27],[12,2,3,11],[2,22,21,3],[15,20,19,16],[20,10,8,19],[10,21,22,8]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,-1,-1,3,2,2,2,-2,-2,1]},

Hexa155 : {
"name":"hexa#155 (mirror of #156, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[-1,0,1],[0,-1,0],[-1,1,0],[2,0,0],[0,0,1],[1,-1,-1],[0,1,0],[1,-1,0],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[-1,1,1],[-1,-1,1],[0,-1,1],[0,1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[17,27],[1,6],[18,1],[5,2],[6,21],[22,21],[5,10],[26,7],[22,23],[6,10],[1,22],[18,26],[17,25],[25,12],[2,7],[27,2],[12,7],[23,24],[21,24],[10,24],[17,18],[25,26],[5,23],[27,12],[1,5],[0,1],[3,5],[0,14],[14,4],[19,20],[9,19],[15,8],[9,11],[4,8],[3,15],[11,20]],
"numthickedges":24,
"face":[[18,26,25,17],[17,0,1,18],[0,3,5,1],[1,5,23,22],[3,9,11,5],[9,27,2,11],[26,13,14,25],[13,16,15,14],[16,20,19,15],[20,7,12,19],[25,14,0,17],[14,15,3,0],[15,19,9,3],[19,12,27,9],[18,1,13,26],[5,11,20,16],[11,2,7,20],[22,4,13,1],[4,21,6,13],[5,16,8,23],[16,10,24,8],[22,23,8,4],[4,8,24,21],[21,24,10,6],[6,10,16,13],[27,12,7,2]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,3,3,3,-1,-1,1,1,3,3,2,-3,1]},

Hexa156 : {
"name":"hexa#156 (mirror of #155, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [2,0,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[0,-1,0],[-1,1,-1],[-1,0,1],[-1,1,0],[2,0,0],[0,0,1],[1,-1,-1],[0,1,-1],[0,1,0],[1,-1,0],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[-1,1,1],[0,1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[16,6],[5,23],[26,8],[16,5],[20,2],[6,23],[17,9],[25,16],[17,14],[20,26],[19,25],[6,9],[5,11],[2,8],[27,2],[14,8],[11,24],[9,24],[23,24],[17,11],[19,20],[25,26],[27,14],[0,16],[16,17],[3,17],[21,22],[1,7],[3,4],[10,21],[7,12],[10,13],[0,1],[13,22],[4,12]],
"numthickedges":24,
"face":[[20,26,25,19],[19,0,1,20],[0,3,4,1],[3,10,13,4],[10,27,2,13],[26,15,16,25],[18,22,21,17],[22,8,14,21],[25,16,0,19],[16,17,3,0],[5,11,17,16],[17,21,10,3],[21,14,27,10],[20,1,15,26],[1,4,18,15],[4,13,22,18],[13,2,8,22],[15,7,5,16],[6,23,7,15],[17,11,12,18],[18,12,24,9],[7,12,11,5],[23,24,12,7],[15,18,9,6],[6,9,24,23],[27,14,8,2]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,-1,1,1,2,2,-2,3,1]},

Hexa157 : {
"name":"hexa#157 (mirror of #158, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,0,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[-1,0,1],[0,-1,-1],[0,-1,0],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[2,-1,1],[-1,1,1],[-1,-1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[-1,1,0]],
"edge":[[1,27],[16,1],[5,2],[27,19],[20,19],[4,5],[26,6],[6,23],[27,9],[14,7],[15,4],[18,23],[1,20],[16,26],[15,25],[4,14],[7,22],[25,14],[7,23],[19,22],[9,22],[5,9],[15,16],[25,26],[2,18],[20,18],[2,6],[1,5],[5,21],[0,1],[21,7],[3,7],[0,12],[12,3],[24,10],[8,24],[8,17],[17,10]],
"numthickedges":27,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[1,5,21,20],[5,8,24,21],[8,2,18,24],[26,11,12,25],[11,13,14,12],[7,10,17,13],[10,23,6,17],[25,12,0,15],[12,14,4,0],[16,1,11,26],[4,14,13,5],[13,9,22,7],[20,3,11,1],[3,19,27,11],[20,21,7,3],[3,7,22,19],[21,24,10,7],[24,18,23,10],[19,22,9,27],[27,9,13,11],[13,17,8,5],[17,6,2,8],[2,6,23,18]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,3,1,1,-1,-1,3,3,3,3,2,-3,-3,-3,1]},

Hexa158 : {
"name":"hexa#158 (mirror of #157, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[0,-1,0],[-1,0,1],[-1,1,0],[2,0,0],[0,0,1],[2,0,-1],[0,1,-1],[0,1,0],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,0],[1,0,-1],[-1,1,1],[2,1,-1],[2,1,0],[0,1,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[14,6],[27,21],[4,5],[18,5],[26,8],[14,27],[12,23],[27,22],[6,21],[15,9],[22,23],[17,4],[25,14],[15,10],[18,26],[17,25],[8,23],[6,9],[4,15],[10,8],[9,24],[21,24],[10,22],[12,24],[5,12],[17,18],[25,26],[0,14],[7,12],[14,15],[15,11],[11,12],[20,19],[1,7],[19,2],[0,1],[20,3],[3,2]],
"numthickedges":27,
"face":[[18,26,25,17],[17,0,1,18],[0,4,5,1],[26,13,14,25],[25,14,0,17],[14,15,4,0],[27,11,15,14],[11,3,20,15],[3,22,10,20],[18,1,13,26],[1,5,16,13],[16,19,2,12],[19,8,23,2],[4,15,16,5],[16,12,24,9],[13,7,27,14],[6,21,7,13],[7,12,11,27],[21,24,12,7],[12,2,3,11],[2,23,22,3],[13,16,9,6],[15,20,19,16],[20,10,8,19],[6,9,24,21],[10,22,23,8]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,-3,3,3,3,3,1,1,-1,-1,2,2,2,2,-2,-2,-2,3,1]},

Hexa159 : {
"name":"hexa#159 (mirror of #160, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [1,1,1], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,-1],[0,-1,0],[2,0,0],[0,0,1],[0,1,0],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[-1,1,1],[2,1,0],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[-2,0,-1],[-2,0,0],[-1,1,0]],
"edge":[[27,19],[1,27],[27,18],[20,18],[26,6],[20,22],[6,24],[24,10],[14,7],[15,4],[1,20],[16,26],[15,25],[6,19],[4,14],[22,7],[18,10],[25,14],[16,1],[7,24],[4,22],[19,10],[15,16],[25,26],[0,1],[7,23],[1,5],[3,7],[0,12],[12,3],[2,21],[9,21],[17,2],[8,23],[5,8],[17,9]],
"numthickedges":24,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[1,5,22,20],[26,11,12,25],[11,13,14,12],[25,12,0,15],[12,14,4,0],[16,1,11,26],[4,14,13,5],[5,13,7,22],[20,3,11,1],[3,18,27,11],[20,22,7,3],[3,7,23,18],[7,9,21,23],[9,24,10,21],[18,23,8,27],[23,21,2,8],[21,10,19,2],[27,8,13,11],[8,2,17,13],[2,19,6,17],[13,17,9,7],[17,6,24,9],[6,19,10,24]],
"facedirection":[-1,-2,-2,-2,2,2,-3,-3,3,1,1,-1,-1,3,3,3,3,2,2,2,-3,-3,-3,-2,-2,1]},

Hexa160 : {
"name":"hexa#160 (mirror of #159, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [1,1,1], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[0,-1,-1],[0,-1,0],[-1,0,1],[-1,1,0],[2,0,0],[0,0,1],[0,1,0],[0,1,-1],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[-1,1,1],[2,1,0],[1,1,1],[0,1,1],[2,0,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[14,5],[27,20],[3,4],[18,4],[4,9],[26,7],[14,27],[9,21],[7,24],[5,20],[24,12],[10,9],[17,3],[18,26],[17,25],[5,24],[25,14],[7,21],[27,10],[20,12],[21,12],[17,18],[25,26],[3,10],[0,14],[6,9],[9,23],[14,16],[1,6],[2,22],[11,22],[16,8],[19,2],[0,1],[8,23],[19,11]],
"numthickedges":24,
"face":[[18,26,25,17],[17,0,1,18],[0,3,4,1],[26,13,14,25],[25,14,0,17],[14,16,3,0],[27,10,16,14],[18,1,13,26],[1,4,15,13],[3,16,15,4],[16,10,9,15],[13,6,27,14],[5,20,6,13],[6,9,10,27],[20,23,9,6],[23,22,2,9],[22,12,21,2],[13,15,8,5],[15,19,11,8],[19,7,24,11],[5,8,23,20],[8,11,22,23],[11,24,12,22],[9,2,19,15],[2,21,7,19],[7,21,12,24]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,3,3,1,1,-1,-1,2,2,2,2,-2,-2,-2,3,3,3,-3,-3,1]},

Hexa161 : {
"name":"hexa#161 (mirror of #162, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [2,0,0], [2,1,0], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[-1,0,1],[0,-1,0],[2,0,0],[0,0,1],[1,-1,-1],[1,-1,0],[0,1,0],[0,1,-1],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[-1,-1,1],[0,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[21,22],[23,6],[12,3],[20,1],[7,2],[7,12],[23,24],[26,15],[22,8],[17,9],[13,12],[1,23],[20,26],[19,25],[22,3],[1,15],[6,9],[2,8],[27,2],[14,8],[24,9],[25,17],[21,14],[13,4],[21,4],[4,3],[15,6],[17,13],[19,20],[25,26],[7,24],[27,14],[1,7],[15,22],[0,1],[11,22],[17,21],[10,21],[16,15],[5,17],[5,7],[0,16],[10,11]],
"numthickedges":33,
"face":[[20,26,25,19],[19,0,1,20],[0,5,7,1],[1,7,24,23],[5,10,11,7],[10,27,2,11],[26,15,16,25],[15,18,17,16],[6,9,18,15],[22,8,14,21],[25,16,0,19],[16,17,5,0],[17,21,10,5],[13,4,21,17],[21,14,27,10],[20,1,15,26],[7,11,22,18],[18,22,3,12],[11,2,8,22],[23,6,15,1],[7,18,9,24],[23,24,9,6],[18,12,13,17],[21,4,3,22],[12,3,4,13],[27,14,8,2]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,1,3,-1,1,2,1]},

Hexa162 : {
"name":"hexa#162 (mirror of #161, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,0,0], [2,0,1], [3,0,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[2,-1,0],[0,-1,-1],[0,-1,0],[-1,1,-1],[-1,1,0],[2,0,0],[0,0,1],[1,-1,-1],[0,1,0],[0,1,-1],[1,-1,0],[2,0,-1],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[0,-1,1],[1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,-1]],
"edge":[[19,27],[16,15],[15,6],[8,14],[5,6],[20,4],[12,2],[4,10],[16,5],[24,14],[26,15],[22,7],[23,24],[6,10],[18,8],[11,10],[25,16],[18,13],[20,26],[19,25],[27,13],[5,11],[2,7],[27,2],[13,7],[12,24],[23,8],[12,22],[18,11],[19,20],[25,26],[4,23],[22,14],[1,15],[4,12],[0,16],[15,22],[16,18],[9,12],[3,18],[3,4],[21,22],[9,21],[0,1]],
"numthickedges":33,
"face":[[20,26,25,19],[19,0,1,20],[0,3,4,1],[3,9,12,4],[4,12,24,23],[9,27,2,12],[26,15,16,25],[17,22,21,18],[8,14,22,17],[22,7,13,21],[25,16,0,19],[16,18,3,0],[5,11,18,16],[18,21,9,3],[21,13,27,9],[20,1,15,26],[1,4,17,15],[15,17,10,6],[12,2,7,22],[15,6,5,16],[18,11,10,17],[6,10,11,5],[23,8,17,4],[12,22,14,24],[23,24,14,8],[27,13,7,2]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,1,2,-1,1,3,1]},

Hexa163 : {
"name":"hexa#163 (mirror of #164, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [2,0,0], [2,1,0], [3,1,0]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[-1,0,1],[0,-1,0],[2,0,0],[0,0,1],[1,-1,-1],[0,1,-1],[1,-1,0],[0,1,0],[2,0,-1],[-1,0,0],[-1,0,-1],[0,0,-1],[0,0,0],[-2,-1,-1],[-2,-1,0],[1,0,-1],[1,0,0],[2,1,-1],[2,1,0],[-1,-1,1],[0,-1,1],[-2,0,-1],[-2,0,0]],
"edge":[[18,9],[24,5],[20,21],[6,12],[24,25],[10,22],[12,23],[9,20],[27,14],[21,7],[9,11],[16,8],[10,12],[22,23],[1,24],[19,27],[18,26],[1,14],[5,8],[7,23],[25,8],[13,7],[26,16],[20,13],[19,1],[6,11],[11,21],[13,22],[14,5],[16,10],[18,19],[26,27],[6,25],[20,3],[14,21],[0,1],[16,20],[1,6],[21,2],[15,14],[4,16],[4,6],[0,15],[3,2]],
"numthickedges":33,
"face":[[19,27,26,18],[18,0,1,19],[0,4,6,1],[1,6,25,24],[4,9,11,6],[27,14,15,26],[14,17,16,15],[5,8,17,14],[26,15,0,18],[15,16,4,0],[16,20,9,4],[10,3,20,16],[3,22,13,20],[19,1,14,27],[6,11,21,17],[17,21,2,12],[21,7,23,2],[24,5,14,1],[6,17,8,25],[24,25,8,5],[9,20,21,11],[17,12,10,16],[12,2,3,10],[2,23,22,3],[13,22,23,7],[20,13,7,21]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,-3,-3,-3,3,3,3,3,-1,1,3,1,-1,2,2,1,-2]},

Hexa164 : {
"name":"hexa#164 (mirror of #163, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [2,0,1], [2,1,1], [3,0,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,-1],[0,-1,0],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[2,-1,1],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0],[2,-1,0]],
"edge":[[19,3],[9,2],[2,20],[16,1],[5,27],[4,5],[5,9],[6,23],[26,11],[17,6],[10,20],[14,7],[15,4],[18,23],[1,19],[16,26],[15,25],[17,2],[1,11],[3,7],[10,23],[27,6],[4,14],[7,22],[25,14],[22,20],[9,22],[11,3],[15,16],[25,26],[27,18],[19,18],[17,10],[1,5],[5,21],[11,17],[24,10],[0,1],[8,17],[7,10],[21,7],[12,11],[0,12],[8,24]],
"numthickedges":33,
"face":[[16,26,25,15],[15,0,1,16],[0,4,5,1],[1,5,21,19],[5,8,24,21],[8,27,18,24],[26,11,12,25],[11,13,14,12],[3,7,13,11],[10,23,6,17],[25,12,0,15],[12,14,4,0],[16,1,11,26],[4,14,13,5],[19,3,11,1],[19,21,7,3],[21,24,10,7],[7,10,20,22],[24,18,23,10],[13,17,8,5],[9,2,17,13],[17,6,27,8],[7,22,9,13],[17,2,20,10],[22,20,2,9],[27,6,23,18]],
"facedirection":[-1,-2,-2,-2,-2,-2,2,2,2,2,-3,-3,3,1,-1,3,3,3,3,-3,-3,-3,-1,1,2,1]},

Hexa165 : {
"name":"hexa#165 (mirror of #166, 1st)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,0,1], [2,0,1], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[-1,0,1],[0,-1,-1],[0,-1,0],[2,0,0],[0,0,1],[1,-1,0],[0,1,0],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[2,1,0],[-1,-1,1],[1,1,1],[0,-1,1],[0,1,1],[2,0,1],[1,-1,1],[-2,0,-1],[-2,0,0]],
"edge":[[20,3],[23,11],[4,5],[5,9],[25,10],[9,19],[6,24],[27,12],[18,6],[24,11],[15,7],[16,4],[1,20],[17,27],[16,26],[1,12],[3,7],[10,24],[6,19],[4,15],[8,25],[7,23],[26,15],[17,1],[5,8],[9,23],[12,3],[19,11],[16,17],[26,27],[8,18],[20,25],[18,10],[5,22],[10,21],[12,18],[0,1],[7,10],[22,7],[1,5],[13,12],[18,2],[0,13],[2,21]],
"numthickedges":33,
"face":[[17,27,26,16],[16,0,1,17],[0,4,5,1],[1,5,22,20],[5,8,25,22],[27,12,13,26],[12,14,15,13],[3,7,14,12],[26,13,0,16],[13,15,4,0],[17,1,12,27],[4,15,14,5],[20,3,12,1],[20,22,7,3],[22,25,10,7],[7,10,21,23],[10,24,11,21],[8,18,10,25],[14,18,8,5],[9,2,18,14],[2,19,6,18],[7,23,9,14],[23,21,2,9],[21,11,19,2],[6,19,11,24],[18,6,24,10]],
"facedirection":[-1,-2,-2,-2,-2,2,2,2,-3,-3,3,1,-1,3,3,3,3,1,-3,-3,-3,-1,2,2,1,-2]},

Hexa166 : {
"name":"hexa#166 (mirror of #165, 2nd)",
"category":["Hexacubes"],
"cell":[[0,0,0], [1,0,0], [1,1,0], [2,1,0], [2,1,1], [3,1,1]],
"vertex":[[-1,-1,-1],[-1,-1,0],[1,1,0],[1,1,-1],[0,-1,-1],[0,-1,0],[-1,1,0],[2,0,0],[0,0,1],[0,1,0],[0,1,-1],[1,0,1],[2,1,1],[-1,0,0],[-1,0,-1],[0,0,0],[0,0,-1],[-2,-1,-1],[-2,-1,0],[1,0,0],[1,0,-1],[2,1,0],[1,1,1],[0,1,1],[2,0,1],[-2,0,-1],[-2,0,0],[-1,1,-1]],
"edge":[[14,13],[20,19],[23,12],[13,6],[4,5],[27,6],[18,5],[5,9],[14,27],[7,24],[26,13],[19,7],[25,14],[16,20],[6,9],[2,21],[24,12],[16,8],[17,4],[18,26],[17,25],[19,2],[7,21],[4,16],[8,23],[27,3],[20,3],[8,24],[3,2],[9,23],[21,12],[17,18],[25,26],[19,11],[1,13],[0,14],[13,19],[14,16],[9,2],[16,10],[2,22],[10,9],[11,22],[0,1]],
"numthickedges":33,
"face":[[18,26,25,17],[17,0,1,18],[0,4,5,1],[26,13,14,25],[25,14,0,17],[14,16,4,0],[27,10,16,14],[10,3,20,16],[18,1,13,26],[1,5,15,13],[13,15,9,6],[4,16,15,5],[13,6,27,14],[6,9,10,27],[9,2,3,10],[23,22,2,9],[22,12,21,2],[20,3,2,19],[16,20,19,15],[15,19,11,8],[19,7,24,11],[8,23,9,15],[8,11,22,23],[11,24,12,22],[7,21,12,24],[2,21,7,19]],
"facedirection":[-1,-2,-2,2,-3,-3,-3,-3,3,3,3,1,-1,2,2,2,2,1,-2,-2,-2,-1,3,3,1,-3]},
};
