/**
 * Data handmade by Don Knuth using 3D-TO-JSON
 */
 
POLYHEDRA = {

C1 : {
"name":"C1",
"category":["Graph Realizations"],
"vertex":[[1.5,1.5,1.5],[1.5,-1.5,-1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5]],
"edge":[[0,1],[1,2],[0,2],[0,3],[2,3],[1,3]],
"face":[[0,1,2],[0,2,3],[0,3,1],[1,3,2]]},

C2 : {
"name":"C2",
"category":["Graph Realizations"],
"vertex":[[1.5,0,0],[0,1.5,0],[0,0,1.5],[0,-1.5,-1.5],[-1.5,0,-1.5],[-1.5,-1.5,0]],
"edge":[[0,1],[1,2],[0,2],[0,3],[3,5],[2,5],[4,5],[1,4],[3,4]],
"face":[[0,1,2],[3,5,4],[0,3,4,1],[1,4,5,2],[2,5,3,0]]},

C2A : {
"name":"C2A",
"category":["Graph Realizations"],
"vertex":[[1,-1.5,-1.5],[-1,0.5,-1.5],[-1,-1.5,0.5],[1,1.5,1.5],[0,0.5,-0.5],[0,-0.5,0.5]],
"edge":[[0,1],[1,2],[0,2],[0,3],[3,5],[2,5],[4,5],[1,4],[3,4]],
"face":[[0,1,2],[3,5,4],[1,0,4],[3,4,0],[2,5,0],[3,0,5],[1,4,5,2]]},

C4A1 : {
"name":"C4A1",
"category":["Graph Realizations"],
"vertex":[[1.5,-1.5,-1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5],[0,1.5,0],[0,0,1.5],[1.5,-0.75,-0.75],[0.75,0.75,0],[0.75,0,0.75]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,3,4],[4,3,6,7],[0,2,4,7,5],[5,6,3,1,0]]},

C4A2 : {
"name":"C4A2",
"category":["Graph Realizations"],
"vertex":[[1.5,-1.5,-1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5],[0,1.5,0],[0,0,1.5],[1.5,0.75,0.75],[0.75,0.75,0],[0.75,0,0.75]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[7,5,0],[7,0,2],[7,2,4],[6,0,5],[6,1,0],[6,3,1]]},

C4B11 : {
"name":"C4B11",
"category":["Graph Realizations"],
"vertex":[[1.2,-1.5,-1.5],[-1.2,0.9,-1.5],[-1.2,-1.5,0.9],[0,0.9,-0.3],[0,-0.3,0.9],[1.2,0.3,0.3],[0.6,1.5,0.9],[0.6,0.9,1.5]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[0,2,4],[0,4,7,5],[0,3,1],[0,5,6,3]]},

C4B12 : {
"name":"C4B12",
"category":["Graph Realizations"],
"vertex":[[0.666667,-1.5,-1.5],[-0.666667,-0.166667,-1.5],[-0.666667,-1.5,-0.166667],[0,-0.166667,-0.833333],[0,-0.833333,-0.166667],[0.666667,1.5,1.5],[0.333333,0.166667,-0.166667],[0.333333,-0.166667,0.166667]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[0,2,4],[0,4,7,5],[0,3,1],[0,5,6,3]]},

C4B13 : {
"name":"C4B13",
"category":["Graph Realizations"],
"vertex":[[0.5625,-1.5,-1.3125],[-0.9375,0,-1.3125],[-0.9375,-1.5,0.1875],[-0.1875,0,-0.5625],[-0.1875,-0.75,0.1875],[0.5625,-0.375,-0.1875],[0.1875,0.375,0.1875],[0.9375,1.5,1.3125]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[4,2,1,3],[4,6,7],[3,6,4],[0,5,3,1],[5,6,3],[0,2,4,5],[5,4,7]]},

C4B21 : {
"name":"C4B21",
"category":["Graph Realizations"],
"vertex":[[0.5,-1,-1.5],[-1.5,1,-1.5],[-1.5,-1,0.5],[1.5,1,1.5],[-0.5,0,0.5],[0.5,-0.5,-1],[1,0.5,0.5],[0,0,0]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,6,7],[4,3,6],[7,5,0],[7,0,2],[7,2,4],[6,3,1],[6,1,5],[5,1,0]]},

C4B22 : {
"name":"C4B22",
"category":["Graph Realizations"],
"vertex":[[0.642857,-1.07143,-1.5],[-1.5,1.07143,-1.5],[-1.5,-1.07143,0.642857],[1.5,1.07143,1.5],[-0.214286,0.214286,0.642857],[0.642857,-0.3,-0.728571],[0.3,-0.128571,-0.9],[0.3,0.214286,0.128571]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[7,5,0],[7,0,2],[7,2,4],[6,0,5],[6,1,0],[6,3,1]]},

C4B23 : {
"name":"C4B23",
"category":["Graph Realizations"],
"vertex":[[0.5,-1,-1.5],[-1.5,1,-1.5],[-1.5,-1,0.5],[1.5,1,1.5],[-0.5,0,0.5],[0.5,0.5,0],[1,0.5,0.5],[0,0,0]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[7,5,0],[7,0,2],[7,2,4],[1,0,5],[3,1,5],[6,3,5]]},

C4B32 : {
"name":"C4B32",
"category":["Graph Realizations"],
"vertex":[[0.666667,1.5,1.5],[0,0.833333,0.166667],[0,0.166667,0.833333],[-0.666667,0.833333,-0.5],[-0.666667,-0.5,0.833333],[0.666667,-1.5,-1.5],[0,0.166667,-0.5],[0,-0.5,0.166667]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[2,1,4],[4,1,3],[4,3,7],[7,3,6],[7,5,0],[7,0,2],[7,2,4],[6,0,5],[6,1,0],[6,3,1]]},

C4B41 : {
"name":"C4B41",
"category":["Graph Realizations"],
"vertex":[[0.5,0,-0.5],[1.5,1,1.5],[-0.5,0,0.5],[-1.5,1,-1.5],[-1.5,-1,0.5],[0.5,-0.5,-1],[-0.5,0,-1.5],[-0.5,-1,-0.5]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[1,3,2],[2,3,4],[3,4,7,6],[7,5,0],[7,0,2],[7,2,4],[6,0,5],[6,1,0],[6,3,1]]},

C4B42 : {
"name":"C4B42",
"category":["Graph Realizations"],
"vertex":[[0.428571,0.214286,-0.214286],[1.28571,1.07143,1.5],[-0.428571,0.214286,0.642857],[-1.28571,1.07143,-1.07143],[-1.28571,-0.642857,0.642857],[0.428571,-1.07143,-1.5],[-0.428571,0.214286,-1.07143],[-0.428571,-0.642857,-0.214286]],
"edge":[[0,1],[1,2],[0,2],[0,5],[5,7],[4,7],[2,4],[3,4],[1,3],[3,6],[5,6],[6,7]],
"face":[[0,1,2],[7,6,5],[1,3,2],[3,4,2],[4,3,7],[7,3,6],[7,5,0],[7,0,2],[7,2,4],[6,0,5],[6,1,0],[6,3,1]]},

C4B51 : {
"name":"C4B51",
"category":["Graph Realizations"],
"vertex":[[0.75,-0.75,-1.125],[-0.75,0.75,-1.125],[0.75,1.5,1.125],[0,0.75,-0.375],[0,0,0.375],[0,-0.75,-0.375],[-0.75,-1.5,1.125],[-0.375,-0.375,0.375]],
"edge":[[5,6],[6,7],[5,7],[0,2],[2,4],[4,7],[0,5],[1,6],[0,1],[1,3],[2,3],[3,4]],
"face":[[5,6,7],[2,4,3],[5,1,6],[1,5,0],[0,2,3,1],[0,5,7],[7,4,0],[4,2,0],[1,7,6],[7,1,4],[4,1,3]]},

C4B52 : {
"name":"C4B52",
"category":["Graph Realizations"],
"vertex":[[1.5,-1.5,-1.5],[-0.5,0.5,-1.5],[1.5,1.5,1.5],[0.5,0.5,-0.5],[0.5,-0.5,0.5],[-1.5,-1.5,1.5],[-0.5,-0.5,-0.5],[0,-1,0.5]],
"edge":[[5,6],[6,7],[5,7],[0,2],[2,4],[4,7],[0,5],[1,6],[0,1],[1,3],[2,3],[3,4]],
"face":[[5,6,7],[2,4,3],[0,1,6],[0,6,5],[0,2,3,1],[0,5,7],[7,4,0],[4,2,0],[1,7,6],[7,1,4],[4,1,3]]},

C6A : {
"name":"C6A",
"category":["Graph Realizations"],
"vertex":[[-0.75,0.75,0.75],[-1.5,0.75,0.75],[0,0.75,-0.75],[1.5,0.75,0.75],[0.75,0.75,0.75],[0,0.75,0],[0,0,0.75],[0,-0.75,0.75]],
"edge":[[0,1],[1,7],[3,7],[3,4],[4,6],[0,6],[0,5],[5,6],[4,5],[1,2],[2,3],[2,7]],
"face":[[0,1,7,6],[4,6,7,3],[0,5,2,1],[4,3,2,5],[0,6,5],[4,5,6],[1,2,7],[3,7,2]]},

C6B : {
"name":"C6B",
"category":["Graph Realizations"],
"vertex":[[-1,0,0.5],[-0.5,0,0.5],[0,1.5,0.5],[0.5,0,0.5],[1,0,0.5],[0,-1.5,0.5],[0,-1,-0.5],[0,-0.5,0]],
"edge":[[0,1],[1,2],[2,3],[3,4],[4,5],[0,5],[0,6],[5,6],[4,6],[1,7],[3,7],[2,7]],
"face":[[0,1,5],[5,1,2],[2,3,5],[5,3,4],[0,7,1],[0,6,7],[6,4,7],[4,3,7],[1,7,2],[7,3,2],[0,5,6],[6,5,4]]},

C8A : {
"name":"C8A",
"category":["Graph Realizations"],
"vertex":[[1.5,0,0.075],[0,1.5,0.075],[0,-1.5,-1.425],[-1.5,0,-1.425],[0.15,0,1.425],[0,0.15,1.425],[-1.35,-1.5,-0.075],[-1.5,-1.35,-0.075]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,4],[4,6],[2,6],[6,7],[3,7],[5,7],[1,5],[4,5]],
"face":[[0,1,3,2],[1,5,7,3],[0,2,6,4],[0,4,5,1],[2,3,7,6],[5,4,6,7]]},

C8B : {
"name":"C8B",
"category":["Graph Realizations"],
"vertex":[[1.5,0,-0.0714286],[0.0714286,1.42857,-0.0714286],[0.0714286,-1.42857,-1.5],[-1.35714,0,-1.5],[-0.0714286,0,1.5],[0.0714286,0.142857,1.21429],[-1.5,-1.42857,0.0714286],[-1.35714,-1.28571,-0.214286]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,4],[4,6],[2,6],[6,7],[3,7],[5,7],[1,5],[4,5]],
"face":[[0,1,3,2],[1,5,7,3],[0,2,6,4],[0,4,5,1],[2,3,7,6],[5,4,6,7]]},

C8C : {
"name":"C8C",
"category":["Graph Realizations"],
"vertex":[[1.5,1.5,1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5],[-0.5,0.5,0.5],[1.5,-1.2,-1.2],[1.2,-1.2,-1.5],[0.7,-0.4,0.4],[0.2,-0.2,0.5]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,4],[4,6],[2,6],[6,7],[3,7],[5,7],[1,5],[4,5]],
"face":[[0,3,1],[3,0,2],[1,3,7,5],[0,6,2],[6,0,4],[0,1,5,4],[2,7,3],[7,2,6],[5,7,6,4]]},

C8D : {
"name":"C8D",
"category":["Graph Realizations"],
"vertex":[[1.36364,1.5,1.5],[-1.36364,1.5,-1.22727],[-1.36364,-1.22727,1.5],[-0.454545,0.590909,0.590909],[1.36364,-1.5,-1.5],[1.09091,-0.954545,-1.22727],[0.272727,-0.409091,0.681818],[0.181818,-0.0454545,0.590909]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,4],[4,6],[2,6],[6,7],[3,7],[5,7],[1,5],[4,5]],
"face":[[0,3,1],[3,0,2],[0,6,2],[6,0,4],[0,1,5,4],[2,7,3],[7,2,6],[5,7,6,4],[5,1,3,7]]},

C15 : {
"name":"C15",
"category":["Graph Realizations"],
"vertex":[[-0.176803,0,1.5],[1.23762,0,-0.5],[-0.884017,1.22489,-0.5],[-0.884017,-1.22489,-0.5],[0.884017,0.612447,-1.5],[-0.176803,1.22489,-1.5],[-1.23762,0.612447,-1.5],[-1.23762,-0.612447,-1.5],[-0.176803,-1.22489,-1.5],[0.884017,-0.612447,-1.5]],
"edge":[[0,1],[1,4],[4,5],[2,5],[0,2],[0,3],[3,7],[6,7],[2,6],[5,6],[7,8],[8,9],[4,9],[1,9],[3,8]],
"face":[[0,1,4,5,2],[0,2,6,7,3],[0,3,8,9,1],[1,9,4],[2,5,6],[3,7,8],[5,6,7,8],[8,9,4,5]]},

C16 : {
"name":"C16",
"category":["Graph Realizations"],
"vertex":[[-1.5,-1.5,1.5],[-1.5,1.5,-1.5],[-1.5,1.5,1.5],[1.5,-1.5,-1.5],[1.5,-1.5,1.5],[1.5,1.5,-1.5],[1.5,1.5,1.5],[-1.5,-1.5,0],[-1.5,0,-1.5],[0,-1.5,-1.5]],
"edge":[[0,2],[2,6],[4,6],[0,4],[0,7],[7,9],[3,9],[3,4],[3,5],[5,6],[1,5],[1,2],[1,8],[7,8],[8,9]],
"face":[[0,2,6,4],[3,4,6,5],[6,2,1,5],[2,0,7,8,1],[4,3,9,7,0],[1,8,9,3,5],[7,9,8]]},

C16c : {
"name":"C16c",
"category":["Graph Realizations"],
"vertex":[[0,0.75,1],[0.5,0.25,1],[-0.5,0.25,1],[0,-0.25,1],[0.5,0.25,0.5],[-0.5,0.25,0.5],[0,-0.25,0.5],[-1.5,-0.75,0.5],[1.5,-0.75,0.5],[0,0.75,-1]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,9],[7,9],[5,7],[2,5],[5,6],[3,6],[4,6],[1,4],[4,8],[8,9],[7,8]],
"face":[[0,1,3,2],[1,4,6,3],[2,3,6,5],[4,8,6],[5,6,7],[6,8,7],[0,2,5],[9,5,7],[5,9,0],[0,9,1],[1,9,4],[4,9,8],[8,9,7]]},

C23 : {
"name":"C23",
"category":["Graph Realizations"],
"vertex":[[1.42666,0,-0.788644],[0.336751,1.5,-0.788644],[-1.42666,0.927445,-0.788644],[-1.42666,-0.927445,-0.788644],[0.336751,-1.5,-0.788644],[1.42666,0,0.788644],[0.336751,1.5,0.788644],[-1.42666,0.927445,0.788644],[-1.42666,-0.927445,0.788644],[0.336751,-1.5,0.788644]],
"edge":[[0,1],[1,2],[2,3],[3,4],[0,4],[0,5],[5,9],[4,9],[8,9],[3,8],[7,8],[2,7],[6,7],[1,6],[5,6]],
"face":[[0,1,2,3,4],[5,9,8,7,6],[0,5,6,1],[1,6,7,2],[2,7,8,3],[3,8,9,4],[4,9,5,0]]},

C1C2 : {
"name":"C1C2",
"category":["Graph Realizations"],
"vertex":[[1.5,1.5,1.5],[1.5,-1.5,-1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5],[0.75,0.75,0],[0.75,0,-0.75],[0,0.75,-0.75],[0,0.75,0.75],[-0.75,0,0.75],[-0.75,0.75,0]],
"edge":[[0,1],[1,3],[0,3],[0,2],[2,3],[1,2],[4,5],[5,8],[7,8],[4,7],[6,9],[7,9],[4,6],[5,6],[8,9]],
"face":[[0,1,3],[1,2,3],[4,5,8,7],[5,6,9,8],[6,4,7,9],[0,1,5,4],[0,4,6,2],[1,2,6,5],[0,7,8,3],[0,2,9,7],[2,3,8,9]]},

Tower1123 : {
"name":"Tower1123",
"category":["Handmade"],
"vertex":[[-1,-1,-1.5],[1,-1,-1.5],[-1,1,-1.5],[1,1,-1.5],[-1,-1,-0.5],[1,-1,-0.5],[-1,0,-0.5],[1,0,-0.5],[-1,0,0.5],[0,0,0.5],[-1,1,0.5],[0,1,0.5],[0,0,1.5],[1,0,1.5],[0,1,1.5],[1,1,1.5]],
"edge":[[0,1],[1,3],[2,3],[0,2],[0,4],[4,6],[6,8],[8,10],[2,10],[10,11],[11,14],[14,15],[3,15],[13,15],[7,13],[5,7],[1,5],[4,5],[6,7],[12,13],[9,12],[8,9],[9,11],[12,14]],
"face":[[0,1,3,2],[4,6,7,5],[8,10,11,9],[12,14,15,13],[0,4,5,1],[6,8,9,7],[9,12,13,7],[2,3,11,10],[11,3,15,14],[0,2,6,4],[6,2,10,8],[5,7,3,1],[3,7,13,15],[9,12,14,11]]},

Sphinx : {
"name":"Sphinx",
"category":["Handmade"],
"vertex":[[-1.46,-0.3,-0.57],[-1.5,-0.25,-0.57],[-1.46,-0.2,-0.57],[-1.5,-0.15,-0.57],[-1.46,-0.1,-0.57],[-1.46,0.1,-0.57],[-1.5,0.15,-0.57],[-1.46,0.2,-0.57],[-1.5,0.25,-0.57],[-1.46,0.3,-0.57],[-0.6,-0.1,-0.57],[-0.6,0.1,-0.57],[-0.06,-0.3,-0.57],[-0.06,0.3,-0.57],[1.5,-0.18,-0.57],[1.5,0.18,-0.57],[-1.46,-0.3,-0.42],[-1.5,-0.25,-0.42],[-1.46,-0.2,-0.42],[-1.5,-0.15,-0.42],[-1.46,-0.1,-0.42],[-1.46,0.1,-0.42],[-1.5,0.15,-0.42],[-1.46,0.2,-0.42],[-1.5,0.25,-0.42],[-1.46,0.3,-0.42],[-0.54,-0.3,-0.42],[-0.54,-0.1,-0.42],[-0.54,0.1,-0.42],[-0.54,0.3,-0.42],[-0.4,-0.3,-0.07],[-0.4,0.3,-0.07],[-0.06,-0.3,-0.07],[-0.06,0.3,-0.07],[1.24,-0.2,-0.17],[1.24,0.2,-0.17],[0.2,-0.28,-0.07],[0.2,0.28,-0.07],[-0.36,-0.1,-0.07],[-0.18,-0.1,0.01],[-0.36,-0.1,0.13],[-0.42,-0.1,0.1566],[-0.36,-0.1,0.41],[-0.28,-0.1,0.41],[-0.32,-0.1,0.4634],[-0.24,-0.1,0.5434],[-0.18,-0.1,0.5434],[-0.18,-0.36,0.1034],[-0.18,-0.16,0.57],[0.08,-0.1,-0.07],[0.08,-0.1,0.01],[0.08,-0.36,0.1034],[0.08,-0.16,0.57],[-0.36,0.1,-0.07],[-0.18,0.1,0.01],[-0.36,0.1,0.13],[-0.42,0.1,0.1566],[-0.36,0.1,0.41],[-0.28,0.1,0.41],[-0.32,0.1,0.4634],[-0.24,0.1,0.5434],[-0.18,0.1,0.5434],[-0.18,0.36,0.1034],[-0.18,0.16,0.57],[0.08,0.1,-0.07],[0.08,0.1,0.01],[0.08,0.36,0.1034],[0.08,0.16,0.57]],
"edge":[[0,1],[1,17],[16,17],[0,16],[0,12],[12,32],[30,32],[26,30],[16,26],[26,27],[20,27],[19,20],[18,19],[17,18],[2,18],[1,2],[2,3],[3,4],[4,10],[10,11],[5,11],[5,6],[6,7],[7,8],[8,9],[9,13],[13,15],[14,15],[12,14],[14,34],[34,36],[32,36],[30,31],[36,37],[33,37],[31,33],[9,25],[25,29],[29,31],[13,33],[35,37],[15,35],[34,35],[10,27],[28,29],[11,28],[21,28],[5,21],[21,22],[6,22],[22,23],[7,23],[23,24],[8,24],[24,25],[4,20],[3,19],[38,40],[40,55],[53,55],[38,53],[38,49],[49,64],[53,64],[64,65],[54,65],[54,61],[60,61],[59,60],[58,59],[57,58],[56,57],[55,56],[41,56],[40,41],[41,42],[42,43],[43,44],[44,45],[45,46],[39,46],[39,50],[49,50],[50,51],[51,52],[52,67],[66,67],[65,66],[62,66],[54,62],[46,61],[62,63],[48,63],[47,48],[39,47],[47,51],[48,52],[63,67],[45,60],[44,59],[43,58],[42,57]],
"face":[[0,1,17,16],[1,2,18,17],[2,3,19,18],[3,4,20,19],[4,10,27,20],[26,29,31,30],[27,10,11,28],[11,5,21,28],[5,6,22,21],[6,7,23,22],[7,8,24,23],[8,9,25,24],[9,13,29,25],[13,33,31,29],[0,16,26,12],[12,26,30,32],[12,32,36,34,14],[14,34,35,15],[13,15,35,37,33],[31,33,37,36,32,30],[16,17,18,26],[20,27,18,19],[26,18,27],[21,22,23,28],[25,29,23,24],[28,23,29],[36,37,35,34],[38,40,55,53],[40,41,56,55],[41,42,57,56],[42,43,58,57],[43,44,59,58],[44,45,60,59],[45,46,61,60],[38,49,50,39],[38,39,40],[39,46,43,40],[40,43,42,41],[43,46,45,44],[53,54,65,64],[53,55,54],[54,55,58,61],[55,56,57,58],[58,59,60,61],[49,64,65,50],[50,65,66,51],[51,66,67,52],[39,50,51,47],[47,51,52,48],[54,62,66,65],[62,63,67,66],[48,52,67,63],[39,47,48,46],[54,61,63,62],[61,46,48,63],[38,53,64,49]]},

Clasp : {
"name":"Clasp",
"category":["Handmade"],
"vertex":[[0.409091,0.954545,0.954545],[-1.5,0.954545,-0.954545],[0.409091,-0.954545,-0.954545],[-1.5,-0.954545,0.954545],[-0.954545,0.681818,-0.681818],[0.136364,-0.409091,-0.681818],[0.136364,0.681818,0.409091],[-0.954545,-0.681818,0.681818],[0.136364,-0.681818,-0.409091],[0.136364,0.409091,0.681818],[-0.409091,0.954545,-0.954545],[1.5,0.954545,0.954545],[-0.409091,-0.954545,0.954545],[1.5,-0.954545,-0.954545],[0.954545,0.681818,0.681818],[-0.136364,-0.409091,0.681818],[-0.136364,0.681818,-0.409091],[0.954545,-0.681818,-0.681818],[-0.136364,-0.681818,0.409091],[-0.136364,0.409091,-0.681818]],
"edge":[[0,1],[1,2],[0,2],[0,3],[2,3],[1,3],[4,5],[5,6],[4,6],[4,7],[7,9],[6,9],[8,9],[5,8],[7,8],[10,11],[11,12],[10,12],[10,13],[12,13],[11,13],[14,15],[15,16],[14,16],[14,17],[17,19],[16,19],[18,19],[15,18],[17,18]],
"face":[[0,6,4,1],[1,4,5,2],[2,5,6,0],[0,1,3],[0,9,8,2],[2,8,7,3],[3,7,9,0],[1,2,3],[5,4,7,8],[6,5,8,9],[4,6,9,7],[10,16,14,11],[11,14,15,12],[12,15,16,10],[10,11,13],[10,19,18,12],[12,18,17,13],[13,17,19,10],[11,12,13],[15,14,17,18],[16,15,18,19],[14,16,19,17]]},

Szilassi : {
"name":"Szilassi",
"category":["Handmade"],
"vertex":[[-1.42857,0,1.42857],[-0.833333,0,0.238095],[0.446429,0.446429,-0.357143],[0,1.5,-1.42857],[0.238095,-0.595238,-0.952381],[0.535714,-0.297619,0.238095],[0.833333,0.297619,0.238095],[1.42857,0,1.42857],[0.833333,0,0.238095],[-0.446429,-0.446429,-0.357143],[0,-1.5,-1.42857],[-0.238095,0.595238,-0.952381],[-0.535714,0.297619,0.238095],[-0.833333,-0.297619,0.238095]],
"edge":[[0,11],[2,11],[2,12],[6,12],[6,7],[0,7],[0,13],[5,13],[5,9],[4,9],[4,7],[3,8],[6,8],[4,10],[3,10],[3,11],[1,10],[1,13],[1,12],[5,8],[2,9]],
"face":[[11,2,12],[11,12,0],[0,12,6,7],[3,11,10],[10,11,1],[1,11,0],[1,0,13],[9,4,10],[9,10,1],[9,1,12,2],[2,11,3],[2,3,8],[2,8,5,9],[10,4,3],[3,4,8],[8,4,7],[8,7,6],[4,9,5],[4,5,7],[7,5,13,0],[1,13,5,8,6,12]]},

Histoscape8x8old : {
"name":"Histoscape8x8old",
"category":["Handmade"],
"vertex":[[-1.33333,-1.33333,-1.5],[-1.33333,-1.33333,0.166667],[-1.33333,-1,-0.166667],[-1.33333,-1,0.166667],[-1.33333,-0.666667,-0.833333],[-1.33333,-0.666667,-0.166667],[-1.33333,-0.333333,-0.833333],[-1.33333,-0.333333,-0.5],[-1.33333,0,-0.833333],[-1.33333,0,-0.5],[-1.33333,0.666667,-0.833333],[-1.33333,0.666667,0.5],[-1.33333,1,-0.5],[-1.33333,1,0.5],[-1.33333,1.33333,-1.5],[-1.33333,1.33333,-0.5],[-1,-1.33333,0.166667],[-1,-1.33333,0.5],[-1,-1,-0.166667],[-1,-1,0.166667],[-1,-1,0.5],[-1,-1,0.833333],[-1,-0.666667,-0.833333],[-1,-0.666667,-0.166667],[-1,-0.666667,0.833333],[-1,-0.666667,1.5],[-1,-0.333333,-0.833333],[-1,-0.333333,-0.5],[-1,-0.333333,1.16667],[-1,-0.333333,1.5],[-1,0,-0.833333],[-1,0,-0.5],[-1,0.666667,-0.833333],[-1,0.666667,0.5],[-1,0.666667,0.833333],[-1,0.666667,1.16667],[-1,1,-1.5],[-1,1,-0.5],[-1,1,0.5],[-1,1,0.833333],[-1,1.33333,-1.5],[-1,1.33333,-0.5],[-0.666667,-1.33333,0.166667],[-0.666667,-1.33333,0.5],[-0.666667,-1,-1.16667],[-0.666667,-1,0.166667],[-0.666667,-1,0.5],[-0.666667,-1,0.833333],[-0.666667,-0.666667,0.833333],[-0.666667,-0.666667,1.5],[-0.666667,-0.333333,-1.16667],[-0.666667,-0.333333,0.5],[-0.666667,-0.333333,1.16667],[-0.666667,-0.333333,1.5],[-0.666667,0,-0.166667],[-0.666667,0,0.5],[-0.666667,0.333333,-0.166667],[-0.666667,0.333333,0.833333],[-0.666667,0.666667,0.833333],[-0.666667,0.666667,1.16667],[-0.666667,1,-1.5],[-0.666667,1,0.833333],[-0.666667,1.33333,-1.5],[-0.666667,1.33333,0.833333],[-0.333333,-1,-1.16667],[-0.333333,-1,-0.5],[-0.333333,-0.666667,-0.5],[-0.333333,-0.666667,1.5],[-0.333333,-0.333333,-1.16667],[-0.333333,-0.333333,0.5],[-0.333333,0,-1.16667],[-0.333333,0,-0.166667],[-0.333333,0,0.5],[-0.333333,0,1.5],[-0.333333,0.333333,-1.16667],[-0.333333,0.333333,-0.166667],[-0.333333,0.666667,0.5],[-0.333333,0.666667,0.833333],[-0.333333,1,-0.833333],[-0.333333,1,0.5],[-0.333333,1.33333,-0.833333],[-0.333333,1.33333,0.833333],[0,-1,-0.5],[0,-1,-0.166667],[0,-0.666667,-0.5],[0,-0.666667,-0.166667],[0,-0.666667,0.166667],[0,-0.666667,1.5],[0,-0.333333,0.166667],[0,-0.333333,0.833333],[0,0,0.833333],[0,0,1.5],[0,0.333333,-1.16667],[0,0.333333,0.833333],[0,0.666667,-1.16667],[0,0.666667,-0.166667],[0,0.666667,0.5],[0,0.666667,0.833333],[0,1,-0.166667],[0,1,0.5],[0.333333,-1.33333,0.166667],[0.333333,-1.33333,0.833333],[0.333333,-1,-0.166667],[0.333333,-1,0.166667],[0.333333,-1,0.833333],[0.333333,-1,1.5],[0.333333,-0.666667,-0.166667],[0.333333,-0.666667,0.166667],[0.333333,-0.666667,0.5],[0.333333,-0.666667,1.5],[0.333333,-0.333333,0.166667],[0.333333,-0.333333,0.5],[0.333333,0.333333,-1.16667],[0.333333,0.333333,0.833333],[0.333333,0.666667,-1.16667],[0.333333,0.666667,-0.166667],[0.333333,1,-1.16667],[0.333333,1,-0.833333],[0.333333,1,-0.166667],[0.333333,1,0.833333],[0.333333,1.33333,-1.16667],[0.333333,1.33333,-0.833333],[0.666667,-1.33333,0.166667],[0.666667,-1.33333,0.833333],[0.666667,-1,-0.833333],[0.666667,-1,0.166667],[0.666667,-1,0.833333],[0.666667,-1,1.5],[0.666667,-0.666667,-0.833333],[0.666667,-0.666667,0.166667],[0.666667,-0.666667,0.5],[0.666667,-0.666667,1.5],[0.666667,-0.333333,0.166667],[0.666667,-0.333333,0.5],[0.666667,0,-1.16667],[0.666667,0,-0.833333],[0.666667,0.333333,-1.16667],[0.666667,0.333333,-0.833333],[0.666667,0.333333,-0.166667],[0.666667,0.333333,0.833333],[0.666667,0.666667,-0.166667],[0.666667,0.666667,0.166667],[0.666667,1,-1.16667],[0.666667,1,-0.833333],[0.666667,1,0.166667],[0.666667,1,0.833333],[0.666667,1.33333,-1.16667],[0.666667,1.33333,-0.833333],[1,-1.33333,-0.5],[1,-1.33333,0.166667],[1,-1,-0.5],[1,-1,0.166667],[1,-0.666667,0.166667],[1,-0.666667,1.5],[1,-0.333333,0.166667],[1,-0.333333,0.833333],[1,0,0.833333],[1,0,1.5],[1,0.333333,-0.5],[1,0.333333,-0.166667],[1,0.666667,-0.5],[1,0.666667,-0.166667],[1,0.666667,0.166667],[1,0.666667,0.5],[1,1,-1.5],[1,1,-0.833333],[1,1,0.166667],[1,1,0.5],[1,1.33333,-1.5],[1,1.33333,-0.833333],[1.33333,-1.33333,-1.5],[1.33333,-1.33333,-0.5],[1.33333,-1,-0.833333],[1.33333,-1,-0.5],[1.33333,-0.666667,-0.833333],[1.33333,-0.666667,1.5],[1.33333,0,-0.833333],[1.33333,0,1.5],[1.33333,0.333333,-0.833333],[1.33333,0.333333,-0.5],[1.33333,0.666667,-0.5],[1.33333,0.666667,0.5],[1.33333,1,-1.5],[1.33333,1,0.5]],
"edge":[[0,14],[14,15],[12,15],[12,13],[11,13],[10,11],[8,10],[8,9],[7,9],[6,7],[4,6],[4,5],[2,5],[2,3],[1,3],[0,1],[0,170],[170,171],[148,171],[148,149],[122,149],[122,123],[101,123],[100,101],[42,100],[42,43],[17,43],[16,17],[1,16],[16,19],[3,19],[18,19],[2,18],[18,23],[5,23],[22,23],[4,22],[22,26],[6,26],[26,27],[7,27],[27,31],[9,31],[30,31],[8,30],[30,32],[10,32],[32,33],[11,33],[33,38],[13,38],[38,39],[39,61],[60,61],[36,60],[36,37],[12,37],[37,41],[15,41],[40,41],[14,40],[36,40],[60,62],[62,168],[164,168],[164,182],[170,182],[182,183],[181,183],[180,181],[179,180],[178,179],[176,178],[176,177],[175,177],[174,175],[172,174],[172,173],[171,173],[150,173],[148,150],[150,151],[149,151],[125,151],[122,125],[124,125],[124,128],[128,129],[129,132],[132,133],[130,133],[130,131],[127,131],[126,127],[123,126],[104,126],[101,104],[104,105],[105,109],[108,109],[108,111],[110,111],[107,110],[106,107],[102,106],[102,103],[100,103],[45,103],[42,45],[44,45],[44,50],[50,51],[51,55],[54,55],[54,56],[56,57],[57,58],[58,59],[52,59],[52,53],[49,53],[48,49],[47,48],[46,47],[43,46],[20,46],[17,20],[20,21],[21,24],[24,25],[25,29],[28,29],[28,35],[34,35],[34,39],[34,58],[57,93],[93,97],[77,97],[77,81],[63,81],[61,63],[62,63],[80,81],[80,121],[120,121],[120,146],[146,147],[147,169],[168,169],[165,169],[164,165],[78,79],[79,99],[98,99],[98,118],[118,119],[119,145],[144,145],[144,166],[166,167],[167,183],[143,165],[142,143],[116,142],[116,117],[78,117],[117,121],[78,80],[76,79],[76,77],[96,97],[76,96],[96,99],[92,94],[94,95],[95,98],[92,93],[56,75],[74,75],[74,92],[70,134],[134,136],[112,136],[112,114],[94,114],[70,74],[71,75],[70,71],[55,72],[72,73],[73,91],[90,91],[90,156],[156,157],[157,177],[135,176],[134,135],[54,71],[135,137],[136,137],[137,178],[158,179],[158,159],[138,159],[138,139],[113,139],[112,113],[113,119],[115,118],[114,115],[95,115],[139,145],[138,140],[140,141],[141,144],[141,162],[162,166],[162,163],[163,167],[163,181],[140,161],[160,161],[160,180],[158,160],[159,161],[153,175],[153,157],[152,153],[155,156],[154,155],[152,154],[129,152],[132,154],[88,110],[111,133],[89,155],[88,89],[86,88],[89,90],[87,91],[86,87],[66,84],[84,85],[85,106],[86,107],[67,87],[66,67],[64,65],[65,66],[67,73],[69,72],[68,69],[64,68],[44,64],[50,68],[51,69],[83,102],[82,83],[65,82],[82,84],[83,85],[108,130],[109,131],[105,127],[128,174],[124,172],[116,120],[142,146],[143,147],[35,59],[28,52],[29,53],[25,49],[24,48],[21,47]],
"face":[[0,2,3,1],[0,4,5,2],[0,14,10,4],[6,8,9,7],[10,12,13,11],[14,15,12,10],[16,19,20,17],[18,23,24,21],[22,26,29,25],[27,31,33,35,28],[30,32,33,31],[33,38,39,34],[36,37,41,40],[42,43,46,45],[44,46,51,50],[46,47,57,55],[48,49,53,52],[48,52,59,58],[54,55,57,56],[60,62,63,61],[64,68,66,65],[66,68,69,67],[67,69,72,73],[70,71,75,74],[76,77,81,79],[78,79,81,80],[82,84,85,83],[86,87,89,88],[87,91,90,89],[92,93,97,94],[95,96,99,98],[100,103,104,101],[102,106,109,105],[107,110,111,108],[112,114,115,113],[113,115,118,119],[116,117,121,120],[122,123,126,125],[124,127,131,128],[129,130,133,132],[134,136,137,135],[138,139,141,140],[139,145,144,141],[142,146,147,143],[148,149,151,150],[152,154,155,153],[153,155,156,157],[158,159,161,160],[162,166,167,163],[164,165,169,168],[170,171,173,172],[170,172,178,182],[174,175,177,176],[178,179,180,182],[180,181,183,182],[0,1,149,148],[0,148,171,170],[16,17,43,42],[100,101,123,122],[2,18,19,3],[4,22,23,5],[6,7,27,26],[8,30,31,9],[10,11,33,32],[12,37,38,13],[36,60,61,39],[14,40,41,15],[20,21,47,46],[24,25,49,48],[28,52,53,29],[34,58,59,35],[44,64,65,45],[65,82,83,45],[83,102,103,45],[50,51,69,68],[54,71,72,55],[70,90,91,73],[90,70,134,135],[135,176,156,90],[156,176,177,157],[56,57,93,75],[75,93,92,74],[62,80,81,63],[62,120,121,80],[62,168,146,120],[168,169,147,146],[66,67,87,84],[85,86,107,106],[76,96,97,77],[78,98,99,79],[78,117,118,98],[116,142,145,119],[143,165,166,144],[164,182,183,167],[88,89,111,110],[111,89,155,133],[133,155,154,132],[94,95,115,114],[104,105,127,126],[108,130,131,109],[112,113,139,136],[137,138,159,158],[137,158,179,178],[124,150,151,125],[124,172,173,150],[128,129,152,174],[174,152,153,175],[140,141,162,161],[160,163,181,180],[0,170,60,36],[0,36,40,14],[60,170,182],[60,164,168,62],[1,3,19,16],[2,5,23,18],[4,6,26,22],[7,9,31,27],[8,10,32,30],[11,13,38,33],[12,15,41,37],[17,20,46,43],[21,24,48,47],[25,29,53,49],[28,35,59,52],[34,39,61,58],[57,58,97,93],[58,63,81,77],[42,45,103,100],[44,50,68,64],[51,55,72,69],[54,56,75,71],[65,66,84,82],[67,73,91,87],[70,74,136,134],[92,94,114,112],[76,79,99,96],[78,80,121,117],[83,85,106,102],[86,88,110,107],[89,90,156,155],[95,98,118,115],[101,104,126,123],[105,109,131,127],[108,111,133,130],[113,119,145,139],[116,120,146,142],[122,125,151,149],[124,128,174,172],[129,132,154,152],[135,137,178,176],[138,140,161,159],[141,144,166,162],[143,147,169,165],[148,150,173,171],[153,157,177,175],[158,160,180,179],[163,167,183,181]]},

Histoscape8x8new : {
"name":"Histoscape8x8new",
"category":["Handmade"],
"vertex":[[-1.6,-1.2,-1.8],[-1.6,-1.2,0.6],[-1.6,-0.8,-0.2],[-1.6,-0.8,0.6],[-1.6,0,-0.2],[-1.6,0,1.4],[-1.6,0.4,-0.2],[-1.6,0.4,1.4],[-1.6,0.8,-0.2],[-1.6,0.8,0.2],[-1.6,1.6,-1.8],[-1.6,1.6,0.2],[-1.2,-1.6,-1.8],[-1.2,-1.6,-1.4],[-1.2,-1.2,-1.8],[-1.2,-1.2,-1.4],[-1.2,-1.2,-0.6],[-1.2,-1.2,0.6],[-1.2,-0.8,-1.8],[-1.2,-0.8,-0.6],[-1.2,-0.8,-0.2],[-1.2,-0.8,0.6],[-1.2,-0.4,-1.8],[-1.2,-0.4,-0.2],[-1.2,0,0.2],[-1.2,0,1.4],[-1.2,0.4,0.2],[-1.2,0.4,1.4],[-1.2,0.8,-0.2],[-1.2,0.8,0.2],[-1.2,1.2,-1.4],[-1.2,1.2,-0.2],[-1.2,1.6,-1.4],[-1.2,1.6,0.2],[-0.8,-1.6,-1.4],[-0.8,-1.6,0.6],[-0.8,-1.2,-1.4],[-0.8,-1.2,-0.6],[-0.8,-1.2,0.6],[-0.8,-1.2,1.4],[-0.8,-0.8,-1.8],[-0.8,-0.8,-0.6],[-0.8,-0.8,0.6],[-0.8,-0.8,1.4],[-0.8,-0.4,-1.8],[-0.8,-0.4,-0.2],[-0.8,-0.4,0.6],[-0.8,-0.4,1.4],[-0.8,0,-0.2],[-0.8,0,0.2],[-0.8,0,1.4],[-0.8,0,1.8],[-0.8,0.4,-0.2],[-0.8,0.4,0.2],[-0.8,0.4,1],[-0.8,0.4,1.8],[-0.8,0.8,0.2],[-0.8,0.8,1],[-0.8,1.2,-1.4],[-0.8,1.2,-0.2],[-0.8,1.6,-1.4],[-0.8,1.6,0.2],[-0.4,-1.6,-0.6],[-0.4,-1.6,0.6],[-0.4,-1.2,-0.6],[-0.4,-1.2,0.2],[-0.4,-1.2,0.6],[-0.4,-1.2,1.4],[-0.4,-0.8,-1],[-0.4,-0.8,0.2],[-0.4,-0.8,0.6],[-0.4,-0.8,1.4],[-0.4,-0.4,-1.4],[-0.4,-0.4,-1],[-0.4,-0.4,0.6],[-0.4,-0.4,1.4],[-0.4,0,-1.4],[-0.4,0,-0.6],[-0.4,0,1.4],[-0.4,0,1.8],[-0.4,0.4,-1.4],[-0.4,0.4,-0.6],[-0.4,0.4,1],[-0.4,0.4,1.8],[-0.4,0.8,-1.8],[-0.4,0.8,-1.4],[-0.4,0.8,0.2],[-0.4,0.8,1],[-0.4,1.2,-1.8],[-0.4,1.2,-0.2],[-0.4,1.6,-0.2],[-0.4,1.6,0.2],[0,-1.6,-0.6],[0,-1.6,1.4],[0,-1.2,-0.6],[0,-1.2,0.2],[0,-1.2,0.6],[0,-1.2,1.4],[0,-0.8,-1],[0,-0.8,-0.2],[0,-0.8,0.2],[0,-0.8,0.6],[0,-0.4,-1.4],[0,-0.4,-1],[0,-0.4,-0.2],[0,-0.4,1.8],[0,0,-1.4],[0,0,-0.6],[0,0,0.6],[0,0,1.8],[0,0.4,-1.4],[0,0.4,-0.6],[0,0.4,0.2],[0,0.4,0.6],[0,0.8,-1.4],[0,0.8,0.2],[0,1.2,-1.4],[0,1.2,-0.2],[0,1.6,-1.4],[0,1.6,-0.2],[0.4,-1.6,0.2],[0.4,-1.6,1.4],[0.4,-1.2,-0.2],[0.4,-1.2,0.2],[0.4,-1.2,0.6],[0.4,-1.2,1.4],[0.4,-0.8,-0.2],[0.4,-0.8,0.6],[0.4,0,0.6],[0.4,0,1.8],[0.4,0.4,0.2],[0.4,0.4,0.6],[0.4,0.4,1.4],[0.4,0.4,1.8],[0.4,0.8,-1.8],[0.4,0.8,0.2],[0.4,0.8,1.4],[0.4,0.8,1.8],[0.4,1.2,-1.8],[0.4,1.2,-1.4],[0.4,1.2,0.6],[0.4,1.2,1.8],[0.4,1.6,-1.4],[0.4,1.6,0.6],[0.8,-1.2,-1.8],[0.8,-1.2,-0.2],[0.8,-0.8,-1.8],[0.8,-0.8,-0.6],[0.8,-0.4,-0.6],[0.8,-0.4,-0.2],[0.8,-0.4,0.2],[0.8,-0.4,1.8],[0.8,0,0.2],[0.8,0,1],[0.8,0.4,-1.4],[0.8,0.4,1],[0.8,0.4,1.4],[0.8,0.4,1.8],[0.8,0.8,-1.4],[0.8,0.8,-0.6],[0.8,0.8,1.4],[0.8,0.8,1.8],[0.8,1.2,-0.6],[0.8,1.2,-0.2],[0.8,1.2,0.6],[0.8,1.2,1.8],[0.8,1.6,-0.2],[0.8,1.6,0.6],[1.2,-1.6,0.2],[1.2,-1.6,1.8],[1.2,-1.2,0.2],[1.2,-1.2,1.8],[1.2,-0.8,-1.4],[1.2,-0.8,-0.6],[1.2,-0.4,-1.4],[1.2,-0.4,-0.6],[1.2,0,0.2],[1.2,0,1],[1.2,0.4,-1.4],[1.2,0.4,-1],[1.2,0.4,0.2],[1.2,0.4,1],[1.2,0.8,-1.4],[1.2,0.8,-1],[1.2,0.8,-0.6],[1.2,0.8,0.6],[1.2,1.2,-0.6],[1.2,1.2,-0.2],[1.2,1.6,-0.2],[1.2,1.6,0.6],[1.6,-1.6,-1.8],[1.6,-1.6,1.8],[1.6,-1.2,-1.8],[1.6,-1.2,1.8],[1.6,-0.8,-1.8],[1.6,-0.8,-1.4],[1.6,-0.4,-1.4],[1.6,-0.4,0.2],[1.6,0.4,-1],[1.6,0.4,0.2],[1.6,0.8,-1],[1.6,0.8,0.6],[1.6,1.6,-1.8],[1.6,1.6,0.6]],
"edge":[[0,10],[10,11],[9,11],[8,9],[6,8],[6,7],[5,7],[4,5],[2,4],[2,3],[1,3],[0,1],[0,14],[14,15],[15,36],[36,37],[16,37],[16,17],[1,17],[17,21],[3,21],[20,21],[2,20],[20,23],[23,45],[45,48],[4,48],[48,49],[24,49],[24,25],[5,25],[25,27],[7,27],[26,27],[26,53],[52,53],[6,52],[52,59],[31,59],[28,31],[8,28],[28,29],[9,29],[29,33],[11,33],[32,33],[32,60],[60,61],[61,91],[90,91],[90,119],[118,119],[118,142],[142,143],[143,167],[166,167],[166,188],[188,189],[189,203],[202,203],[10,202],[194,202],[146,194],[144,146],[144,192],[190,192],[12,190],[12,14],[12,13],[13,15],[13,34],[34,36],[34,35],[35,38],[38,39],[39,43],[42,43],[42,46],[46,47],[47,50],[50,51],[51,55],[54,55],[54,57],[56,57],[56,61],[58,60],[58,59],[49,53],[44,45],[40,44],[40,41],[37,41],[19,41],[16,19],[18,19],[18,22],[22,23],[22,44],[18,40],[24,26],[30,31],[30,58],[30,32],[56,86],[86,91],[62,64],[64,65],[65,69],[68,69],[68,73],[72,73],[72,76],[76,77],[77,81],[80,81],[80,85],[84,85],[84,88],[88,89],[89,90],[86,87],[82,87],[82,83],[79,83],[78,79],[75,78],[74,75],[70,74],[70,71],[67,71],[66,67],[63,66],[62,63],[190,191],[169,191],[168,169],[120,168],[120,121],[93,121],[92,93],[62,92],[35,63],[38,66],[39,67],[43,71],[42,70],[46,74],[47,75],[50,78],[51,79],[55,83],[54,82],[57,87],[92,94],[64,94],[94,95],[65,95],[95,100],[69,100],[100,101],[101,127],[126,127],[99,126],[98,99],[68,98],[98,103],[73,103],[102,103],[72,102],[102,106],[76,106],[106,107],[77,107],[107,111],[81,111],[110,111],[80,110],[110,114],[85,114],[114,115],[115,135],[134,135],[84,134],[134,138],[88,138],[138,139],[116,139],[116,117],[89,117],[117,119],[116,118],[139,142],[128,129],[129,133],[132,133],[132,136],[136,137],[137,141],[140,141],[140,143],[130,135],[130,131],[128,131],[108,128],[113,131],[108,113],[99,104],[104,105],[105,109],[108,109],[112,113],[112,115],[112,130],[109,129],[105,151],[151,157],[133,157],[156,157],[132,156],[156,160],[136,160],[160,161],[137,161],[161,165],[141,165],[164,165],[140,164],[164,167],[150,152],[152,153],[153,155],[154,155],[154,158],[158,159],[159,162],[162,163],[163,166],[150,151],[104,149],[148,149],[148,175],[174,175],[174,196],[196,197],[150,197],[197,199],[180,199],[176,180],[152,176],[176,177],[153,177],[177,181],[155,181],[180,181],[198,199],[179,198],[178,179],[154,178],[178,182],[158,182],[182,183],[183,200],[200,201],[185,201],[184,185],[159,184],[184,186],[162,186],[186,187],[163,187],[187,188],[185,189],[201,203],[198,200],[195,196],[194,195],[172,195],[172,173],[147,173],[146,147],[147,148],[145,149],[144,145],[122,123],[123,170],[170,171],[171,193],[192,193],[122,145],[122,126],[120,123],[124,127],[124,125],[121,125],[97,125],[93,97],[96,97],[96,101],[96,124],[168,170],[169,171],[191,193],[173,175],[172,174],[179,183]],
"face":[[0,2,3,1],[0,10,8,2],[10,11,9,8],[4,6,7,5],[12,14,15,13],[16,17,21,20],[16,20,23,19],[19,23,22,18],[24,25,27,26],[28,29,33,31],[30,31,33,32],[34,36,38,35],[37,41,43,39],[40,44,46,42],[45,48,50,47],[49,53,55,51],[52,56,57,54],[52,59,61,56],[58,60,61,59],[62,63,66,64],[65,67,71,69],[68,70,74,73],[72,75,78,76],[77,79,83,81],[80,82,87,85],[84,86,89,88],[92,94,97,93],[95,100,101,96],[98,103,104,99],[102,106,109,105],[107,111,113,108],[110,114,115,112],[116,117,119,118],[120,121,125,123],[122,124,127,126],[128,131,133,129],[130,135,136,132],[134,138,141,137],[139,142,143,140],[144,145,147,146],[145,149,148,147],[150,151,153,152],[151,157,155,153],[154,156,160,158],[159,161,165,162],[163,164,167,166],[168,170,171,169],[172,173,175,174],[176,177,181,180],[178,182,183,179],[184,186,187,185],[185,187,188,189],[190,191,193,192],[194,195,196,202],[196,197,199,198],[196,198,200,202],[200,201,203,202],[0,1,17,14],[15,16,37,36],[2,20,21,3],[4,5,25,24],[4,24,49,48],[6,26,27,7],[6,52,53,26],[8,9,29,28],[10,32,33,11],[10,202,142,32],[60,90,91,61],[142,202,188,166],[60,118,119,90],[142,166,167,143],[188,202,203,189],[12,13,34,190],[34,62,92,190],[34,35,63,62],[92,93,121,120],[92,120,168,190],[168,169,191,190],[18,40,41,19],[22,23,45,44],[30,58,59,31],[38,39,67,66],[42,70,71,43],[46,47,75,74],[50,51,79,78],[54,82,83,55],[56,86,87,57],[64,65,95,94],[68,98,100,69],[99,126,127,101],[72,102,103,73],[76,77,107,106],[80,110,111,81],[84,134,114,85],[114,134,135,115],[88,116,139,138],[88,89,117,116],[96,124,125,97],[104,105,151,149],[148,150,197,175],[175,197,196,174],[108,128,129,109],[112,130,131,113],[122,145,170,123],[144,192,170,145],[192,193,171,170],[132,156,157,133],[136,137,161,160],[140,164,165,141],[146,147,173,172],[146,172,195,194],[152,153,177,176],[154,178,181,155],[179,198,199,180],[158,159,184,182],[183,185,201,200],[162,163,187,186],[0,18,22,10],[22,44,88,10],[88,138,202,10],[40,84,88,44],[40,194,134,84],[134,194,202,138],[0,144,146,18],[12,190,192,14],[1,3,21,17],[2,4,23,20],[23,4,48,45],[5,7,27,25],[6,8,28,52],[28,31,59,52],[9,11,33,29],[13,15,36,34],[16,19,41,37],[24,26,53,49],[30,32,60,58],[35,38,66,63],[39,43,71,67],[42,46,74,70],[47,50,78,75],[51,55,83,79],[54,57,87,82],[56,61,91,86],[62,64,94,92],[65,69,100,95],[68,73,103,98],[72,76,106,102],[77,81,111,107],[80,85,114,110],[89,90,119,117],[93,97,125,121],[96,101,127,124],[99,104,149,126],[126,149,145,122],[105,109,129,151],[151,129,133,157],[108,113,131,128],[112,115,135,130],[116,118,142,139],[120,123,170,168],[132,136,160,156],[137,141,165,161],[140,143,167,164],[147,148,175,173],[150,152,176,197],[197,176,180,199],[153,155,181,177],[154,158,182,178],[159,162,186,184],[163,166,188,187],[169,171,193,191],[172,174,196,195],[179,183,200,198],[185,189,203,201]]},

Keyboard : {
"name":"Keyboard",
"category":["Handmade"],
"vertex":[[-1.18118,-0.324042,0],[-1.05575,-0.324042,0],[-0.84669,-0.324042,0],[-0.721254,-0.324042,0],[-0.365854,-0.324042,0],[-0.240418,-0.324042,0],[-0.0627178,-0.324042,0],[0.0627178,-0.324042,0],[0.240418,-0.324042,0],[0.365854,-0.324042,0],[0.721254,-0.324042,0],[0.84669,-0.324042,0],[1.05575,-0.324042,0],[1.18118,-0.324042,0],[-1.18118,-0.229965,0.125436],[-1.05575,-0.229965,0.125436],[-0.84669,-0.229965,0.125436],[-0.721254,-0.229965,0.125436],[-0.365854,-0.229965,0.125436],[-0.240418,-0.229965,0.125436],[-0.0627178,-0.229965,0.125436],[0.0627178,-0.229965,0.125436],[0.240418,-0.229965,0.125436],[0.365854,-0.229965,0.125436],[0.721254,-0.229965,0.125436],[0.84669,-0.229965,0.125436],[1.05575,-0.229965,0.125436],[1.18118,-0.229965,0.125436],[-1.18118,0.689895,0.125436],[-1.05575,0.689895,0.125436],[-0.84669,0.689895,0.125436],[-0.721254,0.689895,0.125436],[-0.365854,0.689895,0.125436],[-0.240418,0.689895,0.125436],[-0.0627178,0.689895,0.125436],[0.0627178,0.689895,0.125436],[0.240418,0.689895,0.125436],[0.365854,0.689895,0.125436],[0.721254,0.689895,0.125436],[0.84669,0.689895,0.125436],[1.05575,0.689895,0.125436],[1.18118,0.689895,0.125436],[-1.18118,0.752613,0],[-1.05575,0.752613,0],[-0.84669,0.752613,0],[-0.721254,0.752613,0],[-0.365854,0.752613,0],[-0.240418,0.752613,0],[-0.0627178,0.752613,0],[0.0627178,0.752613,0],[0.240418,0.752613,0],[0.365854,0.752613,0],[0.721254,0.752613,0],[0.84669,0.752613,0],[1.05575,0.752613,0],[1.18118,0.752613,0],[-1.18118,0.940767,0],[-1.05575,0.940767,0],[-0.84669,0.940767,0],[-0.721254,0.940767,0],[-0.365854,0.940767,0],[-0.240418,0.940767,0],[-0.0627178,0.940767,0],[0.0627178,0.940767,0],[0.240418,0.940767,0],[0.365854,0.940767,0],[0.721254,0.940767,0],[0.84669,0.940767,0],[1.05575,0.940767,0],[1.18118,0.940767,0],[-1.18118,-0.324042,-0.209059],[-1.05575,-0.324042,-0.209059],[-0.84669,-0.324042,-0.209059],[-0.721254,-0.324042,-0.209059],[-0.365854,-0.324042,-0.209059],[-0.240418,-0.324042,-0.209059],[-0.0627178,-0.324042,-0.209059],[0.0627178,-0.324042,-0.209059],[0.240418,-0.324042,-0.209059],[0.365854,-0.324042,-0.209059],[0.721254,-0.324042,-0.209059],[0.84669,-0.324042,-0.209059],[1.05575,-0.324042,-0.209059],[1.18118,-0.324042,-0.209059],[-1.18118,0.940767,-0.209059],[-1.05575,0.940767,-0.209059],[-0.84669,0.940767,-0.209059],[-0.721254,0.940767,-0.209059],[-0.365854,0.940767,-0.209059],[-0.240418,0.940767,-0.209059],[-0.0627178,0.940767,-0.209059],[0.0627178,0.940767,-0.209059],[0.240418,0.940767,-0.209059],[0.365854,0.940767,-0.209059],[0.721254,0.940767,-0.209059],[0.84669,0.940767,-0.209059],[1.05575,0.940767,-0.209059],[1.18118,0.940767,-0.209059],[-1.5,0.773519,0.209059],[1.5,0.773519,0.209059],[1.5,0.773519,-0.209059],[1.37456,0.773519,-0.209059],[1.37456,0.773519,0.0313589],[-1.37456,0.773519,0.0313589],[-1.37456,0.773519,-0.209059],[-1.5,0.773519,-0.209059],[-1.5,0.940767,0.209059],[1.5,0.940767,0.209059],[1.5,0.940767,-0.209059],[1.37456,0.940767,-0.209059],[1.37456,0.940767,0.0313589],[-1.37456,0.940767,0.0313589],[-1.37456,0.940767,-0.209059],[-1.5,0.940767,-0.209059],[-1.34321,-0.940767,0],[-1.10279,-0.940767,0],[-1.07143,-0.940767,0],[-0.83101,-0.940767,0],[-0.799652,-0.940767,0],[-0.559233,-0.940767,0],[-0.527875,-0.940767,0],[-0.287456,-0.940767,0],[-0.256098,-0.940767,0],[-0.0156794,-0.940767,0],[0.0156794,-0.940767,0],[0.256098,-0.940767,0],[0.287456,-0.940767,0],[0.527875,-0.940767,0],[0.559233,-0.940767,0],[0.799652,-0.940767,0],[0.83101,-0.940767,0],[1.07143,-0.940767,0],[1.10279,-0.940767,0],[1.34321,-0.940767,0],[-1.21254,-0.355401,0],[-1.10279,-0.355401,0],[-1.07143,-0.355401,0],[-1.02439,-0.355401,0],[-0.878049,-0.355401,0],[-0.83101,-0.355401,0],[-0.799652,-0.355401,0],[-0.689895,-0.355401,0],[-0.397213,-0.355401,0],[-0.287456,-0.355401,0],[-0.256098,-0.355401,0],[-0.209059,-0.355401,0],[-0.0940767,-0.355401,0],[-0.0156794,-0.355401,0],[0.0156794,-0.355401,0],[0.0940767,-0.355401,0],[0.209059,-0.355401,0],[0.256098,-0.355401,0],[0.287456,-0.355401,0],[0.397213,-0.355401,0],[0.689895,-0.355401,0],[0.799652,-0.355401,0],[0.83101,-0.355401,0],[0.878049,-0.355401,0],[1.02439,-0.355401,0],[1.07143,-0.355401,0],[1.10279,-0.355401,0],[1.21254,-0.355401,0],[-1.34321,0.940767,0],[-1.21254,0.940767,0],[-1.02439,0.940767,0],[-0.878049,0.940767,0],[-0.689895,0.940767,0],[-0.559233,0.940767,0],[-0.527875,0.940767,0],[-0.397213,0.940767,0],[-0.209059,0.940767,0],[-0.0940767,0.940767,0],[0.0940767,0.940767,0],[0.209059,0.940767,0],[0.397213,0.940767,0],[0.527875,0.940767,0],[0.559233,0.940767,0],[0.689895,0.940767,0],[0.878049,0.940767,0],[1.02439,0.940767,0],[1.21254,0.940767,0],[1.34321,0.940767,0],[-1.34321,-0.794425,-0.209059],[-1.10279,-0.794425,-0.209059],[-1.07143,-0.794425,-0.209059],[-0.83101,-0.794425,-0.209059],[-0.799652,-0.794425,-0.209059],[-0.559233,-0.794425,-0.209059],[-0.527875,-0.794425,-0.209059],[-0.287456,-0.794425,-0.209059],[-0.256098,-0.794425,-0.209059],[-0.0156794,-0.794425,-0.209059],[0.0156794,-0.794425,-0.209059],[0.256098,-0.794425,-0.209059],[0.287456,-0.794425,-0.209059],[0.527875,-0.794425,-0.209059],[0.559233,-0.794425,-0.209059],[0.799652,-0.794425,-0.209059],[0.83101,-0.794425,-0.209059],[1.07143,-0.794425,-0.209059],[1.10279,-0.794425,-0.209059],[1.34321,-0.794425,-0.209059],[-1.21254,-0.355401,-0.209059],[-1.10279,-0.355401,-0.209059],[-1.07143,-0.355401,-0.209059],[-1.02439,-0.355401,-0.209059],[-0.878049,-0.355401,-0.209059],[-0.83101,-0.355401,-0.209059],[-0.799652,-0.355401,-0.209059],[-0.689895,-0.355401,-0.209059],[-0.397213,-0.355401,-0.209059],[-0.287456,-0.355401,-0.209059],[-0.256098,-0.355401,-0.209059],[-0.209059,-0.355401,-0.209059],[-0.0940767,-0.355401,-0.209059],[-0.0156794,-0.355401,-0.209059],[0.0156794,-0.355401,-0.209059],[0.0940767,-0.355401,-0.209059],[0.209059,-0.355401,-0.209059],[0.256098,-0.355401,-0.209059],[0.287456,-0.355401,-0.209059],[0.397213,-0.355401,-0.209059],[0.689895,-0.355401,-0.209059],[0.799652,-0.355401,-0.209059],[0.83101,-0.355401,-0.209059],[0.878049,-0.355401,-0.209059],[1.02439,-0.355401,-0.209059],[1.07143,-0.355401,-0.209059],[1.10279,-0.355401,-0.209059],[1.21254,-0.355401,-0.209059],[-1.34321,0.940767,-0.209059],[-1.21254,0.940767,-0.209059],[-1.02439,0.940767,-0.209059],[-0.878049,0.940767,-0.209059],[-0.689895,0.940767,-0.209059],[-0.559233,0.940767,-0.209059],[-0.527875,0.940767,-0.209059],[-0.397213,0.940767,-0.209059],[-0.209059,0.940767,-0.209059],[-0.0940767,0.940767,-0.209059],[0.0940767,0.940767,-0.209059],[0.209059,0.940767,-0.209059],[0.397213,0.940767,-0.209059],[0.527875,0.940767,-0.209059],[0.559233,0.940767,-0.209059],[0.689895,0.940767,-0.209059],[0.878049,0.940767,-0.209059],[1.02439,0.940767,-0.209059],[1.21254,0.940767,-0.209059],[1.34321,0.940767,-0.209059]],
"edge":[[98,99],[99,100],[100,101],[101,102],[102,103],[103,104],[104,105],[98,105],[98,106],[106,113],[105,113],[104,112],[112,113],[106,107],[107,108],[108,109],[109,110],[110,111],[111,112],[103,111],[102,110],[101,109],[100,108],[99,107],[0,14],[14,28],[28,42],[42,56],[56,84],[70,84],[0,70],[0,1],[1,71],[70,71],[71,85],[84,85],[57,85],[56,57],[43,57],[42,43],[29,43],[28,29],[15,29],[14,15],[1,15],[2,16],[16,30],[30,44],[44,58],[58,86],[72,86],[2,72],[2,3],[3,73],[72,73],[73,87],[86,87],[59,87],[58,59],[45,59],[44,45],[31,45],[30,31],[17,31],[16,17],[3,17],[4,18],[18,32],[32,46],[46,60],[60,88],[74,88],[4,74],[4,5],[5,75],[74,75],[75,89],[88,89],[61,89],[60,61],[47,61],[46,47],[33,47],[32,33],[19,33],[18,19],[5,19],[6,20],[20,34],[34,48],[48,62],[62,90],[76,90],[6,76],[6,7],[7,77],[76,77],[77,91],[90,91],[63,91],[62,63],[49,63],[48,49],[35,49],[34,35],[21,35],[20,21],[7,21],[8,22],[22,36],[36,50],[50,64],[64,92],[78,92],[8,78],[8,9],[9,79],[78,79],[79,93],[92,93],[65,93],[64,65],[51,65],[50,51],[37,51],[36,37],[23,37],[22,23],[9,23],[10,24],[24,38],[38,52],[52,66],[66,94],[80,94],[10,80],[10,11],[11,81],[80,81],[81,95],[94,95],[67,95],[66,67],[53,67],[52,53],[39,53],[38,39],[25,39],[24,25],[11,25],[12,26],[26,40],[40,54],[54,68],[68,96],[82,96],[12,82],[12,13],[13,83],[82,83],[83,97],[96,97],[69,97],[68,69],[55,69],[54,55],[41,55],[40,41],[27,41],[26,27],[13,27],[114,115],[115,135],[134,135],[134,163],[162,163],[114,162],[114,182],[182,230],[162,230],[230,231],[163,231],[202,231],[134,202],[202,203],[135,203],[183,203],[115,183],[182,183],[116,117],[117,139],[138,139],[138,165],[164,165],[137,164],[136,137],[116,136],[116,184],[184,204],[136,204],[204,205],[137,205],[205,232],[164,232],[232,233],[165,233],[206,233],[138,206],[206,207],[139,207],[185,207],[117,185],[184,185],[118,119],[119,167],[166,167],[141,166],[140,141],[118,140],[118,186],[186,208],[140,208],[208,209],[141,209],[209,234],[166,234],[234,235],[167,235],[187,235],[119,187],[186,187],[120,121],[121,143],[142,143],[142,169],[168,169],[120,168],[120,188],[188,236],[168,236],[236,237],[169,237],[210,237],[142,210],[210,211],[143,211],[189,211],[121,189],[188,189],[122,123],[123,147],[146,147],[146,171],[170,171],[145,170],[144,145],[122,144],[122,190],[190,212],[144,212],[212,213],[145,213],[213,238],[170,238],[238,239],[171,239],[214,239],[146,214],[214,215],[147,215],[191,215],[123,191],[190,191],[124,125],[125,151],[150,151],[150,173],[172,173],[149,172],[148,149],[124,148],[124,192],[192,216],[148,216],[216,217],[149,217],[217,240],[172,240],[240,241],[173,241],[218,241],[150,218],[218,219],[151,219],[193,219],[125,193],[192,193],[126,127],[127,175],[174,175],[153,174],[152,153],[126,152],[126,194],[194,220],[152,220],[220,221],[153,221],[221,242],[174,242],[242,243],[175,243],[195,243],[127,195],[194,195],[128,129],[129,155],[154,155],[154,177],[176,177],[128,176],[128,196],[196,244],[176,244],[244,245],[177,245],[222,245],[154,222],[222,223],[155,223],[197,223],[129,197],[196,197],[130,131],[131,159],[158,159],[158,179],[178,179],[157,178],[156,157],[130,156],[130,198],[198,224],[156,224],[224,225],[157,225],[225,246],[178,246],[246,247],[179,247],[226,247],[158,226],[226,227],[159,227],[199,227],[131,199],[198,199],[132,133],[133,181],[180,181],[161,180],[160,161],[132,160],[132,200],[200,228],[160,228],[228,229],[161,229],[229,248],[180,248],[248,249],[181,249],[201,249],[133,201],[200,201]],
"face":[[114,115,135,134],[114,134,163,162],[116,117,139,136],[137,138,165,164],[118,119,141,140],[141,119,167,166],[120,121,143,142],[120,142,169,168],[122,123,147,144],[145,146,171,170],[124,125,150,148],[149,150,173,172],[126,127,153,152],[153,127,175,174],[128,129,155,154],[128,154,177,176],[130,131,159,156],[157,158,179,178],[132,133,161,160],[161,133,181,180],[182,202,203,183],[182,230,231,202],[184,204,207,185],[205,232,233,206],[186,208,209,187],[209,234,235,187],[188,210,211,189],[188,236,237,210],[190,212,215,191],[213,238,239,214],[192,216,218,193],[217,240,241,218],[194,220,221,195],[221,242,243,195],[196,222,223,197],[196,244,245,222],[198,224,227,199],[225,246,247,226],[200,228,229,201],[229,248,249,201],[114,182,183,115],[116,184,185,117],[118,186,187,119],[120,188,189,121],[122,190,191,123],[124,192,193,125],[126,194,195,127],[128,196,197,129],[130,198,199,131],[132,200,201,133],[230,162,163,231],[232,164,165,233],[234,166,167,235],[236,168,169,237],[238,170,171,239],[240,172,173,241],[242,174,175,243],[244,176,177,245],[246,178,179,247],[248,180,181,249],[134,135,203,202],[136,137,205,204],[138,139,207,206],[140,141,209,208],[142,143,211,210],[144,145,213,212],[146,147,215,214],[148,149,217,216],[150,151,219,218],[152,153,221,220],[154,155,223,222],[156,157,225,224],[158,159,227,226],[160,161,229,228],[114,162,230,182],[134,202,231,163],[115,183,203,135],[116,136,204,184],[137,164,232,205],[138,206,233,165],[117,185,207,139],[118,140,208,186],[141,166,234,209],[119,187,235,167],[120,168,236,188],[142,210,237,169],[121,189,211,143],[122,144,212,190],[145,170,238,213],[146,214,239,171],[123,191,215,147],[124,148,216,192],[149,172,240,217],[150,218,241,173],[125,193,219,151],[126,152,220,194],[153,174,242,221],[127,195,243,175],[128,176,244,196],[154,222,245,177],[129,197,223,155],[130,156,224,198],[157,178,246,225],[158,226,247,179],[131,199,227,159],[132,160,228,200],[161,180,248,229],[133,201,249,181],[0,14,28,42],[0,56,84,70],[1,43,29,15],[1,71,85,57],[2,16,30,44],[2,58,86,72],[3,45,31,17],[3,73,87,59],[4,18,32,46],[4,60,88,74],[5,47,33,19],[5,75,89,61],[6,20,34,48],[6,62,90,76],[7,49,35,21],[7,77,91,63],[8,22,36,50],[8,64,92,78],[9,51,37,23],[9,79,93,65],[10,24,38,52],[10,66,94,80],[11,53,39,25],[11,81,95,67],[12,26,40,54],[12,68,96,82],[13,55,41,27],[13,83,97,69],[70,71,1,0],[72,73,3,2],[74,75,5,4],[76,77,7,6],[78,79,9,8],[80,81,11,10],[82,83,13,12],[0,1,15,14],[2,3,17,16],[4,5,19,18],[6,7,21,20],[8,9,23,22],[10,11,25,24],[12,13,27,26],[14,15,29,28],[16,17,31,30],[18,19,33,32],[20,21,35,34],[22,23,37,36],[24,25,39,38],[26,27,41,40],[28,29,43,42],[30,31,45,44],[32,33,47,46],[34,35,49,48],[36,37,51,50],[38,39,53,52],[40,41,55,54],[56,42,43,57],[58,44,45,59],[60,46,47,61],[62,48,49,63],[64,50,51,65],[66,52,53,67],[68,54,55,69],[56,57,85,84],[58,59,87,86],[60,61,89,88],[62,63,91,90],[64,65,93,92],[66,67,95,94],[68,69,97,96],[84,85,71,70],[86,87,73,72],[88,89,75,74],[90,91,77,76],[92,93,79,78],[94,95,81,80],[96,97,83,82],[98,99,102,103],[102,99,100,101],[98,103,104,105],[111,110,107,106],[109,108,107,110],[113,112,111,106],[98,105,113,106],[99,107,108,100],[101,109,110,102],[103,111,112,104],[106,107,99,98],[108,109,101,100],[112,113,105,104],[103,102,110,111]]},

C8pp : {
"name":"C8++",
"category":["Handmade"],
"vertex":[[1.5,1.5,1.5],[1.5,-1.5,-1.5],[-1.5,1.5,-1.5],[-1.5,-1.5,1.5],[0.375,0.375,-0.75],[-0.75,0.375,0.375],[0.375,-0.75,0.375],[0.11538,0.11538,0.11538]],
"edge":[[1,6],[0,1],[0,3],[3,6],[5,7],[3,5],[6,7],[1,4],[4,7],[2,4],[2,5],[0,2]],
"face":[[0,1,6],[0,2,4],[0,3,5],[1,0,4],[2,0,5],[3,0,6],[7,2,5],[7,4,2],[7,5,3,6],[7,6,1,4]]},

C8pm : {
"name":"C8+-",
"category":["Handmade"],
"vertex":[[1.5,1.2,1.5],[1.5,-1.2,-0.9],[-0.9,1.2,-0.9],[-0.9,-1.2,1.5],[0,-0.3,-1.5],[-1.5,-0.3,0],[0.6,-0.6,0.6],[-0.80137,0.213696,-0.80137]],
"edge":[[1,6],[0,1],[0,3],[3,6],[5,7],[3,5],[6,7],[1,4],[4,7],[2,4],[2,5],[0,2]],
"face":[[0,1,6],[0,2,4],[0,3,5],[1,0,4],[2,0,5],[3,0,6],[7,2,5],[7,4,2],[7,5,3,6],[7,6,1,4]]},

C8mp : {
"name":"C8-+",
"category":["Handmade"],
"vertex":[[1.2,1.5,1.2],[1.2,-0.9,-1.2],[-1.2,1.5,-1.2],[-1.2,-0.9,1.2],[0.3,0.6,-0.6],[-0.6,0.6,0.3],[-0.3,-1.5,-0.3],[-0.25618,0.691008,-0.25618]],
"edge":[[1,6],[0,1],[0,3],[3,6],[5,7],[3,5],[6,7],[1,4],[4,7],[2,4],[2,5],[0,2]],
"face":[[0,1,6],[0,2,4],[0,3,5],[1,0,4],[2,0,5],[3,0,6],[7,2,5],[7,4,2],[7,5,3,6],[7,6,1,4]]},

C8mm : {
"name":"C8--",
"category":["Handmade"],
"vertex":[[1.5,1.5,1.5],[1.5,-0.9,-0.9],[-0.9,1.5,-0.9],[-0.9,-0.9,1.5],[0,0,-1.5],[-1.5,0,0],[0,-1.5,0],[-0.681818,-0.681818,-0.681818]],
"edge":[[1,6],[0,1],[0,3],[3,6],[5,7],[3,5],[6,7],[1,4],[4,7],[2,4],[2,5],[0,2]],
"face":[[0,1,6],[0,2,4],[0,3,5],[1,0,4],[2,0,5],[3,0,6],[7,2,5],[7,4,2],[7,5,3,6],[7,6,1,4]]},

Colonel : {
"name":"Colonel",
"category":["Handmade"],
"vertex":[[0,0.433025,0],[0,1.29908,0.866051],[0,1.29908,-0.866051],[-0.75,-0.866051,0],[-1.5,-1.29908,0.866051],[-1.5,-1.29908,-0.866051],[0.75,-0.866051,0],[1.5,-1.29908,0.866051],[1.5,-1.29908,-0.866051]],
"edge":[[0,1],[1,4],[3,4],[0,3],[2,5],[3,5],[0,2],[2,8],[0,6],[6,8],[5,8],[3,6],[6,7],[4,7],[7,8],[4,5],[1,2],[1,7]],
"face":[[0,1,4,3],[1,2,5,4],[2,0,3,5],[3,4,7,6],[4,5,8,7],[5,3,6,8],[6,7,1,0],[7,8,2,1],[8,6,0,2]]},

ColonelB : {
"name":"ColonelB",
"category":["Handmade"],
"vertex":[[0.4125,-0.6,-0.6],[0.4125,-1.5,-1.5],[-0.4875,0.3,-0.6],[-0.1875,1.5,-0.3],[-1.3875,0.3,-1.5],[-0.1875,-0.3,1.5],[-1.3875,-1.5,0.3],[1.3875,-0.375,-0.375],[1.3875,-0.6,-0.6],[1.3875,-0.075,-0.3],[1.3875,-0.3,-0.075],[-0.2625,-0.6,0.075],[-0.4875,-0.375,0.075],[-0.4125,-0.525,0.525],[-0.7125,-0.825,0.3]],
"edge":[[0,7],[7,9],[3,9],[2,3],[0,2],[1,4],[2,4],[0,1],[1,6],[0,11],[11,14],[6,14],[4,6],[12,14],[2,12],[12,13],[5,13],[3,5],[5,6],[3,4],[8,9],[1,8],[8,10],[5,10],[7,10],[11,13],[11,12]],
"face":[[0,7,9,3,2],[8,1,4,3,9],[1,0,2,4],[2,3,5,13,12],[3,4,6,5],[4,2,12,14,6],[11,13,5,10,7,0],[10,5,6,1,8],[6,14,11,0,1],[7,10,8,9],[11,12,13],[14,12,11]]},

TriTorus7 : {
"name":"TriTorus7",
"category":["Handmade"],
"vertex":[[1.05059,0,0.23545],[0.636896,0.859049,0.23545],[-0.292671,1.07122,0.23545],[-1.03813,0.476736,0.23545],[-1.03813,-0.476736,0.23545],[-0.292671,-1.07122,0.23545],[0.636896,-0.859049,0.23545],[0.95887,0.0818142,0.261611],[0.515743,0.838348,0.261611],[-0.352024,0.963589,0.261611],[-0.990986,0.363228,0.261611],[-0.91999,-0.510652,0.261611],[-0.192498,-1,0.261611],[0.643673,-0.736328,0.261611],[0.95887,-0.0818142,0.261611],[0.643673,0.736328,0.261611],[-0.192498,1,0.261611],[-0.91999,0.510652,0.261611],[-0.990986,-0.363228,0.261611],[-0.352024,-0.963589,0.261611],[0.515743,-0.838348,0.261611],[1.46239,0,0.0295497],[0.893649,1.18101,0.0295497],[-0.384305,1.47269,0.0295497],[-1.40915,0.65541,0.0295497],[-1.40915,-0.65541,0.0295497],[-0.384305,-1.47269,0.0295497],[0.893649,-1.18101,0.0295497],[1.46239,0.122721,0],[0.797701,1.25752,0],[-0.50395,1.44538,0],[-1.46239,0.544841,0],[-1.3559,-0.765978,0],[-0.264661,-1.5,0],[0.989596,-1.10449,0],[1.46239,-0.122721,0],[0.989596,1.10449,0],[-0.264661,1.5,0],[-1.3559,0.765978,0],[-1.46239,-0.544841,0],[-0.50395,-1.44538,0],[0.797701,-1.25752,0],[0.99827,0,0.250373],[0.604273,0.818142,0.250373],[-0.281029,1.02021,0.250373],[-0.990986,0.454035,0.250373],[-0.990986,-0.454035,0.250373],[-0.281029,-1.02021,0.250373],[0.604273,-0.818142,0.250373],[1.05059,0,-0.23545],[0.636896,0.859049,-0.23545],[-0.292671,1.07122,-0.23545],[-1.03813,0.476736,-0.23545],[-1.03813,-0.476736,-0.23545],[-0.292671,-1.07122,-0.23545],[0.636896,-0.859049,-0.23545],[0.95887,0.0818142,-0.261611],[0.515743,0.838348,-0.261611],[-0.352024,0.963589,-0.261611],[-0.990986,0.363228,-0.261611],[-0.91999,-0.510652,-0.261611],[-0.192498,-1,-0.261611],[0.643673,-0.736328,-0.261611],[0.95887,-0.0818142,-0.261611],[0.643673,0.736328,-0.261611],[-0.192498,1,-0.261611],[-0.91999,0.510652,-0.261611],[-0.990986,-0.363228,-0.261611],[-0.352024,-0.963589,-0.261611],[0.515743,-0.838348,-0.261611],[1.46239,0,-0.0295497],[0.893649,1.18101,-0.0295497],[-0.384305,1.47269,-0.0295497],[-1.40915,0.65541,-0.0295497],[-1.40915,-0.65541,-0.0295497],[-0.384305,-1.47269,-0.0295497],[0.893649,-1.18101,-0.0295497],[0.99827,0,-0.250373],[0.604273,0.818142,-0.250373],[-0.281029,1.02021,-0.250373],[-0.990986,0.454035,-0.250373],[-0.990986,-0.454035,-0.250373],[-0.281029,-1.02021,-0.250373],[0.604273,-0.818142,-0.250373]],
"edge":[[21,35],[21,28],[28,70],[35,70],[55,62],[62,63],[49,63],[49,70],[34,35],[34,76],[55,76],[54,61],[61,69],[55,69],[41,76],[33,41],[33,75],[54,75],[53,60],[60,68],[54,68],[40,75],[32,40],[32,74],[53,74],[52,59],[59,67],[53,67],[39,74],[31,39],[31,73],[52,73],[51,58],[58,66],[52,66],[38,73],[30,38],[30,72],[51,72],[50,57],[57,65],[51,65],[37,72],[29,37],[29,71],[50,71],[49,56],[56,64],[50,64],[36,71],[28,36],[0,21],[22,36],[1,22],[1,15],[7,15],[0,7],[7,42],[14,42],[0,14],[6,27],[27,34],[13,14],[6,13],[13,48],[20,48],[6,20],[5,26],[26,33],[27,41],[12,20],[5,12],[12,47],[19,47],[5,19],[4,25],[25,32],[26,40],[11,19],[4,11],[11,46],[18,46],[4,18],[3,24],[24,31],[25,39],[10,18],[3,10],[10,45],[17,45],[3,17],[2,23],[23,30],[24,38],[9,17],[2,9],[9,44],[16,44],[2,16],[22,29],[23,37],[8,16],[1,8],[8,43],[15,43],[64,78],[57,78],[63,77],[56,77],[65,79],[58,79],[66,80],[59,80],[67,81],[60,81],[68,82],[61,82],[69,83],[62,83],[42,43],[43,78],[77,78],[42,77],[48,83],[77,83],[42,48],[47,82],[82,83],[47,48],[46,81],[81,82],[46,47],[45,80],[80,81],[45,46],[44,79],[79,80],[44,45],[78,79],[43,44]],
"face":[[35,21,28,70],[36,22,29,71],[37,23,30,72],[38,24,31,73],[39,25,32,74],[40,26,33,75],[41,27,34,76],[42,43,78,77],[43,44,79,78],[44,45,80,79],[45,46,81,80],[46,47,82,81],[47,48,83,82],[48,42,77,83],[0,42,7],[42,0,14],[1,43,8],[43,1,15],[2,44,9],[44,2,16],[3,45,10],[45,3,17],[4,46,11],[46,4,18],[5,47,12],[47,5,19],[6,48,13],[48,6,20],[49,56,77],[77,63,49],[50,57,78],[78,64,50],[51,58,79],[79,65,51],[52,59,80],[80,66,52],[53,60,81],[81,67,53],[54,61,82],[82,68,54],[55,62,83],[83,69,55],[0,7,21],[0,21,14],[1,8,22],[1,22,15],[2,9,23],[2,23,16],[3,10,24],[3,24,17],[4,11,25],[4,25,18],[5,12,26],[5,26,19],[6,13,27],[6,27,20],[7,15,22,36,28,21],[8,16,23,37,29,22],[9,17,24,38,30,23],[10,18,25,39,31,24],[11,19,26,40,32,25],[12,20,27,41,33,26],[13,14,21,35,34,27],[49,70,56],[49,63,70],[50,71,57],[50,64,71],[51,72,58],[51,65,72],[52,73,59],[52,66,73],[53,74,60],[53,67,74],[54,75,61],[54,68,75],[55,76,62],[55,69,76],[56,70,28,36,71,64],[57,71,29,37,72,65],[58,72,30,38,73,66],[59,73,31,39,74,67],[60,74,32,40,75,68],[61,75,33,41,76,69],[62,76,34,35,70,63]]},

};
